/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.cas.mappers.AbstractCASProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class GroupMembershipMapper
extends AbstractCASProtocolMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final String FULL_PATH = "full.path";
    public static final String PROVIDER_ID = "cas-group-membership-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Group Membership";
    }

    public String getHelpText() {
        return "Map user group membership";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCt) {
        LinkedList<String> membership = new LinkedList<String>();
        boolean fullPath = GroupMembershipMapper.useFullPath(mappingModel);
        for (GroupModel group : userSession.getUser().getGroupsStream().collect(Collectors.toSet())) {
            if (fullPath) {
                membership.add(ModelToRepresentation.buildGroupPath((GroupModel)group));
                continue;
            }
            membership.add(group.getName());
        }
        this.setPlainAttribute(attributes, mappingModel, membership);
    }

    public static boolean useFullPath(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(FULL_PATH));
    }

    public static ProtocolMapperModel create(String name, String tokenClaimName, boolean fullPath) {
        ProtocolMapperModel mapper = CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, "String", PROVIDER_ID);
        mapper.getConfig().put(FULL_PATH, Boolean.toString(fullPath));
        return mapper;
    }

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName(FULL_PATH);
        property1.setLabel("Full group path");
        property1.setType("boolean");
        property1.setDefaultValue((Object)"true");
        property1.setHelpText("Include full path to group i.e. /top/level1/level2, false will just specify the group name");
        configProperties.add(property1);
    }
}

