#!/usr/bin/env -S -i bash

env_files="env/.env env/.env.local"
merged_env="env/.env.merge"
if [ -n "$1" ]
then
    env_files="$env_files $1/env/.env $1/env/.env.local"
    merged_env="$1/env/.env.merge"
fi

unset PWD
unset SHLVL
for env_file in $env_files
do
    set -a
    if [ -f "$env_file" ]
    then
        . $env_file
    fi
    set +a
done
unset username
export -p | cut -d" " -f3- | sed "/OLDPWD/d" | head -n -1 | sort > "$merged_env"

exit 0
