#!/bin/bash

run_as() {
    if [ "$(id -u)" = 0 ]; then
        su -p www-data -s /bin/sh -c "$1"
    else
        sh -c "$1"
    fi
}

echo
echo "== INSTALLATION APP NEXTCLOUD ================================================"

echo "== CONFIG"
run_as 'php occ config:system:set trusted_domains 1 --value '${WEB_URL}
run_as 'php occ config:system:set overwrite.cli.url --value '${NEXTCLOUD_URL}
run_as 'php occ config:system:set overwritewebroot --value '${NEXTCLOUD_ALIAS}
run_as 'php occ config:system:set htaccess.RewriteBase --value '${NEXTCLOUD_ALIAS}
run_as 'php occ config:system:set overwriteprotocol --value '${PROTOCOLE}

echo 
echo "== CALENDAR"
run_as 'php occ app:install calendar'
run_as 'php occ app:update calendar'
run_as 'php occ app:enable calendar'

echo 
echo "==GROUP FOLDERS"
run_as 'php occ app:install groupfolders'
run_as 'php occ app:update groupfolders'
run_as 'php occ app:enable groupfolders'

echo 
echo "== DECK"
run_as 'php occ app:install deck'
run_as 'php occ app:update deck'
run_as 'php occ app:enable deck'

echo 
echo "== DRAWIO"
run_as 'php occ app:install drawio'
run_as 'php occ app:update drawio'
run_as 'php occ app:enable drawio'

echo 
echo "== TASKS"
run_as 'php occ app:install tasks'
run_as 'php occ app:update tasks'
run_as 'php occ app:enable tasks'

echo 
echo "== FILES EXTERNAL"
run_as 'php occ app:install files_external'
run_as 'php occ app:update files_external'
run_as 'php occ app:enable files_external'
if [[ "${NEXTCLOUD_SAMBA}" == "1" ]]
then
run_as 'php  occ files_external:import /nine/mount.json -q'
fi

echo 
echo "== FILES MINDMAP"
run_as 'php occ app:install files_mindmap'
run_as 'php occ app:update files_mindmap'
run_as 'php occ app:enable files_mindmap'

echo 
echo "== USER CAS"
if [[ "${MODE_AUTH}" == "CAS" ]]
then
    cp -rf /nine/app/user_cas /var/www/html/custom_apps
    chown www-data:www-data /var/www/html/custom_apps -R
    run_as 'php occ config:app:set user_cas cas_server_hostname --value='${CAS_HOST}' -q'
    run_as 'php occ config:app:set user_cas cas_server_path --value='${CAS_PATH}' -q'
    run_as 'php occ config:app:set user_cas cas_server_port --value='${CAS_PORT}' -q'
    run_as 'php occ config:app:set user_cas cas_use_proxy --value=0 -q'
    run_as 'php occ config:app:set user_cas cas_server_version --value=2.0 -q'
    run_as 'php occ config:app:set user_cas cas_force_login --value=1 -q'
    run_as 'php occ config:app:set user_cas cas_disable_logout --value=0 -q'
    run_as 'php occ app:enable user_cas'
else
    run_as 'php occ app:disable user_cas'
    rm -rf /var/www/html/custom_apps/user_cas
fi

echo 
echo "== USER LDAP"

if [[ "${LDAP_ACTIVATE}" == "1" ]]
then
    run_as 'php occ app:install user_ldap'
    run_as 'php occ app:update user_ldap'
    run_as 'php occ app:enable user_ldap'

    run_as 'php occ config:app:set user_ldap bgjRefreshInterval --value=300 -q'
    run_as 'php occ config:app:set user_ldap cleanUpJobChunkSize --value=300 -q'
    run_as 'php occ config:app:set user_ldap background_sync_interval --value=300 -q'

    run_as 'php occ ldap:show-config s01' > /tmp/nextcloud-ldap.txt
    if grep -q "Invalid configID" /tmp/nextcloud-ldap.txt;then run_as 'php occ ldap:create-empty-config -q'; fi

    run_as 'php occ ldap:set-config s01 ldapHost "${LDAP_HOST}"'
    run_as 'php occ ldap:set-config s01 ldapPort "${LDAP_PORT}"'
    run_as 'php occ ldap:set-config s01 ldapTLS "${LDAP_TLS}"'
    run_as 'php occ ldap:set-config s01 ldapAgentName "${LDAP_USER}"'
    run_as 'php occ ldap:set-config s01 ldapAgentPassword "${LDAP_PASSWORD}"'

    run_as 'php occ ldap:set-config s01 ldapBase "${LDAP_BASEDN}"'
    run_as 'php occ ldap:set-config s01 ldapBaseGroups "${LDAP_BASEGROUP}"'
    run_as 'php occ ldap:set-config s01 ldapBaseUsers "${LDAP_BASEUSER}"'
    run_as 'php occ ldap:set-config s01 ldapConfigurationActive "1"'
    run_as 'php occ ldap:set-config s01 ldapExperiencedAdmin "0"'
    run_as 'php occ ldap:set-config s01 ldapExpertUUIDUserAttr "${LDAP_USERNAME}"'

    run_as 'php occ ldap:set-config s01 ldapLoginFilter "${LDAP_LOGIN_FILTER}"'
    run_as 'php occ ldap:set-config s01 ldapUserFilter "${LDAP_USER_FILTER}"'
    run_as 'php occ ldap:set-config s01 ldapGroupFilter "${LDAP_GROUP_FILTER}"'

    run_as 'php occ ldap:set-config s01 ldapUserDisplayName "${LDAP_DISPLAYNAME}"'

    run_as 'php occ ldap:set-config s01 ldapCacheTTL "300"'
    run_as 'php occ ldap:set-config s01 ldapPagingSize "0"'

#sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapGroupFilterObjectclass "${ldapGroupFilterObjectclass}"
#sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapGroupMemberAssocAttr "${ldapGroupMemberAssocAttr}"
#sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapUserFilterObjectclass "${ldapUserFilterObjectclass}"
#sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapEmailAttribute "${ldapEmailAttribute}"

else
    run_as 'php occ app:disable user_ldap'
fi

echo
echo