#!/bin/bash
echo "INSTALLATION NINEGATE HORS EOLE"
cd /var/www/html/ninegate

www_dir="/var/www/html"

yes | cp scripts/apache/ninegate.conf /etc/apache2/sites-available/
a2ensite ninegate
service apache2 restart

# Récuper les composer associés à la version de php installé
version72=`php -r 'echo version_compare(phpversion(), "7.2.0", ">=");'`
if [[ "$version72" == "1" ]]
then
    cp -rf /var/www/html/ninegate/scripts/php72/composer.json /var/www/html/ninegate/composer.json
    cp -rf /var/www/html/ninegate/scripts/php72/composer.lock /var/www/html/ninegate/composer.lock
else
    version70=`php -r 'echo version_compare(phpversion(), "7.0.0", ">=");'`
    if [[ "$version70" == "1" ]]
    then
        cp -rf /var/www/html/ninegate/scripts/php70/composer.json /var/www/html/ninegate/composer.json
        cp -rf /var/www/html/ninegate/scripts/php70/composer.lock /var/www/html/ninegate/composer.lock
    fi
fi

# Installation des dépendances composer
composer install
rm -f /var/www/html/ninegate/var/logs/dev.log

# Permissions
./perm.sh www-data

# Nettoyage du cache
rm /var/www/html/ninegate/var/cache -rf
php bin/console cache:clear --env=prod --no-debug

# Migration si nécessaire du schéma de la base
php bin/console doctrine:schema:update --force --env=prod --no-debug

# Insertion data de base
php bin/console Core:InitData --env=prod
php bin/console Cron:InitData --env=prod
php bin/console Portal:InitData --env=prod

# Passage des scripts
php bin/console Core:Script --env=prod

# Generation des assets
bin/console assetic:dump --env=prod

# Copie des polices du projet dans le rep web
cp -rf src/Cadoles/CoreBundle/Resources/public/fonts web/

bin/console Core:SetPassword admin admin

# Permissions
./perm.sh www-data