<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints\DateTime;

use Cadoles\CoreBundle\Entity\Registration;

class PurgeRegistrationCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    protected function configure()
    {
        $this
            ->setName('Core:PurgeRegistration')
            ->setDescription('Purge Registration')
            ->setHelp('This command Purge the obsolete Registration')
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')              
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getRootDir()."/../var/logs/";

        $this->writelnred('');
        $this->writelnred('== Core:PurgeRegistration');        
        $this->writelnred('==========================================================================================================');

        $now=new \DateTime('now');


        $datas = $this->em
                ->createQueryBuilder()
                ->select('table')
                ->from('CadolesCoreBundle:Registration','table')
                ->where('table.keyexpire<:now')
                ->setParameter("now",$now->format("Y-m-d H:i:s"))
                ->getQuery()
                ->getResult();
        foreach($datas as $data) {
            $this->writeln('    - Inscription supprimée = '.$data->getkeyexpire()->format("Y-m-d H:i:s")." >> ".$data->getUsername());
            $this->em->remove($data);
            $this->em->flush();            
        }


        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
