<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class AlertType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add("submit", SubmitType::class, [
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('title', TextType::class, [
                'label' => 'Titre'
            ])

            ->add("content",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => array("height" => "500px","filebrowserUploadRoute" => 'cadoles_portal_config_alert_upload')
            ])

            ->add("fghideable",ChoiceType::class,[
                "label"       =>"Permettre aux utilisateurs de masquer l'annonce",
                "choices"     => ["non"=>"0","oui"=>"1"]
            ])

            ->add('alertcategory', EntityType::class, [
                'label'         => 'Catégorie',
                'class'         => 'CadolesPortalBundle:Alertcategory',
                'choice_label'  => 'label',
                'placeholder'   => '-- Sélectionnez une Catégorie --'
            ])

            ->add('roles', ChoiceType::class, [
                "label"         => 'Visible pour les Rôles',
                "choices" => [
                    "Visiteur"              => 'ROLE_ANONYME',
                    "Utilisateur"           => 'ROLE_USER',
                    "Animateur de Groupe"   => 'ROLE_ANIM',
                    "Modérateur"            => 'ROLE_MODO',
                    "Administateur"         => 'ROLE_ADMIN',
                ],                
                "multiple"      => true,
                "expanded"      => true,
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add('niveau01s', Select2EntityType::class, [
                'label'                 => 'Visible pour les '.$options["labelniveau01"],
                'class'                 => 'CadolesCoreBundle:Niveau01',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'cadoles_core_ajax_niveau01_list',
                'primary_key'           => 'id',
                'text_property'         => 'label',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner des '.$options["labelniveau01"],                        
            ])

            ->add('groups', Select2EntityType::class, [
                'label'                 => 'Visible pour les Groupes',
                'class'                 => 'CadolesCoreBundle:Group',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'cadoles_core_ajax_group_list',
                'primary_key'           => 'id',
                'text_property'         => 'label',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner un groupe',                        
            ])

            ->add('items', Select2EntityType::class, [
                'label'                 => 'Visible pour les Items',
                'class'                 => 'CadolesPortalBundle:Item',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'cadoles_core_ajax_item_list',
                'primary_key'           => 'id',
                'text_property'         => 'title',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner des items',                        
            ])
                        
            ->add('publishedat', DateType::class, [
                'label'         => 'Publier du',
                "widget"        => 'single_text',
            ])

            ->add('unpublishedat', DateType::class, [
                'label'         => 'Jusqu\'au',
                'required'      => false,
                "widget"        => 'single_text',
            ]);


            $builder->get('publishedat')->addModelTransformer(new CallbackTransformer(
                function ($value) {
                    if (!$value) {
                        return new \DateTime('now');
                    }
                    return $value;
                },
                function ($value) {
                    return $value;
                }
            ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Alert',
            'mode' => "string",
            'labelniveau01' => "string",
        ]);
    }
}
