<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class BlogarticleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user=$options['user'];
        $blogarticle=$options['blogarticle'];

        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
                'label'         => 'Titre'
            ])
            
            ->add("description",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => ["height" => "500px",'filebrowserUploadRoute' => 'cadoles_portal_'.$options["access"].'_blogarticle_upload']
            ]) 
            
            ->add("fgcomment",ChoiceType::class,[
                    "label"       =>"Permettre les commentaires",
                    "choices"     => ["non"=>"0","oui"=>"1"]
            ])

            ->add('image',HiddenType::class, [
                "label"       =>"image",
                "disabled"    => ($options["mode"]=="delete"?true:false)
            ]);

            if($options["access"]=="config") {
                $builder
                ->add('blog', EntityType::class, [
                    "label"         => 'Blog associé',
                    "class"         => 'CadolesPortalBundle:Blog',
                    "choice_label"  => 'name',
                    "disabled"      => ($options["mode"]=="delete"?true:false),
                ]);                
            }
            else {
                if(!$blogarticle->getBlog()) {
                    $builder
                    ->add('blog', EntityType::class, [
                        'label'         => 'Blog associé',
                        'class'         => 'CadolesPortalBundle:Blog',
                        'choice_label'  => 'name',
                        'placeholder'   => '-- Sélectionnez un Blog --',
                        'query_builder' => function(EntityRepository $er) use ($user) {
                            $qb=$er->createQueryBuilder('blog');
                            return $qb->select('blog')
                                    ->where('blog.user=:user')
                                    ->orwhere(':user MEMBER OF blog.writers')

                                    ->from('CadolesCoreBundle:UserGroup','usergroup')
                                    ->orwhere('usergroup.group MEMBER OF blog.groups AND usergroup.user=:user AND usergroup.rolegroup>=:role')

                                    ->from('CadolesCoreBundle:User','user')
                                    ->andwhere("user=:user")

                                    ->setparameter('user',$user)
                                    ->setparameter('role',50);

                        },               
                    ]);
                }
                else {
                    $builder
                    ->add('blog', EntityType::class, [
                        'label'         => 'Blog associé',
                        'class'         => 'CadolesPortalBundle:Blog',
                        'choice_label'  => 'name',
                        "disabled"      => ($options["mode"]=="update"?true:false),
                        'placeholder'   => '-- Sélectionnez un Blog --',
                        'query_builder' => function(EntityRepository $er) use ($blogarticle) {
                            $qb=$er->createQueryBuilder('blog');
                            return $qb->select('blog')
                                        ->where('blog.id=:blog')
                                        ->setparameter('blog',$blogarticle->getBlog()->getId());
                        },               
                    ]);
                }
            }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Blogarticle',
            'mode' => 'string',
            'access' => 'string',
            'user' => 'Cadoles\CoreBundle\Entity\User',
            'blogarticle' => 'Cadoles\PortalBundle\Entity\Blogarticle'
        ]);
    }
}
