<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class NoticeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $choices=array("oui" => "1","non" => "0");

        $builder
            ->add("submit", SubmitType::class, [
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('title', TextType::class, [
                'label' => 'Titre'
            ])

            ->add("description",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => true,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => array("height" => "500px")
            ])

            
            ->add("mustread",
                ChoiceType::class,array(
                    "label"       => "Doit-être lu et approuvé ?",
                    'disabled'    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                    "choices"     => $choices
                )
            )

     
            ->add('roles', ChoiceType::class, [
                "label"         => 'Visible pour les Rôles',
                "choices" => [
                    "Visiteur"              => 'ROLE_ANONYME',
                    "Utilisateur"           => 'ROLE_USER',
                    "Animateur de Groupe"   => 'ROLE_ANIM',
                    "Modérateur"            => 'ROLE_MODO',
                    "Administateur"         => 'ROLE_ADMIN',
                ],                
                "multiple"      => true,
                "expanded"      => true,
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add('groups', Select2EntityType::class, [
                'label'                 => 'Visible pour les Groupes',
                'class'                 => 'CadolesCoreBundle:Group',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'cadoles_core_ajax_group_list',
                'primary_key'           => 'id',
                'text_property'         => 'label',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner un groupe',                        
            ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Notice',
            'mode' => "string",
        ]);
    }
}
