<?php

namespace Cadoles\WebsocketBundle\Topic;

use Gos\Bundle\WebSocketBundle\Topic\TopicInterface;
use Ratchet\ConnectionInterface;
use Ratchet\Wamp\Topic;
use Gos\Bundle\WebSocketBundle\Router\WampRequest;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface;

use Cadoles\WebsocketBundle\Entity\Message;

class WebsocketCounter implements TopicInterface
{

    protected $em;
    protected $container;
    protected $clientManipulator;

    public function __construct(ClientManipulatorInterface $clientManipulator, EntityManager $em, ContainerInterface $container) {
        $this->clientManipulator = $clientManipulator;
        $this->em = $em;
        $this->container = $container;
    }

    /**
     * This will receive any Subscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {      
        //this will broadcast the message to ALL subscribers of this topic.
        //$topic->broadcast(['log' => $connection->resourceId." has joined ".$topic->getId()." ".$userid]);
    }

    /**
     * This will receive any UnSubscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onUnSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {
        //this will broadcast the message to ALL subscribers of this topic.
        //$topic->broadcast(['msg' => $connection->resourceId . " has left " . $topic->getId()]);
    }


    /**
     * This will receive any Publish requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @param $event
     * @param array $exclude
     * @param array $eligible
     * @return mixed|void
     */
    public function onPublish(ConnectionInterface $connection, Topic $topic, WampRequest $request, $event, array $exclude, array $eligible)
    {
        if(!is_array($event)) $event=json_decode($event, true);
        $userid=$event["userid"];

        $user=$this->em->getRepository("CadolesCoreBundle:User")->find($userid);
        if(!$user)
            return;

        $group=$this->em->getRepository("CadolesCoreBundle:Group")->find($event["group"]);
        if(!$group)
            return;

        /*
        $usergroup=$this->em->getRepository("CadolesCoreBundle:UserGroup")->findOneBy(["user"=>$user,"group"=>$group]);
        if(!$usergroup)
            return;
        */
        
        $topic->broadcast([$event["type"] => 1, "group" => $event["group"] , "from" =>$userid]);
    }

    /**
    * Like RPC is will use to prefix the channel
    * @return string
    */
    public function getName()
    {
        return 'websocket.counter';
    }
}