<?php

namespace App\Service;

use Symfony\Component\PasswordHasher\Exception\InvalidPasswordException;
use Symfony\Component\PasswordHasher\Hasher\CheckPasswordLengthTrait;
use Symfony\Component\PasswordHasher\LegacyPasswordHasherInterface;

class PasswordEncoder implements LegacyPasswordHasherInterface
{
    use CheckPasswordLengthTrait;

    public function hash(string $plainPassword, string $salt = null): string
    {
        if ($this->isPasswordTooLong($plainPassword)) {
            throw new InvalidPasswordException();
        }

        $hash = '{SSHA}'.base64_encode(pack('H*', sha1($plainPassword.$salt)).$salt);

        return $hash;
    }

    public function verify(string $hashedPassword, string $plainPassword, string $salt = null): bool
    {
        if ('' === $plainPassword || $this->isPasswordTooLong($plainPassword)) {
            return false;
        }

        return $this->hash($plainPassword, $salt) === $hashedPassword;
    }

    public function needsRehash(string $hashedPassword): bool
    {
        return false;
    }
}
