<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\HttpFoundation\Session\Session;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;

class MailingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();

        $builder->add('submit',
            SubmitType::class, array(
                "label"       => "Envoyer",
                "attr"        => array("class" => "btn btn-success")
            )
        );

        $perm=$options["perm"];
        $userid=$options["userid"];
        
        $builder
            ->add('niveau01',EntityType::class,[
                "mapped"       => false,
                "required"     => false,
                "class"        => "CadolesCoreBundle:Niveau01",
                'multiple'     => true,
                "label"        => $session->get('labelsniveau01'),
                'placeholder'  => '== Choisir '.$session->get('labelsniveau01').' ==',
                "choice_label" => "label",
                "attr"         => array("class" => "form-control", "style" => "margin-bottom:15px"),
                "query_builder"=> function (EntityRepository $er) use($perm,$userid) { 
                    if($perm)
                        return $er->createQueryBuilder('niveau01');
                    else {
                        $result=$er->createQueryBuilder("table")->innerJoin("CadolesCoreBundle:UserModo", "usermodo", Join::WITH, "table.id = usermodo.niveau01");
                        $result->andWhere("usermodo.user = :userid");
                        $result->setParameter('userid', $userid);
                        return $result;
                    }
                }
            ]); 
        
        if($perm) {
            $builder
                ->add('groups', Select2EntityType::class, [
                    'mapped'                => false,
                    'label'                 => 'Groupes',
                    'class'                 => 'CadolesCoreBundle:Group',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_ajax_group_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
                ]);                  
        }

        $builder
            ->add('subject', TextType::class, [
                "label"       =>"Sujet",
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                "mapped"      => false
            ]);

        $builder
            ->add("message",CKEditorType::class,[
                'config_name' => 'small_config',
                'label' => "Message",
                'mapped'=> false,
                'required' => true,
                'attr' => array("class" => "form-control", "style" => "margin-bottom:15px"),
                'config' => ["height" => "400px"]
            ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\User',
            'perm' => "boolean",
            'userid' => "integer",
        ));
    }
}

