<?php

namespace Cadoles\CronBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\Response;

use Cadoles\CronBundle\Entity\Cron;

class DumpCommand extends ContainerAwareCommand
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    private $datahost;
    private $database;
    private $username;
    private $password;
    private $path;

    protected function configure()
    {
        $this
            ->setName('Cron:Dump')
            ->setDescription('Dump database for backup')
            ->addArgument('env', InputArgument::OPTIONAL, 'env Mail') 
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')             
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
               
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getRootDir()."/../var/logs/";
        
        $mailer_host        = $this->getContainer()->getParameter('mailer_host');

        $this->writelnred('');
        $this->writelnred('== Cron:Dump');        
        $this->writelnred('==========================================================================================================');
        
        $this->datahost = $this->getContainer()->getParameter('database_host');
        $this->database = $this->getContainer()->getParameter('database_name') ; 
        $this->username = $this->getContainer()->getParameter('database_user') ; 
        $this->password = $this->getContainer()->getParameter('database_password') ; 
    
        $cmd = sprintf('mysqldump -h %s -B %s -u %s --password=%s'
            , $this->datahost
            , $this->database
            , $this->username
            , $this->password
        );

        $result = $this->runCommand($cmd);
        if($result['exit_status'] == 0) {
            $this->filesystem->dumpFile($this->rootlog."ninegate.sql", $result['output']);
        }
        
        $this->writeln('');
        return 1;
    }

    protected function runCommand($command)
    {
        $command .=" >&1";
        exec($command, $output, $exit_status);
        return array(
              "output"      => $output
            , "exit_status" => $exit_status
        );
    }    

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }  
}
