<?php

namespace Cadoles\CronBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;

use Cadoles\CronBundle\Entity\Cron;

class InitDataCommand extends ContainerAwareCommand
{
    private $entityManager;

    protected function configure()
    {
        $this
            ->setName('Cron:InitData')
            ->setDescription('Init Data for Cron')
            ->setHelp('This command Init Data for Portal')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->entityManager = $this->getContainer()->get('doctrine')->getEntityManager();

       
        $cron_activate = $this->getContainer()->getParameter('cron_activate');
        if(!$cron_activate)
            return false;

        $output->writeln('CRON = Default Data');

        $this->insertCron();

        $output->writeln('');

        return $this->entityManager->flush();
    }

    protected function insertCron() {

        $metadata =  $this->entityManager->getClassMetaData('CadolesCronBundle:Cron');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        // Job Mail
        // Toute les minutes
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(1);
        if(!$entity) {
            $entity = new Cron;
            $entity->setCommand("Cron:Mail");
            $entity->setDescription("Execution du spool de mail en attente");
            $entity->setId(1);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(60);
            $entity->setNextexecdate($entity->getSubmitdate());
        }
        $entity->setJsonargument('{"message-limit":"200","env":"prod"}');
        $this->entityManager->persist($entity);

                
        // Job synchronisation des comptes utilisateur
        // Toute les 24h à 3h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(100);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("Core:Synchro");
            $entity->setDescription("Synchronisation des Comptes Utilisateurs");
            $entity->setId(100);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $entity->setJsonargument('{"simulate":"false"}');
            $this->entityManager->persist($entity);
        }

        // Job synchronisation onlyoffice
        // Toute les 1h // Désactivé par défaut
        $widonlyoffice_sync = $this->getContainer()->getParameter('widonlyoffice_sync');
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(105);
        if(!$entity&&$widonlyoffice_sync) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();          
            $entity->setCommand("Core:Only");
            $entity->setDescription("Synchronisation des Only Office");
            $entity->setId(105);
            $entity->setStatut(4);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(3600);
            $entity->setNextexecdate($entity->getSubmitdate());
            $entity->setJsonargument('{"simulate":"false"}');
            $this->entityManager->persist($entity);
        }
        elseif($entity&&!$widonlyoffice_sync) {
            $this->entityManager->remove($entity);
        }

        // Job purge des registrations obsolètes
        // Toute les 5mn
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(110);
        if(!$entity) {
            $entity = new Cron;
            $entity->setCommand("Core:PurgeRegistration");
            $entity->setDescription("Purge des Inscriptions obsolètes");
            $entity->setId(110);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(300);
            $entity->setNextexecdate($entity->getSubmitdate());
            $this->entityManager->persist($entity);
        }

        // Job de purge des fichiers obsolète
        // Toute les 24h à 3h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(200);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("Core:PurgeFile");
            $entity->setDescription("Suppression des fichiers obsolètes");
            $entity->setId(200);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }

        // Job Statistic
        // Toute les 24h à 23h30
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(210);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(23,30);            
            $entity->setCommand("Core:Statistic");
            $entity->setDescription("Cacul des indicateurs d'usages");
            $entity->setId(210);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }

        // Job Dump
        // Toute les 24h à 2h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(220);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(2,0);            
            $entity->setCommand("Cron:Dump");
            $entity->setDescription("Sauvegarde de la BDD");
            $entity->setId(220);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }

        // CRON PORTAIL
        // Job purge des registrations obsolètes
        // Toute les 5mn
        $portal_activate = $this->getContainer()->getParameter('portal_activate');
        $calendar_activate = $this->getContainer()->getParameter('calendar_activate');
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(1000);
        if(!$entity&&($portal_activate||$calendar_activate)) {
            $entity = new Cron;
            $entity->setCommand("Portal:SynchroICS");
            $entity->setDescription("Synchronisation des Calendriers Utilisateurs liés à une URL ICS");
            $entity->setId(1000);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(600);
            $entity->setNextexecdate($entity->getSubmitdate());
            $this->entityManager->persist($entity);
        }
        elseif($entity&&!($portal_activate||$calendar_activate)) {
            $this->entityManager->remove($entity);
        }
        // Job de récupération des sondages Limesurvey
        // Toute les 6h 
        $activate_widlimesurvey = $this->getContainer()->getParameter('activate_widlimesurvey');
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(1010);
        if(!$entity&&$activate_widlimesurvey) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(1,0);            
            $entity->setCommand("Portal:GetLimesurvey");
            $entity->setDescription("Récupération des sondages Limesurvey");
            $entity->setId(1010);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(21600);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }
        elseif($entity&&!$activate_widlimesurvey) {
            $this->entityManager->remove($entity);
        }
        // Job de récupération des cours Moodle
        // Toute les 6h 
        $activate_widmoodle = $this->getContainer()->getParameter('activate_widmoodle');
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(1020);
        if(!$entity&&$activate_widmoodle) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(1,0);            
            $entity->setCommand("Portal:GetMoodle");
            $entity->setDescription("Récupération des cours Moodle ");
            $entity->setId(1020);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(21600);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }
        elseif($entity&&!$activate_widmoodle) {
            $this->entityManager->remove($entity);
        }

        // Job notification message non lus 
        // Toute les 24h à 5h00
        $websocket_activate = $this->getContainer()->getParameter('websocket_activate');
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(2000);
        if(!$entity&&($portal_activate||$calendar_activate)) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(5,0);            
            $entity->setCommand("Websocket:CountMessage");
            $entity->setDescription("Notifier les utilisateurs des messages non lus");
            $entity->setId(2000);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);            
        }
        elseif($entity&&!($websocket_activate)) {
            $this->entityManager->remove($entity);
        }

        // On flush
        $this->entityManager->flush();
    }
}
