<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Calendar
 *
 * @ORM\Entity
 * @ORM\Table(name="calendar")
 * @ORM\Entity(repositoryClass="Cadoles\PortalBundle\Repository\CalendarRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Calendar
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", nullable=true)
     */
    private $color;    

    /**
     * @var integer
     *
     * @ORM\Column(name="type", type="integer")
     */
    private $type;  

    /**
     * @var string
     *
     * @ORM\Column(name="keyvalue", type="string")
     */
    private $keyvalue;    

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="string", nullable=true)
     */
    private $url;    

    /**
     * @var string
     *
     * @ORM\Column(name="login", type="string", nullable=true)
     */
    private $login;    

    /**
     * @var string
     *
     * @ORM\Column(name="caldavname", type="string", nullable=true)
     */
    private $caldavname;    

    /**
     * @var string
     *
     * @ORM\Column(name="password", type="string", nullable=true)
     */
    private $password;    


    /**
     * @var string
     *
     * @ORM\Column(name="salt", type="string", nullable=true)
     */
    private $salt;    

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", inversedBy="calendars", cascade={"persist"})
     * @ORM\JoinTable(name="calendargroupe",
     *   joinColumns={@ORM\JoinColumn(name="calendar", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="calendars")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @var ArrayCollection $calendarevent
     * @var Calendarevent
     *
     * @ORM\OneToMany(targetEntity="Cadoles\PortalBundle\Entity\Calendarevent", mappedBy="calendar", cascade={"persist"}, orphanRemoval=true)
     */
    private $calendarevents;


    /* champs calculé non stocké en base */
    private $canupdate;
    public function getCanupdate()
    {
        return $this->canupdate;
    }    
    public function setCanupdate($canupdate)
    {
        $this->canupdate = $canupdate;
        return $this;
    }
    
    private $canadd;
    public function getCanadd()
    {
        return $this->canadd;
    }    
    public function setCanadd($canadd)
    {
        $this->canadd = $canadd;
        return $this;
    }

    /* Password User */
    public function setPassword($password)
    {
        $length   = 8;
        $cstrong  = true;
        $cipher   = 'aes-128-cbc';
      
        if (in_array($cipher, openssl_get_cipher_methods()))
        {
          $ivlen = openssl_cipher_iv_length($cipher);
          $iv = openssl_random_pseudo_bytes($ivlen);
          $this->salt = uniqid(mt_rand(), true);

          $ciphertext_raw = openssl_encrypt($password, $cipher, $this->salt, $options=OPENSSL_RAW_DATA, $iv);
          $hmac = hash_hmac('sha256', $ciphertext_raw, $this->salt, $as_binary=true);

          $this->password = base64_encode( $iv.$hmac.$ciphertext_raw );
        }

        return $this;
    }
    
    public function setPasswordDirect($password)
    {
        $this->password = $password;
        return $this;
    }

    public function getPassword()
    {
        return $this->password;
    }

    public function getPasswordDecrypt()
    {
        $c = base64_decode($this->password);
        $cipher   = 'aes-128-cbc';
      
        if (in_array($cipher, openssl_get_cipher_methods()))
        {
          $ivlen = openssl_cipher_iv_length($cipher);
          $iv = substr($c, 0, $ivlen);
          $hmac = substr($c, $ivlen, $sha2len=32);
          $ivlenSha2len = $ivlen+$sha2len;
          $ciphertext_raw = substr($c, $ivlen+$sha2len);
          $plainText = openssl_decrypt($ciphertext_raw, $cipher, $this->salt, $options=OPENSSL_RAW_DATA, $iv);
        }
      
        return $plainText;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->calendarevents = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Calendar
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Calendar
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set type
     *
     * @param integer $type
     *
     * @return Calendar
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return integer
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set keyvalue
     *
     * @param string $keyvalue
     *
     * @return Calendar
     */
    public function setKeyvalue($keyvalue)
    {
        $this->keyvalue = $keyvalue;

        return $this;
    }

    /**
     * Get keyvalue
     *
     * @return string
     */
    public function getKeyvalue()
    {
        return $this->keyvalue;
    }

    /**
     * Set url
     *
     * @param string $url
     *
     * @return Calendar
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set login
     *
     * @param string $login
     *
     * @return Calendar
     */
    public function setLogin($login)
    {
        $this->login = $login;

        return $this;
    }

    /**
     * Get login
     *
     * @return string
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Set caldavname
     *
     * @param string $caldavname
     *
     * @return Calendar
     */
    public function setCaldavname($caldavname)
    {
        $this->caldavname = $caldavname;

        return $this;
    }

    /**
     * Get caldavname
     *
     * @return string
     */
    public function getCaldavname()
    {
        return $this->caldavname;
    }

    /**
     * Set salt
     *
     * @param string $salt
     *
     * @return Calendar
     */
    public function setSalt($salt)
    {
        $this->salt = $salt;

        return $this;
    }

    /**
     * Get salt
     *
     * @return string
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Calendar
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Calendar
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Calendar
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add calendarevent
     *
     * @param \Cadoles\PortalBundle\Entity\Calendarevent $calendarevent
     *
     * @return Calendar
     */
    public function addCalendarevent(\Cadoles\PortalBundle\Entity\Calendarevent $calendarevent)
    {
        $this->calendarevents[] = $calendarevent;

        return $this;
    }

    /**
     * Remove calendarevent
     *
     * @param \Cadoles\PortalBundle\Entity\Calendarevent $calendarevent
     */
    public function removeCalendarevent(\Cadoles\PortalBundle\Entity\Calendarevent $calendarevent)
    {
        $this->calendarevents->removeElement($calendarevent);
    }

    /**
     * Get calendarevents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCalendarevents()
    {
        return $this->calendarevents;
    }
}
