<?php
namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="icon")
 * @ORM\HasLifecycleCallbacks
 * @UniqueEntity(fields="label", message="Une Icône existe déjà avec ce label")
 */
class Icon
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $tags;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="icons")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @var ArrayCollection $items
     * @var Item
     *
     * @ORM\OneToMany(targetEntity="Item", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $items;

    /**
     * @var ArrayCollection $itemcategorys
     * @var Itemcategory
     *
     * @ORM\OneToMany(targetEntity="Itemcategory", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $itemcategorys;

    /**
     * @var ArrayCollection $alertcategorys
     * @var Alertcategory
     *
     * @ORM\OneToMany(targetEntity="Alertcategory", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $alertcategorys;

    /**
     * @var ArrayCollection $pagewidgets
     * @var Pagewidget
     *
     * @ORM\OneToMany(targetEntity="Pagewidget", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $pagewidgets;

    /**
     * @var ArrayCollection $widgets
     * @var Widget
     *
     * @ORM\OneToMany(targetEntity="Widget", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $widgets;
    
    /**
     * @var ArrayCollection $bookmarks
     * @var Bookmark
     *
     * @ORM\OneToMany(targetEntity="Bookmark", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $bookmarks;

    /**
     * @var ArrayCollection $groups
     * @var Group
     *
     * @ORM\OneToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $groups;


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
        $this->itemcategorys = new \Doctrine\Common\Collections\ArrayCollection();
        $this->alertcategorys = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pagewidgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->widgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->bookmarks = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Icon
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Icon
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     *
     * @return Icon
     */
    public function addItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     */
    public function removeItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Add itemcategory
     *
     * @param \Cadoles\PortalBundle\Entity\Itemcategory $itemcategory
     *
     * @return Icon
     */
    public function addItemcategory(\Cadoles\PortalBundle\Entity\Itemcategory $itemcategory)
    {
        $this->itemcategorys[] = $itemcategory;

        return $this;
    }

    /**
     * Remove itemcategory
     *
     * @param \Cadoles\PortalBundle\Entity\Itemcategory $itemcategory
     */
    public function removeItemcategory(\Cadoles\PortalBundle\Entity\Itemcategory $itemcategory)
    {
        $this->itemcategorys->removeElement($itemcategory);
    }

    /**
     * Get itemcategorys
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItemcategorys()
    {
        return $this->itemcategorys;
    }

    /**
     * Add alertcategory
     *
     * @param \Cadoles\PortalBundle\Entity\Alertcategory $alertcategory
     *
     * @return Icon
     */
    public function addAlertcategory(\Cadoles\PortalBundle\Entity\Alertcategory $alertcategory)
    {
        $this->alertcategorys[] = $alertcategory;

        return $this;
    }

    /**
     * Remove alertcategory
     *
     * @param \Cadoles\PortalBundle\Entity\Alertcategory $alertcategory
     */
    public function removeAlertcategory(\Cadoles\PortalBundle\Entity\Alertcategory $alertcategory)
    {
        $this->alertcategorys->removeElement($alertcategory);
    }

    /**
     * Get alertcategorys
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlertcategorys()
    {
        return $this->alertcategorys;
    }

    /**
     * Add pagewidget
     *
     * @param \Cadoles\PortalBundle\Entity\Pagewidget $pagewidget
     *
     * @return Icon
     */
    public function addPagewidget(\Cadoles\PortalBundle\Entity\Pagewidget $pagewidget)
    {
        $this->pagewidgets[] = $pagewidget;

        return $this;
    }

    /**
     * Remove pagewidget
     *
     * @param \Cadoles\PortalBundle\Entity\Pagewidget $pagewidget
     */
    public function removePagewidget(\Cadoles\PortalBundle\Entity\Pagewidget $pagewidget)
    {
        $this->pagewidgets->removeElement($pagewidget);
    }

    /**
     * Get pagewidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPagewidgets()
    {
        return $this->pagewidgets;
    }

    /**
     * Add widget
     *
     * @param \Cadoles\PortalBundle\Entity\Widget $widget
     *
     * @return Icon
     */
    public function addWidget(\Cadoles\PortalBundle\Entity\Widget $widget)
    {
        $this->widgets[] = $widget;

        return $this;
    }

    /**
     * Remove widget
     *
     * @param \Cadoles\PortalBundle\Entity\Widget $widget
     */
    public function removeWidget(\Cadoles\PortalBundle\Entity\Widget $widget)
    {
        $this->widgets->removeElement($widget);
    }

    /**
     * Get widgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWidgets()
    {
        return $this->widgets;
    }

    /**
     * Add bookmark
     *
     * @param \Cadoles\PortalBundle\Entity\Bookmark $bookmark
     *
     * @return Icon
     */
    public function addBookmark(\Cadoles\PortalBundle\Entity\Bookmark $bookmark)
    {
        $this->bookmarks[] = $bookmark;

        return $this;
    }

    /**
     * Remove bookmark
     *
     * @param \Cadoles\PortalBundle\Entity\Bookmark $bookmark
     */
    public function removeBookmark(\Cadoles\PortalBundle\Entity\Bookmark $bookmark)
    {
        $this->bookmarks->removeElement($bookmark);
    }

    /**
     * Get bookmarks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBookmarks()
    {
        return $this->bookmarks;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Icon
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set tags
     *
     * @param string $tags
     *
     * @return Icon
     */
    public function setTags($tags)
    {
        $this->tags = $tags;

        return $this;
    }

    /**
     * Get tags
     *
     * @return string
     */
    public function getTags()
    {
        return $this->tags;
    }
}
