<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Widget
 *
 * @ORM\Entity
 * @ORM\Table(name="widget")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="Cadoles\PortalBundle\Repository\WidgetRepository")
 */
class Widget
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="routeview", type="string")
     */
    private $routeview;

    /**
     * @var integer
     *
     * @ORM\Column(name="height", type="integer")
     */
    private $height;

    /**
     * @var boolean
     *
     * @ORM\Column(name="autoajust", type="boolean", options={"default":false})
     */
    protected $autoajust;

    /**
     * @var boolean
     *
     * @ORM\Column(name="border", type="boolean", options={"default":true})
     */
    protected $border;

    /**
     * @var boolean
     *
     * @ORM\Column(name="opened", type="boolean", options={"default":true})
     */
    protected $opened;

    /**
     * @var string
     *
     * @ORM\Column(name="colorheaderback", type="string", nullable=true)
     */
    protected $colorheaderback;

    /**
     * @var string
     *
     * @ORM\Column(name="colorheaderfont", type="string", nullable=true)
     */
    protected $colorheaderfont;

    /**
     * @var string
     *
     * @ORM\Column(name="colorbodyback", type="string", nullable=true)
     */
    protected $colorbodyback;

    /**
     * @var string
     *
     * @ORM\Column(name="colorbodyfont", type="string", nullable=true)
     */
    protected $colorbodyfont;

    /**
     * @var string
     *
     * @ORM\Column(name="access", type="array", nullable=true)
     */
    protected $access;    

    /**
     * @var string
     *
     * @ORM\Column(name="parameter", type="array", nullable=true)
     */
    private $parameter;
    
    /**
     * @ORM\ManyToOne(targetEntity="Icon", inversedBy="widgets")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @var ArrayCollection $pagewidgets
     * @var Order
     *
     * @ORM\OneToMany(targetEntity="Pagewidget", mappedBy="widget", cascade={"persist"}, orphanRemoval=true)
     */
    private $pagewidgets; 
    
    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->pagewidgets = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Widget
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Widget
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Widget
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set routeview
     *
     * @param string $routeview
     *
     * @return Widget
     */
    public function setRouteview($routeview)
    {
        $this->routeview = $routeview;

        return $this;
    }

    /**
     * Get routeview
     *
     * @return string
     */
    public function getRouteview()
    {
        return $this->routeview;
    }

    /**
     * Set height
     *
     * @param integer $height
     *
     * @return Widget
     */
    public function setHeight($height)
    {
        $this->height = $height;

        return $this;
    }

    /**
     * Get height
     *
     * @return integer
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * Set autoajust
     *
     * @param boolean $autoajust
     *
     * @return Widget
     */
    public function setAutoajust($autoajust)
    {
        $this->autoajust = $autoajust;

        return $this;
    }

    /**
     * Get autoajust
     *
     * @return boolean
     */
    public function getAutoajust()
    {
        return $this->autoajust;
    }

    /**
     * Set border
     *
     * @param boolean $border
     *
     * @return Widget
     */
    public function setBorder($border)
    {
        $this->border = $border;

        return $this;
    }

    /**
     * Get border
     *
     * @return boolean
     */
    public function getBorder()
    {
        return $this->border;
    }

    /**
     * Set opened
     *
     * @param boolean $opened
     *
     * @return Widget
     */
    public function setOpened($opened)
    {
        $this->opened = $opened;

        return $this;
    }

    /**
     * Get opened
     *
     * @return boolean
     */
    public function getOpened()
    {
        return $this->opened;
    }

    /**
     * Set colorheaderback
     *
     * @param string $colorheaderback
     *
     * @return Widget
     */
    public function setColorheaderback($colorheaderback)
    {
        $this->colorheaderback = $colorheaderback;

        return $this;
    }

    /**
     * Get colorheaderback
     *
     * @return string
     */
    public function getColorheaderback()
    {
        return $this->colorheaderback;
    }

    /**
     * Set colorheaderfont
     *
     * @param string $colorheaderfont
     *
     * @return Widget
     */
    public function setColorheaderfont($colorheaderfont)
    {
        $this->colorheaderfont = $colorheaderfont;

        return $this;
    }

    /**
     * Get colorheaderfont
     *
     * @return string
     */
    public function getColorheaderfont()
    {
        return $this->colorheaderfont;
    }

    /**
     * Set colorbodyback
     *
     * @param string $colorbodyback
     *
     * @return Widget
     */
    public function setColorbodyback($colorbodyback)
    {
        $this->colorbodyback = $colorbodyback;

        return $this;
    }

    /**
     * Get colorbodyback
     *
     * @return string
     */
    public function getColorbodyback()
    {
        return $this->colorbodyback;
    }

    /**
     * Set colorbodyfont
     *
     * @param string $colorbodyfont
     *
     * @return Widget
     */
    public function setColorbodyfont($colorbodyfont)
    {
        $this->colorbodyfont = $colorbodyfont;

        return $this;
    }

    /**
     * Get colorbodyfont
     *
     * @return string
     */
    public function getColorbodyfont()
    {
        return $this->colorbodyfont;
    }

    /**
     * Set access
     *
     * @param string $access
     *
     * @return Widget
     */
    public function setAccess($access)
    {
        $this->access = $access;

        return $this;
    }

    /**
     * Get access
     *
     * @return string
     */
    public function getAccess()
    {
        return $this->access;
    }

    /**
     * Set parameter
     *
     * @param array $parameter
     *
     * @return Widget
     */
    public function setParameter($parameter)
    {
        $this->parameter = $parameter;

        return $this;
    }

    /**
     * Get parameter
     *
     * @return array
     */
    public function getParameter()
    {
        return $this->parameter;
    }

    /**
     * Set icon
     *
     * @param \Cadoles\PortalBundle\Entity\Icon $icon
     *
     * @return Widget
     */
    public function setIcon(\Cadoles\PortalBundle\Entity\Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return \Cadoles\PortalBundle\Entity\Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Add pagewidget
     *
     * @param \Cadoles\PortalBundle\Entity\Pagewidget $pagewidget
     *
     * @return Widget
     */
    public function addPagewidget(\Cadoles\PortalBundle\Entity\Pagewidget $pagewidget)
    {
        $this->pagewidgets[] = $pagewidget;

        return $this;
    }

    /**
     * Remove pagewidget
     *
     * @param \Cadoles\PortalBundle\Entity\Pagewidget $pagewidget
     */
    public function removePagewidget(\Cadoles\PortalBundle\Entity\Pagewidget $pagewidget)
    {
        $this->pagewidgets->removeElement($pagewidget);
    }

    /**
     * Get pagewidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPagewidgets()
    {
        return $this->pagewidgets;
    }
}
