<?php

namespace Cadoles\PortalBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Cadoles\PortalBundle\Entity\Blog;

class BlogarticleRepository extends EntityRepository
{
   
    public function getBlogsArticles($blogs,$start,$length=10,&$count,&$articles)
    {
        $count=$this->createQueryBuilder('blogarticle')
                ->select('COUNT(blogarticle)')
                ->andwhere('blogarticle.blog IN(:blog)')
                ->setParameter('blog',$blogs)
                ->getQuery()->getSingleScalarResult();

        $articles=$this->createQueryBuilder('blogarticle')
                ->andwhere('blogarticle.blog IN(:blog)')
                ->setParameter('blog',$blogs)
                ->orderBy('blogarticle.submit', 'DESC')
                ->addOrderBy('blogarticle.name', 'ASC')  
                ->setFirstResult($start)->setMaxResults($length)                  
                ->getQuery()->getResult();
    }
}
