<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity
 * @ORM\Table(name="item")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\ItemRepository")
 */
class Item
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=100)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="subtitle", type="string", length=250, nullable=true)
     */
    private $subtitle;

    /**
     * @var string
     *
     * @ORM\Column(length=128, unique=true, nullable=true)
     */
    private $slug;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="string", length=500)
     */
    private $url;

    /**
     * @var string
     *
     * @ORM\Column(name="target", type="string", length=32)
     */
    private $target;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="text", nullable=true)
     */
    private $content;

    /**
     * @var integer
     *
     * @ORM\Column(name="rowOrder", type="integer", nullable=true)
     */
    private $rowOrder;

    /**
     * @var boolean
     *
     * @ORM\Column(name="essential", type="boolean", nullable=true, options={"default":false})
     */
    private $essential = false;

    /**
     * @var boolean
     *
     * @ORM\Column(name="protected", type="boolean", nullable=true, options={"default":false})
     */
    private $protected;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=24,  nullable=true)
     */
    private $color;

    /**
     * @var string
     *
     * @ORM\Column(name="badgeurl", type="string", length=250,  nullable=true)
     */
    private $badgeurl;
    
    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @var string
     *
     * @ORM\Column(name="ssoitem", type="string",  nullable=true)
     */
    private $ssoitem;

    /**
     * @ORM\ManyToOne(targetEntity="Icon", inversedBy="items")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @var boolean
     *
     * @ORM\Column(name="clicksonde", type="boolean", nullable=true, options={"default":false})
     */
    private $clicksonde = false;    

    /**
     * @var boolean
     *
     * @ORM\Column(name="clicksondeservice", type="string", nullable=true)
     */
    private $clicksondeservice;    

    /**
     * @var ArrayCollection $bookmark
     * @var Bookmark
     *
     * @ORM\OneToMany(targetEntity="Bookmark", mappedBy="item", cascade={"persist"}, orphanRemoval=true)
     */
    private $bookmarks;

    /**
     * @ORM\ManyToOne(targetEntity="Itemcategory", inversedBy="items")
     * @ORM\JoinColumn(name="category", referencedColumnName="id", nullable=false, onDelete="CASCADE")
     */
    protected $itemcategory;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="items", cascade={"persist"})
     * @ORM\JoinTable(name="itemgroupe",
     *   joinColumns={@ORM\JoinColumn(name="item", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Niveau01", inversedBy="items", cascade={"persist"})
     * @ORM\JoinTable(name="itemniveau01",
     *   joinColumns={@ORM\JoinColumn(name="item", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="niveau01", referencedColumnName="id")}
     * )
     */
    protected $niveau01s;

    /**
    * @ORM\ManyToMany(targetEntity="Alert", mappedBy="items")
    */    
    protected $alerts;

    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->bookmarks = new \Doctrine\Common\Collections\ArrayCollection();
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->niveau01s = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Item
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set subtitle
     *
     * @param string $subtitle
     *
     * @return Item
     */
    public function setSubtitle($subtitle)
    {
        $this->subtitle = $subtitle;

        return $this;
    }

    /**
     * Get subtitle
     *
     * @return string
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }

    /**
     * Set slug
     *
     * @param string $slug
     *
     * @return Item
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;

        return $this;
    }

    /**
     * Get slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Set url
     *
     * @param string $url
     *
     * @return Item
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set target
     *
     * @param string $target
     *
     * @return Item
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * Get target
     *
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * Set content
     *
     * @param string $content
     *
     * @return Item
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set rowOrder
     *
     * @param integer $rowOrder
     *
     * @return Item
     */
    public function setRowOrder($rowOrder)
    {
        $this->rowOrder = $rowOrder;

        return $this;
    }

    /**
     * Get rowOrder
     *
     * @return integer
     */
    public function getRowOrder()
    {
        return $this->rowOrder;
    }

    /**
     * Set protected
     *
     * @param boolean $protected
     *
     * @return Item
     */
    public function setProtected($protected)
    {
        $this->protected = $protected;

        return $this;
    }

    /**
     * Get protected
     *
     * @return boolean
     */
    public function getProtected()
    {
        return $this->protected;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Item
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Item
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Set icon
     *
     * @param Icon $icon
     *
     * @return Item
     */
    public function setIcon(Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Add bookmark
     *
     * @param Bookmark $bookmark
     *
     * @return Item
     */
    public function addBookmark(Bookmark $bookmark)
    {
        $this->bookmarks[] = $bookmark;

        return $this;
    }

    /**
     * Remove bookmark
     *
     * @param Bookmark $bookmark
     */
    public function removeBookmark(Bookmark $bookmark)
    {
        $this->bookmarks->removeElement($bookmark);
    }

    /**
     * Get bookmarks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBookmarks()
    {
        return $this->bookmarks;
    }

    /**
     * Set itemcategory
     *
     * @param Itemcategory $itemcategory
     *
     * @return Item
     */
    public function setItemcategory(Itemcategory $itemcategory)
    {
        $this->itemcategory = $itemcategory;

        return $this;
    }

    /**
     * Get itemcategory
     *
     * @return Itemcategory
     */
    public function getItemcategory()
    {
        return $this->itemcategory;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Item
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add niveau01
     *
     * @param Niveau01 $niveau01
     *
     * @return Item
     */
    public function addNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01s[] = $niveau01;

        return $this;
    }

    /**
     * Remove niveau01
     *
     * @param Niveau01 $niveau01
     */
    public function removeNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01s->removeElement($niveau01);
    }

    /**
     * Get niveau01s
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNiveau01s()
    {
        return $this->niveau01s;
    }

    /**
     * Set essential
     *
     * @param boolean $essential
     *
     * @return Item
     */
    public function setEssential($essential)
    {
        $this->essential = $essential;

        return $this;
    }

    /**
     * Get essential
     *
     * @return boolean
     */
    public function getEssential()
    {
        return $this->essential;
    }

    /**
     * Add alert
     *
     * @param Alert $alert
     *
     * @return Item
     */
    public function addAlert(Alert $alert)
    {
        $this->alerts[] = $alert;

        return $this;
    }

    /**
     * Remove alert
     *
     * @param Alert $alert
     */
    public function removeAlert(Alert $alert)
    {
        $this->alerts->removeElement($alert);
    }

    /**
     * Get alerts
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlerts()
    {
        return $this->alerts;
    }

    /**
     * Set ssoitem
     *
     * @param string $ssoitem
     *
     * @return Item
     */
    public function setSsoitem($ssoitem)
    {
        $this->ssoitem = $ssoitem;

        return $this;
    }

    /**
     * Get ssoitem
     *
     * @return string
     */
    public function getSsoitem()
    {
        return $this->ssoitem;
    }

    /**
     * Set badgeurl.
     *
     * @param string|null $badgeurl
     *
     * @return Item
     */
    public function setBadgeurl($badgeurl = null)
    {
        $this->badgeurl = $badgeurl;

        return $this;
    }

    /**
     * Get badgeurl.
     *
     * @return string|null
     */
    public function getBadgeurl()
    {
        return $this->badgeurl;
    }

    /**
     * Set clicksonde
     *
     * @param boolean $clicksonde
     *
     * @return Item
     */
    public function setClicksonde($clicksonde)
    {
        $this->clicksonde = $clicksonde;

        return $this;
    }

    /**
     * Get clicksonde
     *
     * @return boolean
     */
    public function getClicksonde()
    {
        return $this->clicksonde;
    }

    /**
     * Set clicksondeservice
     *
     * @param string $clicksondeservice
     *
     * @return Item
     */
    public function setClicksondeservice($clicksondeservice)
    {
        $this->clicksondeservice = $clicksondeservice;

        return $this;
    }

    /**
     * Get clicksondeservice
     *
     * @return string
     */
    public function getClicksondeservice()
    {
        return $this->clicksondeservice;
    }
}
