<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="usermodo")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields={"user", "service"}, message="Cette liaison existe déjà !")
 */
class UserModo
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="modos")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Niveau01", inversedBy="modos")
     * @ORM\JoinColumn(name="niveau01_id", referencedColumnName="id", nullable=false)
     */
    private $niveau01;
  
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return UserModo
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set niveau01
     *
     * @param Niveau01 $niveau01
     *
     * @return UserModo
     */
    public function setNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01 = $niveau01;

        return $this;
    }

    /**
     * Get niveau01
     *
     * @return Niveau01
     */
    public function getNiveau01()
    {
        return $this->niveau01;
    }
}
