<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityRepository;

class ProjecttaskType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user=$options['user'];
        $projecttask=$options['projecttask'];

        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
                'label'         => 'Titre'
            ])
            
            ->add("description",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "config"        => ["height" => "500px",'filebrowserUploadRoute' => 'app_portal_'.$options["access"].'_projecttask_upload']
            ])

            ->add('priority', IntegerType::class, [
                "label"         => 'Priorité',
                "required"      => true,
                "attr"          => ["min"=>0],
            ])

            ->add('end', DateType::class, [
                "label"         => 'A Réaliser avant le',
                "required"      => false,
                "widget"        => 'single_text',
            ])

            ->add('percentage', IntegerType::class, [
                "label"         => "Pourcentage d'avancement",
                "required"      => true,
                "attr"          => ["min"=>0, "max"=>100],
            ])

            ->add('projecttasktag', EntityType::class, [
                "label"         => 'Type',
                "class"         => 'App\Entity\Projecttasktag',
                "choice_label"  => 'name',
                "required"      => false,
            ])

            ->add('projecttaskstatus', EntityType::class, [
                "label"         => 'Statut',
                "class"         => 'App\Entity\Projecttaskstatus',
                "choice_label"  => 'name',
                "required"      => false,
            ]);
            
        if($options["access"]=="config") {
            $builder
            ->add('project', EntityType::class, [
                "label"         => 'Projet associé',
                "class"         => 'App\Entity\Project',
                "choice_label"  => 'name',
            ]);                
        }
        else {
            if(!$projecttask->getProject()) {
                $builder
                ->add('project', EntityType::class, [
                    'label'         => 'Projet associé',
                    'class'         => 'App\Entity\Project',
                    'choice_label'  => 'name',
                    "disabled"      => ($options["mode"]=="update"?true:false),
                    'placeholder'   => '-- Sélectionnez un Projet --',
                    'query_builder' => function(EntityRepository $er) use ($user) {
                        $qb=$er->createQueryBuilder('project');
                        return $qb->select('project')
                                    ->where('project.user=:user')
                                    ->orwhere(':user MEMBER OF project.writers')

                                    ->from('App\Entity\UserGroup','usergroup')
                                    ->orwhere('usergroup.group MEMBER OF project.groups AND usergroup.user=:user')

                                    ->from('App\Entity\User','user')
                                    ->andwhere("user=:user")

                                    ->setparameter('user',$user);
                    },               
                ]);
            }
            else {
                $builder
                ->add('project', EntityType::class, [
                    'label'         => 'Projet associé',
                    'class'         => 'App\Entity\Project',
                    'choice_label'  => 'name',
                    "disabled"      => ($options["mode"]=="update"?true:false),
                    'placeholder'   => '-- Sélectionnez un Projet --',
                    'query_builder' => function(EntityRepository $er) use ($projecttask) {
                        $qb=$er->createQueryBuilder('project');
                        return $qb->select('project')
                                    ->where('project.id=:project')
                                    ->setparameter('project',$projecttask->getProject()->getId());
                    },               
                ]);
            }
        }
        
        $builder->add('user',
            Select2EntityType::class, array(
                'label' => "Intervenant",
                "required" => false,
                'multiple' => false,
                'remote_route' => 'app_portal_'.$options["access"].'_projecttask_users',
                'class' => 'App\Entity\User',
                'req_params' => ['project' => 'parent.children[project]'],
                'primary_key' => 'id',
                'text_property' => 'username',
                'minimum_input_length' => 0,
                'page_limit' => 10,
                'allow_clear' => true,
                'delay' => 250,
                'cache' => false,
                'cache_timeout' => 60000, // if 'cache' is true
                'language' => 'fr',
                'placeholder' => 'Selectionner un intervenant',
            )
        ); 
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Projecttask',
            'mode' => 'string',
            'access' => 'string',
            'user' => 'App\Entity\User',
            'projecttask' => 'App\Entity\Projecttask'
        ]);
    }
}
