<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class SlideType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add("submit", SubmitType::class, [
                "label"       => "Valider",
                "attr"        => array("class" => "btn btn-success")
            ])

            ->add("title", TextType::class, [
                "label"         => "Titre",
                "required"      => false,
            ])

            ->add("subtitle", TextareaType::class, [
                "label"         => 'Sous Titre',
                "required"      => false,
                "attr"          => array("rows" => '4')
            ])            

            ->add('roworder', IntegerType::class, [
                'label'         => 'Ordre',
            ])   

            ->add('url', TextType::class, [
                "label"         => "URL",
                "required"      => false,
            ])

            ->add('target', ChoiceType::class, [
                "label" => 'Ouvrir le lien dans',
                "choices" => [
                    "Nouvel onglet/fenêtre" => '_blank',
                    "iFrame"                => 'frame',
                    "Onglet courant"        => '_self',
                ]
            ])

            ->add('image',HiddenType::class, [
                "label"       =>"image",
                "disabled"    => ($options["mode"]=="delete"?true:false)
            ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Slide',
            'mode' => "string",
            'idicon' => "string",
        ]);
    }
}
