<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;

class SondeController extends AbstractController
{
    public function sonde(Request $request, ManagerRegistry $em)
    {
        // Debug sonde
        $fgdebug = true;

        // Calcul du login
        $user=$this->getUser();
        if($user) $loginsonde=crypt($user->getUsername(),"dkywqZPYNHtWDnSxACjXVcIsFuaiQT");
        else $loginsonde="";

        // Calcul du profil
        $profilsonde="visiteur";
        if($user) {
            $profilsonde="utilisateur";
            $attributes=$request->getSession()->get('attributes');
            if(isset($attributes["ENTPersonProfils"])) $profilsonde=$attributes["ENTPersonProfils"];
        }

        // Calcul de la provenance
        $e = explode('.', $_SERVER["REMOTE_ADDR"]);
        $s = sizeof($e);
        if(($e[0]=="172"&&$e[1]=="30")||($e[0]=="172"&&$e[1]=="16")||($e[0]=="10"&&($e[1]=="77"||$e[1]=="93"||$e[1]=="94")))
            $provenancesonde='interne';
        else
            $provenancesonde='externe';      
            
        // Calcul du service associé à la page
        $request = $this->get('request_stack')->getMasterRequest();
        $route = $request->attributes->get('_route');

        switch (true) {
            case $route === "app_core_user_file_list" || $route === "app_core_home":
                $rubrique = "nosonde";
                $page = "";
                break;

            case $route === "app_core_user":
                $rubrique = "Mon profil";
                $page = "ACCES_Mon-profil";
                break;

            case $route === "app_core_user_users":
                $rubrique = "Annuaire";
                $page = "ACCES_Annuaire";
                break;

            case $route === "app_core_user_view":
                $rubrique = "Annuaire";
                $page = "ACCES_Fiche-utilisateur";
                break;

            case $route === "app_portal_user_page_view":
                $rubrique = "Accueil";
                $page = "ACCES_Accueil";
                break;

            case $route === "app_portal_user_page_submit":
                $rubrique = "Accueil";
                $page = "AJOUT_Page-Accueil";
                break;

            case $route === "app_portal_user_page_update":
                $rubrique = "Accueil";
                $page = "MODIFICATION_Page-Accueil";
                break;

            case $route === "app_portal_user_page_delete":
                $rubrique = "Accueil";
                $page = "SUPPRESSION_Page-Accueil";
                break;

            case $route === "app_portal_user_page_share":
                $rubrique = "Accueil";
                $page = "PARTAGE_Page-Accueil";
                break;
            
            case $route === "app_portal_user_pagewidget_widget_sumbit":
                $rubrique = "Accueil";
                $page = "AJOUT_Widget-Accueil";
                break;            

            case $route === "app_portal_user_pagewidget_widget_update":
                $rubrique = "Accueil";
                $page = "MODIFICATION_Widget-Accueil";
                break;            

            case $route === "app_portal_user_pagewidget_delete":
                $rubrique = "Accueil";
                $page = "SUPPRESSION_Widget-Accueil";
                break;            

            case $route === "app_portal_user_notice_view":
                $rubrique = "Charte";
                $page = "ACCES_Charte";
                break;            

            case $route === "app_core_user_group":
            case $route === "app_core_user_group_statistic":
            case $route === "app_core_user_group_info":
            case $route === "app_core_user_group_ajax_usersnotin":
            case $route === "app_core_user_group_ajax_usersin":
            case $route === "app_core_user_group_usergroup_export":
                $rubrique = "Mes Groupes";
                $page = "ACCES_Mes-Groupes";
                break;       

            case $route === "app_core_user_group_submit":
                $rubrique = "Mes Groupes";
                $page = "CREATION_Groupe-travail";
                break;       

            case $route === "app_core_user_group_update":
            case $route === "app_core_user_group_out":
            case $route === "app_core_user_group_ajax_usergroup_add":
            case $route === "app_core_user_group_ajax_usergroup_del":
            case $route === "app_core_user_group_ajax_changerole":
            case $route === "app_core_user_group_invitation":
                $rubrique = "Mes Groupes";
                $page = "MODIFICATION_Mes-Groupes";
                break;       

            case $route === "app_core_user_group_delete":
                $rubrique = "Mes Groupes";
                $page = "SUPPRESSION_Mes-Groupes";
                break;       

            default:
                $rubrique = "Accueil";
                $page = "ACCES_Accueil";
                break;
        }
        
        $urlsonde="";
        if($rubrique!="nosonde") {
            $url=$this->getParameter("widsonde_url");
            $app=$this->getParameter("app_name");
            $urlsonde = $url."?appli=$app&profil=$profilsonde&login=$loginsonde&provenance=$provenancesonde&rubrique=$rubrique&page=$page&route=$route&fgdebug=$fgdebug";
        }

        return $this->render('Sonde\sonde.html.twig',['urlsonde' => $urlsonde]);
    }


}
