<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;


/**
 * @ORM\Entity
 * @ORM\Table(name="edispatcher")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="username", message="Un utilisateur existe déjà avec ce login.")
 */
class Edispatcher
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=128, unique=true)
     */
    private $username;

    /**
     * @ORM\Column(type="string", length=256, nullable=true)
     */
    private $profil;

    /**
     * @ORM\Column(type="string", length=512, nullable=true)
     */
    private $groupes;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ssoitems;

    /**
     * @ORM\Column(type="string", length=256, nullable=true)
     */
    private $token;

    /**
     * @ORM\Column(type="string", length=256, nullable=true)
     */
    private $iddatasource;

    /**
     * @ORM\Column(type="string", length=12, nullable=true)
     */
    private $horodatage;

    /**
     * Get UserName
     *
     * @return string
     */
    public function getUserName()
    {
        return $this->username;
    }

    /**
     * Get Profil
     *
     * @return string
     */
    public function getProfil()
    {
        return $this->profil;
    }

    /**
     * Get Groupes
     *
     * @return string
     */
    public function getGroupes()
    {
        return $this->groupes;
    }

    /**
     * Get Ssoitems
     *
     * @return string
     */
    public function getSsoitems()
    {
        return $this->ssoitems;
    }

    /**
     * Get Token
     *
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Get Iddatasource
     *
     * @return string
     */
    public function getIddatasource()
    {
        return $this->iddatasource;
    }

    /**
     * Get Horodatage
     *
     * @return string
     */
    public function getHorodatage()
    {
        return $this->horodatage;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     *
     * @return Datasource
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * Set profil
     *
     * @param string $profil
     *
     * @return Datasource
     */
    public function setProfil($profil)
    {
        $this->profil = $profil;

        return $this;
    }

    /**
     * Set groupes
     *
     * @param string $groupes
     *
     * @return Datasource
     */
    public function setGroupes($groupes)
    {
        $this->groupes = $groupes;

        return $this;
    }

    /**
     * Set ssoitems
     *
     * @param string $ssoitems
     *
     * @return Datasource
     */
    public function setSsoitems($ssoitems)
    {
        $this->ssoitems = $ssoitems;

        return $this;
    }

    /**
     * Set token
     *
     * @param string $token
     *
     * @return Datasource
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * Set iddatasource
     *
     * @param string $iddatasource
     *
     * @return Datasource
     */
    public function setIddatasource($iddatasource)
    {
        $this->iddatasource = $iddatasource;

        return $this;
    }

    /**
     * Set horodatage
     *
     * @param string $horodatage
     *
     * @return Datasource
     */
    public function setHorodatage($horodatage)
    {
        $this->horodatage = $horodatage;

        return $this;
    }

}
