<?php

namespace App\Repository;

use Doctrine\ORM\EntityRepository;

class BlogarticleRepository extends EntityRepository
{
   
    public function getBlogsArticles($blogs,$start,$length=10,&$count,&$articles)
    {
        $count=$this->createQueryBuilder('blogarticle')
                ->select('COUNT(blogarticle)')
                ->andwhere('blogarticle.blog IN(:blog)')
                ->setParameter('blog',$blogs)
                ->getQuery()->getSingleScalarResult();

        $articles=$this->createQueryBuilder('blogarticle')
                ->andwhere('blogarticle.blog IN(:blog)')
                ->setParameter('blog',$blogs)
                ->orderBy('blogarticle.submit', 'DESC')
                ->addOrderBy('blogarticle.name', 'ASC')  
                ->setFirstResult($start)->setMaxResults($length)                  
                ->getQuery()->getResult();
    }
}
