<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
  * @ORM\Entity
  * @ORM\Table(name="statistic")
  */
class Statistic
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     */
    protected $keyvalue;

    /**
    * @var string
    *
    * @ORM\Column(type="array", nullable=true)
    */
    private $value;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="statistics")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=true)
     */
    private $group;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set keyvalue
     *
     * @param string $keyvalue
     *
     * @return Statistic
     */
    public function setKeyvalue($keyvalue)
    {
        $this->keyvalue = $keyvalue;

        return $this;
    }

    /**
     * Get keyvalue
     *
     * @return string
     */
    public function getKeyvalue()
    {
        return $this->keyvalue;
    }

    /**
     * Set value
     *
     * @param array $value
     *
     * @return Statistic
     */
    public function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * Get value
     *
     * @return array
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Statistic
     */
    public function setGroup(\Cadoles\CoreBundle\Entity\Group $group = null)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return \Cadoles\CoreBundle\Entity\Group
     */
    public function getGroup()
    {
        return $this->group;
    }
}
