<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use Cadoles\PortalBundle\Entity\Blogarticle;
use Cadoles\PortalBundle\Form\BlogarticleType;
use Cadoles\CoreBundle\Entity\Usergroup;

class BlogarticleController extends Controller
{
    private $labelentity="CadolesPortalBundle:Blogarticle";
    private $routeprimary="cadoles_portal_config_blogarticle";

    private function entityForm(Blogarticle $entity,$access="config")
    {
        $route=str_replace("_config_","_".$access."_",$this->routeprimary);

        if ($this->getDoctrine()->getManager()->contains($entity)) {
            return $this->createForm(BlogarticleType::class, $entity, [
                "mode"   => "update",
                "access" => $access,
                "user" => $this->getUser(),
                'blogarticle' => $entity,
            ]);
        }
        else {
            return $this->createForm(BlogarticleType::class, $entity, [
                "mode"   => "submit",
                "access" => $access,
                "user" => $this->getUser(),
                'blogarticle' => $entity,
            ]);
        }
    }

    public function submitAction(Request $request,$idblog,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = new Blogarticle();
        $blog=$em->getRepository("CadolesPortalBundle:Blog")->find($idblog);
        if($blog) $entity->setBlog($blog);
        
        $pageid=$request->get("page");
        if($pageid) {
            $page=$em->getRepository("CadolesPortalBundle:Page")->find($pageid);
            $groups=$page->getGroups();
            $idgroup=$groups[0]->getId();
        }

        $form   = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $entity->setUser($this->getUser());
            $entity->setSubmit(new \Datetime());
            $entity->setFgdraft(true);

            $em->persist($entity);
            $em->flush();

            foreach($entity->getBlog()->getGroups() as $group) {
                if($group->getFgcanshare()) {
                    $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_blogarticle_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                    $message="Création article<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
                    if($usergroup) {
                        $key=$usergroup->getKeyvalue();
                        $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$group->getId(),$message);
                    }
                }
            }

            if(is_null($pageid))
                return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_blogarticle_view',["id"=>$entity->getId()]));          
            else
                return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_page_view',["id"=>$pageid,"usage"=>"group","group"=>$idgroup]));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "submit",
            'access'            => $access,
            'form'              => $form->createView(),
            'pageid'            => $pageid
        ]);
    }

    public function updateAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $em->getRepository("CadolesPortalBundle:Blog")->getPermission($this->getUser(),$entity->getBlog(),$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
            elseif(!$canupdate&&$this->getUser()!=$entity->getUser()) throw $this->createNotFoundException('Permission denied');
        }            
        
        // Création du formulaire
        $form = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();

            foreach($entity->getBlog()->getGroups() as $group) {
                if($group->getFgcanshare()) {
                    $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_blogarticle_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                    $message="Modification article<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
                    if($usergroup) {
                        $key=$usergroup->getKeyvalue();
                        $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$group->getId(),$message);
                    }
                }
            }

            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_blogarticle_view',["id"=>$entity->getId()]));          
        }


        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),                  
            'entity'            => $entity,
            'access'            => $access,
            'mode'              => "update",
            'form'              => $form->createView(),
        ]);
    }

    public function deleteAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $this->getDoctrine()->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
        
        $idblog=$entity->getBlog()->getId();

        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $em->getRepository("CadolesPortalBundle:Blog")->getPermission($this->getUser(),$entity->getBlog(),$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
            elseif(!$canupdate&&$this->getUser()!=$entity->getUser()) throw $this->createNotFoundException('Permission denied');
        }

        // Suppression
        $em->remove($entity);
        $em->flush();

        // Retour
        return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_blog_view',["id"=>$idblog]));
    }

    public function viewAction($id, Request $request, $access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // On recherche la premiere page associé au groupe du blog
        $groups=$entity->getBlog()->getGroups();
        $idpage=null;
        $idgroup=null;
        if($groups[0]) {
            if($groups[0]->getFgcanshare()) {
                $pages=$groups[0]->getPages();
                if($pages[0]) {
                    $idpage=$pages[0]->getId();
                    $groups=$pages[0]->getGroups();
                    $idgroup=$groups[0]->getId();
                }
            }
        }

        // Permissions
        $user=$this->getUser();
        if($access=="config") {
            $canupdate = true;
            $canadd=true;

            $blogs=$em->getRepository("CadolesPortalBundle:Blog")->findBy(["id"=>$entity->getBlog()->getId()]);
        }
        else {
            // On récupère l'ensemble des blogs de l'utilisateur
            $em->getRepository("CadolesPortalBundle:Blog")->getBlogsUser($user,$blogsuser,$blogsadmin,$blogsshared);
            $blogs=array_merge($blogsuser,$blogsadmin->toArray(),$blogsshared);

            // permission
            if($id==0) {
                $cansee=true;
                $canadd=true;
            }
            else {
                $em->getRepository("CadolesPortalBundle:Blog")->getPermission($user,$entity->getBlog(),$cansee,$canupdate,$canadd);
                if(!$canupdate&&$this->getUser()==$entity->getUser()) $canupdate=true;                
            }
          
            if(!$cansee) throw $this->createNotFoundException('Permission denied');
        }

        $em->getRepository("CadolesPortalBundle:Blogarticle")->getBlogsArticles($blogs,0,10,$count,$blogarticles);

        return $this->render($this->labelentity.':view.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),
            'entity'            => $entity,
            'access'            => $access,
            'canupdate'         => $canupdate,
            'canadd'            => $canadd,
            'blogs'             => $blogs,
            'blogarticles'      => $blogarticles,
            'idpage'            => $idpage,
            'idgroup'           => $idgroup,
        ]);

    }

    public function uploadAction(Request $request,$access=null) {
        // Fichier temporaire uploadé
        $tmpfile    = $request->files->get('upload');
        $extention  = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs         = new Filesystem();
        $rootdir    = $this->get('kernel')->getRootDir()."/../web";
        $fs->mkdir($rootdir."/uploads/ckeditor");
        
        // Fichier cible
        $targetName = uniqid().".".$extention;
        $targetFile = $rootdir."/uploads/ckeditor/".$targetName;
        $targetUrl  = "/".$this->getParameter('alias')."/uploads/ckeditor/".$targetName;
        $message    = "";

        move_uploaded_file($tmpfile,$targetFile);
        
        $output["uploaded"]=1;
        $output["fileName"]=$targetName;
        $output["url"]=$targetUrl;

        return new Response(json_encode($output));

    }    

    public function imageAction($access="config")
    {
        return $this->render('CadolesPortalBundle:Blogarticle:image.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access
        ]);
    }    
}
