<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;



class Niveau01Type extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

        $builder->add('label',
            TextType::class, array(
                "label"       =>"Label",
                "disabled"    => ($options["mode"]=="delete"?true:false),
            )
        );

        $builder->add('siren',
            TextType::class, array(
                "label"       => $options["labelsiren"],
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "required"    => false,
            )
        );   

        $choices=array("oui" => "1","non" => "0");
        $builder->add("showsubappname",
        ChoiceType::class,array(
                "label"       =>"Afficher en tant que sous-titre ? ",
                'disabled'    => ($options["mode"]=="delete"?true:false),
                "choices"     => $choices
            )
        );  

        $choices=array(
            "Helvetica" => "Helvetica",
            "Peacesans" => "Peacesans",
            "Acme-Regular" => "Acme-Regular",
            "Redressed" => "Redressed",
            "Roboto-Regular" => "Roboto-Regular",
            "Justanotherhand-Regular" => "Justanotherhand-Regular",
            "Lato-Regular" => "Lato-Regular",

            "ABeeZee-Regular" => "ABeeZee-Regular",
            "AlfaSlabOne-Regular" => "AlfaSlabOne-Regular",
            "Anton-Regular" => "Anton-Regular",
            "FredokaOne-Regular" => "FredokaOne-Regular",
            "Overpass-Black" => "Overpass-Black",
            "Righteous-Regular" => "Righteous-Regular",
            "Signika-Regular" => "Signika-Regular",
            "Teko-Bold" => "Teko-Bold",
            "LuckiestGuy-Regular" => "LuckiestGuy-Regular",

            "Baloo-Regular" => "Baloo-Regular",
            "CarterOne-Regular" => "CarterOne-Regular",
            "Chewy-Regular" => "Chewy-Regular",
            "Courgette-Regular" => "Courgette-Regular",
            "LexendDeca-Regular" => "LexendDeca-Regular",
            "RubikMonoOne-Regular" => "RubikMonoOne-Regular",
            "SigmarOne-Regular" => "SigmarOne-Regular",
            "Viga-Regular" => "Viga-Regular",
        );

        $builder->add('colormain',
        TextType::class,
        array("label"     => "Couleur principale",
            "attr"        => array("class" => "pick-a-color form-control"),
            'required'    => false));    

        $builder->add('fontcolorhover',
        TextType::class,
        array("label"     => "Couleur de texte sur couleur Principale",
            "attr"        => array("class" => "pick-a-color form-control"),
            'required'    => false));    

        $builder->add('colorbody',
        TextType::class,
        array("label"     => "Couleur de fond des pages",
            "attr"        => array("class" => "pick-a-color form-control"),
            'required'    => false));    

        $builder->add("fontfacebody", ChoiceType::class,
            array("label"       =>"Police principale",
                  "attr"        => array("class" => "form-control"),
                  'required'    => false,
                  "choices"     => $choices));

        $builder->add("fontfacetitle", ChoiceType::class,
            array("label"       =>"Police pour les titres",
                  "attr"        => array("class" => "form-control"),
                  'required'    => false,
                  "choices"     => $choices));

                  
        $builder->add('logo',HiddenType::class);
        $builder->add('header',HiddenType::class);

        // Si masteridentity = LDAP alors on demande obligatoirement le filtre des utilisateurs qui appartiennent à ce niveau01
        if($options["masteridentity"]=="LDAP") 
        {
            $builder->add('ldapfilter',
                TextType::class, array(
                    "label"       => "Filtre LDAP des utilisateurs",
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                )
            );   
        }

        if($options["masteridentity"]=="SSO") 
        {
            $builder->add('attributes',
                TextareaType::class, array(
                    "label"       => "Attributs SSO des utilisateurs",
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("rows" => 10)
                )
            );   
        }        
        
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Niveau01',
            'mode' => "string",
            'labelsiren' => "string",
            'masteridentity' => "string"
        ));
    }
}
