<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Asset\Packages;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class HomeController extends AbstractController
{
    public function home()
    {
        return $this->redirectToRoute('app_activity');

        /*
        return $this->render('Home/home.html.twig',[
            "useheader"     => true,
            "usesidebar"    => false,
        ]);
        */
    }

    public function admin()
    {
        return $this->render('Home/admin.html.twig', [
            'useheader' => true,
            'usesidebar' => true,
        ]);
    }

    public function upload(Request $request, Packages $packages, $access = null)
    {
        // Fichier temporaire uploadé
        $tmpfile = $request->files->get('upload');
        $extention = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs = new Filesystem();
        $rootdir = $this->getParameter('kernel.project_dir').'/public';
        $fs->mkdir($rootdir.'/uploads/ckeditor');

        // Fichier cible
        $targetName = uniqid().'.'.$extention;
        $targetFile = $rootdir.'/uploads/ckeditor/'.$targetName;
        $targetUrl = $packages->getUrl('uploads/ckeditor/'.$targetName);

        move_uploaded_file($tmpfile, $targetFile);

        $output['uploaded'] = 1;
        $output['fileName'] = $targetName;
        $output['url'] = $targetUrl;

        return new Response(json_encode($output));
    }
}
