<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Document
 *
 * @ORM\Table(name="document")
 * @ORM\Entity(repositoryClass="App\Repository\DocumentRepository")
 */
class Document
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(name="filename", type="string")
     *
     */
    private $filename;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="entity", type="string")
     */
    private $entity;

    /**
     * @ORM\Column(type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="extention", type="string")
     */
    private $extention;

    /**
     * @ORM\Column(name="minetype", type="string")
     */
    private $minetype;

    /**
     * @ORM\Column(name="havethumb", type="boolean")
     */
    private $havethumb;

    /**
     * @ORM\ManyToOne(targetEntity="Activity", inversedBy="activitydocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $activity;

    /**
     * @ORM\ManyToOne(targetEntity="Activity", inversedBy="correcteddocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $corrected;

    /**
     * @ORM\ManyToOne(targetEntity="Answer", inversedBy="answerdocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $answer;

    /**
     * @ORM\ManyToOne(targetEntity="Answer", inversedBy="answercorrecteddocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $answercorrected;

    
    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getFilename(): ?string
    {
        return $this->filename;
    }

    public function setFilename(string $filename): self
    {
        $this->filename = $filename;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getEntity(): ?string
    {
        return $this->entity;
    }

    public function setEntity(string $entity): self
    {
        $this->entity = $entity;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

    public function getExtention(): ?string
    {
        return $this->extention;
    }

    public function setExtention(string $extention): self
    {
        $this->extention = $extention;

        return $this;
    }

    public function getMinetype(): ?string
    {
        return $this->minetype;
    }

    public function setMinetype(string $minetype): self
    {
        $this->minetype = $minetype;

        return $this;
    }

    public function getHavethumb(): ?bool
    {
        return $this->havethumb;
    }

    public function setHavethumb(bool $havethumb): self
    {
        $this->havethumb = $havethumb;

        return $this;
    }

    public function getActivity(): ?Activity
    {
        return $this->activity;
    }

    public function setActivity(?Activity $activity): self
    {
        $this->activity = $activity;

        return $this;
    }

    public function getCorrected(): ?Activity
    {
        return $this->corrected;
    }

    public function setCorrected(?Activity $corrected): self
    {
        $this->corrected = $corrected;

        return $this;
    }

    public function getAnswer(): ?Answer
    {
        return $this->answer;
    }

    public function setAnswer(?Answer $answer): self
    {
        $this->answer = $answer;

        return $this;
    }

    public function getAnswercorrected(): ?Answer
    {
        return $this->answercorrected;
    }

    public function setAnswercorrected(?Answer $answercorrected): self
    {
        $this->answercorrected = $answercorrected;

        return $this;
    }

   
}