<?php
namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="message")
 */
class Message
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     */
    private $message;

    /**
     * @ORM\Column(type="datetime")
     */
    private $submitdate;

    /**
     * @ORM\Column(type="boolean")
     */
    private $deletable;

    /**
     * @ORM\Column(type="boolean")
     */
    private $information;

    /**
     * @ORM\ManyToOne(targetEntity="Answer", inversedBy="messages")
     */
    private $answer;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="messages")
     */
    private $user;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="messagereaders", cascade={"persist"})
     * @ORM\JoinTable(name="messageuserread",
     *   joinColumns={@ORM\JoinColumn(name="message", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $readers;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->submitdate = new \DateTime();
        $this->readers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(string $message): self
    {
        $this->message = $message;

        return $this;
    }

    public function getSubmitdate(): ?\DateTimeInterface
    {
        return $this->submitdate;
    }

    public function setSubmitdate(\DateTimeInterface $submitdate): self
    {
        $this->submitdate = $submitdate;

        return $this;
    }

    public function getDeletable(): ?bool
    {
        return $this->deletable;
    }

    public function setDeletable(bool $deletable): self
    {
        $this->deletable = $deletable;

        return $this;
    }

    public function getAnswer(): ?Answer
    {
        return $this->answer;
    }

    public function setAnswer(?Answer $answer): self
    {
        $this->answer = $answer;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getReaders(): Collection
    {
        return $this->readers;
    }

    public function addReader(User $reader): self
    {
        if (!$this->readers->contains($reader)) {
            $this->readers[] = $reader;
        }

        return $this;
    }

    public function removeReader(User $reader): self
    {
        if ($this->readers->contains($reader)) {
            $this->readers->removeElement($reader);
        }

        return $this;
    }

    public function getInformation(): ?bool
    {
        return $this->information;
    }

    public function setInformation(bool $information): self
    {
        $this->information = $information;

        return $this;
    }

}
