<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class ActivitymessageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
          SubmitType::class, [
                "label" => "Envoyer",
                "attr" => ["class" => "btn btn-success"],
            ]
        );

        $builder->add('message',
            CKEditorType::class, [
                "mapped" => false,
                "required" => true,
                "config_name" => 'small_config',
                "config" => [
                    'uiColor' => '#ffffff',
                    'height' => 150,
                    'filebrowserUploadRoute' => 'app_ckeditor_upload',
                    'language' => 'fr',
                ],
            ]
        );        

        $builder->add('answers',
            Select2EntityType::class, [
                "label" => "Elèves",
                "mapped" => false,
                "required"    => true,
                "multiple" => true,
                "remote_route" => "app_answer_select",
                "remote_params" => ["activity"=>$options["id"]],
                "class" => "App:Answer",
                "primary_key" => "id",
                "text_property" => "displayname",
                "minimum_input_length" => 0,
                "page_limit" => 100,
                "allow_clear" => true,
                "delay" => 250,
                "cache" => false,
                "cache_timeout" => 60000,
                "language" => "fr",
                "placeholder" => "Selectionner des élèves",
            ]
        );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'App\Entity\Activity',
            'mode'          => 'string',
            'id'            => 'integer',
        ));
    }
}
