<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class AnswerType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => "Valider",
                "attr" => ["class" => "btn btn-success"],
            ]
        );

        if($options["status"]<10 && $options["activitystatus"] == 1 && !$options["ended"]) {
            $builder->add('returned',
            SubmitType::class, [
                "label" => "Rendre l'activité",
                "attr" => [
                    "class" => "btn btn-success",
                    "data-method" => "submit",
                    "data-confirm" => "Confirmez vous ? Une fois rendue, vous ne pourrez plus modifier l'activité."],
                ]
            );
        }

        if ($options["status"]<10&&$options["activitystatus"]==1&&!$options["ended"]) {
            $builder->add('answer',
                CKEditorType::class, [
                    "disabled" => ($options["status"]>=10||$options["activitystatus"]!=1||$options["ended"]),
                    "required" => false,
                    "config" => [
                        'uiColor' => '#ffffff',
                        'height' => 400,
                        'filebrowserUploadRoute' => 'app_ckeditor_upload',
                        'language' => 'fr',
                    ],
                ]
            );        
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'        => 'App\Entity\Answer',
            'mode'              => 'string',
            'status'            => 'integer',
            'activitystatus'    => 'integer',
            'ended'             => 'boolean',
        ));
    }
}
