<?php

namespace App\Repository;

use App\Entity\Activity;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class ActivityRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Activity::class);
    } 

    public function findAllMasterActivityActive($user,$activeactivity) {
        $qb = $this->createQueryBuilder('activity')
                    ->Where('activity.user=:user')
                    ->setParameter('user',$user);

        if($activeactivity)
            $qb->andWhere('activity.status<10');
        else
            $qb->andWhere('activity.status=10');

        return $qb->getQuery()->getResult();
    }

    public function findAllGroupActivityActive($group,$activeactivity) {
        $qb = $this->createQueryBuilder('activity')
                    ->Where('activity.group=:group')
                    ->setParameter('group',$group);

        if($activeactivity)
            $qb->andWhere('activity.status=1');
        else
            $qb->andWhere('activity.status=10');

        return $qb->getQuery()->getResult();
    }

}
