<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Form\FormError;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use App\Entity\Activity as Entity;
use App\Entity\Answer as Answer;
use App\Entity\Document;
use App\Entity\Message as Message;

use App\Form\ActivityType as Form;

class ActivityController extends AbstractController
{
    private $data   = "activity";
    private $route  = "app_activity";
    private $render = "Activity/";
    private $entity = "App:Activity";


    private $mail;
    public function __construct(\App\Service\mailService $mail) { $this->mail = $mail; }

    public function list(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user=$this->getUser();
        $activeactivity=$this->get('session')->get('activeactivity');

        // View master
        if ($user->hasRole('ROLE_ADMIN')||$user->hasRole('ROLE_MASTER')) {
            $datas = $em->getRepository($this->entity)->findAllMasterActivityActive($user,$activeactivity);

            return $this->render($this->render.'list.html.twig',[
                $this->data."s" => $datas,
                "useheader"     => true,
                "usesidebar"    => false,
            ]);
        }
        // View user
        elseif($user->hasRole('ROLE_USER')) {
            $user=$this->getUser();
            
            // Recherche de l'ensemble des activités distribuées des groupes de l'utilisateur
            $datas=new ArrayCollection();
            foreach($user->getGroups() as $group) {
                $activitys = $em->getRepository($this->entity)->findAllGroupActivityActive($group,$activeactivity);

                foreach($activitys as $activity) {
                    if($activeactivity&&$activity->getStatus()==10) continue;
                    if(!$activeactivity&&$activity->getStatus()<10) continue;

                
                    // Recherche d'une réponse pour l'utilistaeur
                    $answer=$em->getRepository("App:Answer")->findOneBy(["user"=>$user, "activity" => $activity]);

                    // Si pas de réponse on initialise une réponse à vue
                    if(!$answer) {
                        $answer=new Answer();
                        $answer->setStatus(0);
                        $answer->setUser($user);
                        $answer->setActivity($activity);
                        $em->persist($answer);
                        $em->flush();
                    }

                    // Si réponse non vu on la place en vu
                    if($answer->getStatus()==-1) {
                        $answer->setStatus(0);
                        $em->persist($answer);
                        $em->flush();

                        // Message
                        $message = new Message;
                        $message->setMessage("Vu");
                        $message->setDeletable(false);
                        $message->setUser($user);
                        $message->setAnswer($answer);
                        $message->setInformation(true);
                        $message->addReader($user);
                        $em->persist($message);
                        $em->flush();                        
                    }

                    $activity->setAnsweruser($answer);
                    $datas->add($activity);
                }
            }
            return $this->render('Answer/list.html.twig',[
                $this->data."s" => $datas,
                "useheader"     => true,
                "usesidebar"    => false,
                "now"           => new \DateTime(),
            ]);
        }
    }

    public function submit(Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Entity();
        $data->setStatus(0);

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"submit","status"=>$data->getStatus()));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $data->setUser($this->getUser());
            $em->persist($data);
            $em->flush();

            // Retour à l'activité en mode modification
            return $this->redirectToRoute($this->route."_update",["id"=>$data->getId()]);
        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => false,                 
            $this->data         => $data,
            'mode'              => 'submit',
            'form'              => $form->createView()
        ]);
    }  
    
    public function update($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        // Controle accès
        if(!$data)
            return $this->redirectToRoute($this->route);
        else {
            if(!$this->getUser()->Hasrole("ROLE_ADMIN")&&$this->getUser()!=$data->getUser()) 
                return $this->redirectToRoute($this->route);
        }

        $maxanwsered=-1;
        foreach($data->getAnswers() as $answer) {
            $maxanwsered=max($maxanwsered,$answer->getStatus());
        }

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update","status"=>$data->getStatus(),"maxanwsered"=>$maxanwsered));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");
        
        $valid=false;
        if($form->isSubmitted()&&$form->isValid()) {
            if($form->get('submit')->isClicked())
                $valid=true;
            
            if ($form->has('recraft') && $form->get('recraft')->isClicked())
                $valid=true;

            if ($form->has('distribution') && $form->get('distribution')->isClicked())
                $valid=true;

            if ($form->has('archiving') && $form->get('archiving')->isClicked())
                $valid=true;                

            if($form->get('clone')->isClicked())
                $valid=true;

        }

        // Sur validation
        if ($valid) {  
            $data = $form->getData();  

            // Distribution de l'activité
            if ($form->has('distribution') && $form->get('distribution')->isClicked()) {
                // Si réouverture
                if($data->getStatus()==10) {
                    // Message
                    foreach($data->getAnswers() as $answer) {
                        $message=new Message;
                        $message->setMessage("Réouverture de l'Activité");
                        $message->setDeletable(false);
                        $message->setUser($data->getUser());
                        $message->setAnswer($answer);
                        $message->setInformation(true);
                        $message->addReader($data->getUser());
                        $em->persist($message);
                        $em->flush();

                        // Notification par mail de la distribution de l'activité
                        $to = $answer->getUser()->getEmail();
                        $from =  $data->getUser()->getEmail();
                        $subject="Nineschool : Réouverture de l'activité";
                        $body ="Activité = ".$data->getName()."<br>";
                        $body.="Professeur = ".$data->getUser()->getDisplayname()."<br>";
                        $body.="Matière = ".$data->getSubject()."<br>";
                        $body.="Url = ".$this->generateUrl('app_answer_update', ["id"=>$answer->getId()], UrlGeneratorInterface::ABSOLUTE_URL);

                        $this->mail->sendEmail($subject, $body, $to, $from);
                    }
                }

                // Passage à distribuer
                $data->setStatus(1);
            }


            // Replacer de l'activité en mode brouillon
            if ($form->has('recraft') && $form->get('recraft')->isClicked()) {
                foreach($data->getAnswers() as $answer) {
                    $em->remove($answer);
                    $em->flush();
                    
                }
                // Passage à brouillon
                $data->setStatus(0);
            }

            // Archivage de l'activité
            if ($form->has('archiving') && $form->get('archiving')->isClicked()) {
                $data->setStatus(10);

                // Message
                foreach($data->getAnswers() as $answer) {
                    $message=new Message;
                    $message->setMessage("Archivage de l'Activité");
                    $message->setDeletable(false);
                    $message->setUser($data->getUser());
                    $message->setAnswer($answer);
                    $message->setInformation(true);
                    $message->addReader($data->getUser());
                    $message->addReader($answer->getUser());
                    $em->persist($message);
                    $em->flush();
        
                }
            }

            $em->persist($data);
            $em->flush();

            // On initialise une réponse pour l'ensemble des élèves
            if($data->getStatus()>0&&$data->getStatus()<10)
                $this->initAnswer($data);

            // Distribution de l'activité
            if ($form->has('clone') && $form->get('clone')->isClicked()) {
                return $this->redirectToRoute($this->route."_clone",["id"=>$data->getId()]);
            }

            // Retour à la liste
            return $this->redirectToRoute($this->route);
        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => false,                 
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }  

    public function delete($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        // Controle accès
        if(!$data)
            return $this->redirectToRoute($this->route);
        else {
            if(!$this->getUser()->Hasrole("ROLE_ADMIN")&&$this->getUser()!=$data->getUser()) 
                return $this->redirectToRoute($this->route);
        }

        // Controle avant suppression
        $haveerror=false;
        if($data->getStatus()!=0&&$data->getStatus()!=10) {
            $request->getSession()->getFlashBag()->add("error", 'Cette activité a été distribué vous ne pouvez plus la supprimer');
            $haveerror=true;
        }

        if($haveerror) {
            return $this->redirectToRoute($this->route."_update",["id"=>$id]);
        }
        else {
            $em->remove($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->route);
        }
    } 

    public function archive($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        // Controle accès
        if(!$data)
            return $this->redirectToRoute($this->route);
        else {
            if(!$this->getUser()->Hasrole("ROLE_ADMIN")&&$this->getUser()!=$data->getUser()) 
                return $this->redirectToRoute($this->route);
        }

        // Message
        foreach($data->getAnswers() as $answer) {
            $message=new Message;
            $message->setMessage("Archivage de l'Activité");
            $message->setDeletable(false);
            $message->setUser($data->getUser());
            $message->setAnswer($answer);
            $message->setInformation(true);
            $message->addReader($data->getUser());
            $message->addReader($answer->getUser());
            $em->persist($message);
            $em->flush();
        }

        $data->setStatus(10);
        $em->persist($data);
        $em->flush();

        // Retour à la liste
        return $this->redirectToRoute($this->route);
    } 

    protected function initAnswer($activity) {
        $em = $this->getDoctrine()->getManager();

        // Pour chaque élève
        $group=$activity->getGroup();
        foreach($group->getUsers() as $user) {
            // Existe-t-il une réponse pour l'élève
            if($user->hasRole("ROLE_USER")) {
                $answer=$em->getRepository("App:Answer")->findOneBy(["user"=>$user,"activity"=>$activity]);
                if(!$answer) {
                    $answer=new Answer;
                    $answer->setActivity($activity);
                    $answer->setUser($user);
                    $answer->setStatus(-1);

                    $em->persist($answer);
                    $em->flush();       
                    
                    // Message
                    $message=new Message;
                    $message->setMessage("Distribution de l'Activité");
                    $message->setDeletable(false);
                    $message->setUser($activity->getUser());
                    $message->setAnswer($answer);
                    $message->setInformation(true);
                    $message->addReader($activity->getUser());

                    $em->persist($message);
                    $em->flush();       

                    // Notification par mail de la distribution de l'activité
                    $to = $user->getEmail();
                    $from =  $activity->getUser()->getEmail();
                    $subject="Nineschool : Nouvelle Activité à réaliser";
                    $body ="Activité = ".$activity->getName()."<br>";
                    $body.="Professeur = ".$activity->getUser()->getDisplayname()."<br>";
                    $body.="Matière = ".$activity->getSubject()."<br>";
                    $body.="Url = ".$this->generateUrl('app_answer_update', ["id"=>$answer->getId()], UrlGeneratorInterface::ABSOLUTE_URL);

                    $this->mail->sendEmail($subject, $body, $to, $from);
                }
            }
        }
    }

    public function activeactivity() {
        $this->get('session')->set('activeactivity',!$this->get('session')->get('activeactivity'));
        return $this->redirectToRoute($this->route);
    }

    public function clone($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $toclone=$em->getRepository($this->entity)->find($id);

        $data = new Entity();
        $data->setStatus(0);
        $data->setUser($this->getUser());
        
        $data->setName("Duplication de l'activité = ".$toclone->getName());
        $data->setSubject($toclone->getSubject());
        $data->setGroup($toclone->getGroup());
        $data->setActivity($toclone->getActivity());
        $data->setCorrected($toclone->getCorrected());

        // Sauvegarde nécessaire afin de pouvoir rattacher les documents clonés
        $em->persist($data);
        $em->flush();

        // Cloner les documents
        foreach($toclone->getActivitydocuments() as $clonedocument ) {
            $document = new Document();
            $document->setName($clonedocument->getName());
            $document->setFilename($clonedocument->getFilename());
            $document->setDescription($clonedocument->getDescription());
            $document->setEntity($clonedocument->getEntity());
            $document->setRoworder($clonedocument->getRoworder());
            $document->setExtention($clonedocument->getExtention());
            $document->setMinetype($clonedocument->getMinetype());
            $document->setHavethumb($clonedocument->getHavethumb());
            $document->setActivity($data);
            $em->persist($document);
            $em->flush();
        }

        foreach($toclone->getCorrecteddocuments() as $clonedocument ) {
            $document = new Document();
            $document->setName($clonedocument->getName());
            $document->setFilename($clonedocument->getFilename());
            $document->setDescription($clonedocument->getDescription());
            $document->setEntity($clonedocument->getEntity());
            $document->setRoworder($clonedocument->getRoworder());
            $document->setExtention($clonedocument->getExtention());
            $document->setMinetype($clonedocument->getMinetype());
            $document->setHavethumb($clonedocument->getHavethumb());
            $document->setCorrected($data);
            $em->persist($document);
            $em->flush();
        }

        // On copie le répertoire 
        $source = $this->getParameter('kernel.project_dir')."/uploads/document/activity/".$id;
        $destination = $this->getParameter('kernel.project_dir')."/uploads/document/activity/".$data->getId();
        $fs = new Filesystem();
        if ($fs->exists($source)) {
            $fs->mirror($source,$destination);
        }

        $source = $this->getParameter('kernel.project_dir')."/uploads/document/corrected/".$id;
        $destination = $this->getParameter('kernel.project_dir')."/uploads/document/corrected/".$data->getId();
        $fs = new Filesystem();
        if ($fs->exists($source)) {
            $fs->mirror($source,$destination);
        }
        
        // Retour à l'activité en mode modification
        return $this->redirectToRoute($this->route."_update",["id"=>$data->getId()]);
        
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit"||$mode=="update")) {
            if($data->getStartdate()&&$data->getEnddate()&&$data->getStartdate()>=$data->getEnddate()) {
                $form->addError(new FormError("La date de début doit être inférieure à la date de fin"));                
            }
        }

        if ($form->has('archiving') && $form->get('archiving')->isClicked()) {
            // On s'assure que l'ensemble des réponses sont corrigés sinon message de conformation
            $ok=true;
            foreach($data->getAnswers() as $answer) {
                if($answer->getStatus()!=15) {
                    $ok=false;                    
                }
            }
            if(!$ok) {
                $url=$this->generateUrl('app_activity_archive', ["id"=>$data->getId()]);
                $form->addError(new FormError("L'ensemble des activités non pas été corrigées. Souhaitez-vous archiver l'activité malgré tout ?<br><a class='btn btn-danger' href='".$url."'>Forcer l'Archivage</a>"));
            }
        }

        if (($form->get('submit')->isClicked() || ($form->has('archiving') && $form->get('archiving')->isClicked()) ) && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }     
}
