<?php

namespace App\Controller;

use App\Entity\Document as Entity;
use App\Form\DocumentType as Form;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Asset\Packages;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

class DocumentController extends AbstractController
{
    private $data = 'document';
    private $route = 'app_document';
    private $render = 'Document/';
    private $entity = 'App:Document';

    public function upload($entity, $id)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Rendu
        return $this->render($this->render.'upload.html.twig', [
            'useheader' => false,
            'usesidebar' => false,
            'entity' => $entity,
            'id' => $id,
        ]);
    }

    public function record($entity, $id)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Rendu
        return $this->render($this->render.'record.html.twig', [
            'useheader' => false,
            'usesidebar' => false,
            'entity' => $entity,
            'id' => $id,
        ]);
    }

    public function recordupload($entity, $id, Request $request)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Récupérper l'enregistrement
        $content = $request->getContent();
        $name = $request->get('name');

        // Destination
        $directory = $this->getParameter('kernel.project_dir').'/uploads/document/'.$entity.'/'.$id;
        $filename = uniqid().'.ogg';

        // Ecrire sur le filesystem
        $fs = new Filesystem();
        $fs->mkdir($directory);
        $fp = fopen($directory.'/'.$filename, 'wb');
        fwrite($fp, $content);
        fclose($fp);

        // Création du document
        $em = $this->getDoctrine()->getManager();
        $document = new Entity();
        $document->setName($name);
        $document->setFilename($filename);
        $document->setRoworder(99999);
        $document->setExtention('ogg');
        $document->setMinetype('video/webm');
        $document->setHavethumb(false);
        $document->setEntity($entity);

        // Rattacher le document à l'entity
        switch ($entity) {
            case 'activity':
                $activity = $em->getRepository('App:Activity')->find($id);
                $document->setActivity($activity);
            break;

            case 'corrected':
                $corrected = $em->getRepository('App:Activity')->find($id);
                $document->setCorrected($corrected);
            break;

            case 'answer':
                $answer = $em->getRepository('App:Answer')->find($id);
                $document->setAnswer($answer);
            break;

            case 'answercorrected':
                $answer = $em->getRepository('App:Answer')->find($id);
                $document->setAnswercorrected($answer);
            break;
        }

        // Sauvegarde
        $em->persist($document);
        $em->flush();

        // Retour
        return new Response(json_encode([]));
    }

    public function video($entity, $id)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Rendu
        return $this->render($this->render.'video.html.twig', [
            'useheader' => false,
            'usesidebar' => false,
            'entity' => $entity,
            'id' => $id,
        ]);
    }

    public function videoupload($entity, $id, Request $request)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Récupérper l'enregistrement
        $content = $request->getContent();
        $name = $request->get('name');

        // Destination
        $directory = $this->getParameter('kernel.project_dir').'/uploads/document/'.$entity.'/'.$id;
        $filename = uniqid().'.webm';

        // Ecrire sur le filesystem
        $fs = new Filesystem();
        $fs->mkdir($directory);
        $fp = fopen($directory.'/'.$filename, 'wb');
        fwrite($fp, $content);
        fclose($fp);

        // Création du document
        $em = $this->getDoctrine()->getManager();
        $document = new Entity();
        $document->setName($name);
        $document->setFilename($filename);
        $document->setRoworder(99999);
        $document->setExtention('webm');
        $document->setMinetype('video/webm');
        $document->setHavethumb(false);
        $document->setEntity($entity);

        // Rattacher le document à l'entity
        switch ($entity) {
            case 'activity':
                $activity = $em->getRepository('App:Activity')->find($id);
                $document->setActivity($activity);
            break;

            case 'corrected':
                $corrected = $em->getRepository('App:Activity')->find($id);
                $document->setCorrected($corrected);
            break;

            case 'answer':
                $answer = $em->getRepository('App:Answer')->find($id);
                $document->setAnswer($answer);
            break;

            case 'answercorrected':
                $answer = $em->getRepository('App:Answer')->find($id);
                $document->setAnswercorrected($answer);
            break;
        }

        // Sauvegarde
        $em->persist($document);
        $em->flush();

        // Retour
        return new Response(json_encode([]));
    }

    public function list($entity, $id, $master, Packages $packages)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if (!$this->ctrlAccessentity($entity, $id, 'view')) {
            return new Response(json_encode(['KO']));
        }

        // Récupérer les documents
        $em = $this->getDoctrine()->getManager();
        $documents = null;
        switch ($entity) {
            case 'activity':
                $activity = $em->getRepository('App:Activity')->find($id);
                if ($activity) {
                    $documents = $em->getRepository('App:Document')->findBy(['activity' => $activity]);
                    if (0 != $activity->getStatus()) {
                        $master = false;
                    }
                }
            break;

            case 'corrected':
                $corrected = $em->getRepository('App:Activity')->find($id);
                if ($corrected) {
                    $documents = $em->getRepository('App:Document')->findBy(['corrected' => $corrected]);
                    if (10 == $corrected->getStatus()) {
                        $master = false;
                    }
                }

            break;

            case 'answer':
                $answer = $em->getRepository('App:Answer')->find($id);
                if ($answer) {
                    $documents = $em->getRepository('App:Document')->findBy(['answer' => $answer]);
                    if ($answer->getStatus() >= 10) {
                        $master = false;
                    }
                    if (10 == $answer->getActivity()->getStatus()) {
                        $master = false;
                    }
                }
            break;

            case 'answercorrected':
                $answercorrected = $em->getRepository('App:Answer')->find($id);
                if ($answercorrected) {
                    $documents = $em->getRepository('App:Document')->findBy(['answercorrected' => $answercorrected]);
                    if ($answercorrected->getStatus() >= 15) {
                        $master = false;
                    }
                    if (10 == $answercorrected->getActivity()->getStatus()) {
                        $master = false;
                    }
                }
            break;
        }

        // Construire le tableau d'id
        $output = [];

        foreach ($documents as $document) {
            $tmp = [
                'id' => $document->getId(),
                'html' => $this->thumb($document->getId(), $master, $packages),
            ];

            array_push($output, $tmp);
        }

        // Retour
        return new Response(json_encode($output));
    }

    public function thumb($id, $master, Packages $packages)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->entity)->find($id);

        $title = $data->getName();
        $filename = $data->getFilename();
        $description = $data->getDescription();
        $extention = $data->getExtention();
        $minetype = $data->getMinetype();
        $minefamily = explode('/', $minetype)[0];

        switch ($data->getEntity()) {
            case 'activity': $identity = $data->getActivity()->getId(); break;
            case 'corrected': $identity = $data->getCorrected()->getId(); break;
            case 'answer': $identity = $data->getAnswer()->getId(); break;
            case 'answercorrected': $identity = $data->getAnswercorrected()->getId(); break;
        }
        if ($data->getHavethumb()) {
            $directory = $this->getParameter('kernel.project_dir').'/uploads/document/'.$data->getEntity().'/'.$identity;
            $dataimg = file_get_contents($directory.'/thumb/'.$filename);
            $url = 'data:image/'.$extention.';base64,'.base64_encode($dataimg);
        } else {
            $url = $packages->getUrl('images/files/'.$extention.'.png');
        }

        return $this->renderView($this->render.'render.html.twig', [
            'entity' => $data->getEntity(),
            'id' => $id,
            'title' => $title,
            'description' => $description,
            'url' => $url,
            'extention' => $extention,
            'minefamily' => $minefamily,
            'master' => $master,
        ]);
    }

    public function view($entity, $id)
    {
        // Controles d'accès sur le document
        if (!$this->ctrlAccessdocument($entity, $id, 'view')) {
            return $this->redirectToRoute('app_activity');
        }

        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->entity)->find($id);

        switch ($data->getEntity()) {
            case 'activity': $identity = $data->getActivity()->getId(); break;
            case 'corrected': $identity = $data->getCorrected()->getId(); break;
            case 'answer': $identity = $data->getAnswer()->getId(); break;
            case 'answercorrected': $identity = $data->getAnswercorrected()->getId(); break;
        }

        $directory = $this->getParameter('kernel.project_dir').'/uploads/document/'.$entity.'/'.$identity;
        $url = $directory.'/'.$data->getFilename();
        $file = new file($url);

        $minetype = $file->getMimeType();
        $minefamily = explode('/', $minetype)[0];

        if ('text' == $minefamily || 'image' == $minefamily) {
            $image = '';
            if ('image' == $minefamily) {
                $image = 'data:image/'.$file->getExtension().';base64,'.base64_encode(file_get_contents($url));
            }

            return $this->render($this->render.'view.html.twig', [
                'useheader' => false,
                'usesidebar' => false,
                'entity' => $entity,
                'id' => $id,
                'minefamily' => $minefamily,
                'image' => $image,
            ]);
        } else {
            $response = new BinaryFileResponse($file);
            $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);

            return $response;
        }
    }

    public function show($entity, $id)
    {
        // Controles d'accès sur le document
        if (!$this->ctrlAccessdocument($entity, $id, 'view')) {
            return $this->redirectToRoute('app_activity');
        }

        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->entity)->find($id);

        switch ($data->getEntity()) {
            case 'activity': $identity = $data->getActivity()->getId(); break;
            case 'corrected': $identity = $data->getCorrected()->getId(); break;
            case 'answer': $identity = $data->getAnswer()->getId(); break;
            case 'answercorrected': $identity = $data->getAnswercorrected()->getId(); break;
        }

        $directory = $this->getParameter('kernel.project_dir').'/uploads/document/'.$entity.'/'.$identity;
        $url = $directory.'/'.$data->getFilename();
        $file = new file($url);

        $response = new BinaryFileResponse($file);
        //$response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
        $name = ($data->getName() == $data->getFilename() ? $data->getFilename() : $data->getName().'.'.$data->getExtention());
        $response->setContentDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            $name
        );

        return $response;
    }

    public function update($entity, $id, Request $request)
    {
        // Controles d'accès sur le document
        if (!$this->ctrlAccessdocument($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->entity)->find($id);

        // Création du formulaire
        $form = $this->createForm(Form::class, $data, ['mode' => 'update']);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            $em->persist($data);
            $em->flush();

            return $this->render($this->render.'close.html.twig');
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader' => false,
            'usesidebar' => false,
            $this->data => $data,
            'mode' => 'update',
            'form' => $form->createView(),
        ]);
    }

    public function delete($entity, $id, Request $request)
    {
        // Controles d'accès sur le document
        if (!$this->ctrlAccessdocument($entity, $id, 'update')) {
            return $this->redirectToRoute('app_activity');
        }

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->entity)->find($id);

        // Création du formulaire
        $form = $this->createForm(Form::class, $data, ['mode' => 'update']);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        if ($data) {
            $em->remove($data);
            $em->flush();

            return $this->render($this->render.'close.html.twig');
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader' => false,
            'usesidebar' => false,
            $this->data => $data,
            'mode' => 'update',
            'form' => $form->createView(),
        ]);
    }

    private function ctrlAccessentity($entity, $id, $mode)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();

        switch ($entity) {
            case 'activity':
                $data = $em->getRepository('App:Activity')->find($id);
                if (!$data) {
                    return false;
                }

                $group = $data->getGroup();
                $user = $this->getUser();
                $isadmin = ($user->Hasrole('ROLE_ADMIN'));
                $ismaster = ($user == $data->getUser());
                $ismember = ($group->getUsers()->contains($this->getUser()));

                // Test visualisation = tout les membres du groupes peuvent voir l'énoncé
                if (!$isadmin && !$ismaster && !$ismember) {
                    return false;
                }

                // Membre = Test visualisation activité que si activité non brouillon
                if (!$isadmin && !$ismaster && $ismember) {
                    if (0 == $data->getStatus()) {
                        return false;
                    }
                }

                // Test modification = Impossible de modifier un document si activité non brouillon
                if ('update' == $mode && ((!$isadmin && !$ismaster) || $data->getStatus() > 0)) {
                    return false;
                }
            break;

            case 'corrected':
                $data = $em->getRepository('App:Activity')->find($id);
                if (!$data) {
                    return false;
                }

                $group = $data->getGroup();
                $user = $this->getUser();
                $isadmin = ($user->Hasrole('ROLE_ADMIN'));
                $ismaster = ($user == $data->getUser());
                $ismember = ($group->getUsers()->contains($this->getUser()));

                // Test visualisation
                if (!$isadmin && !$ismaster && !$ismember) {
                    return false;
                }

                // Membre = Visualisation uniquement si sa réponse est corrigée
                if (!$isadmin && !$ismaster && $ismember) {
                    $answer = $em->getRepository('App:Answer')->findOneBy(['activity' => $data, 'user' => $user]);
                    if (!$answer || $answer->getStatus() < 15) {
                        return false;
                    }
                }

                // Test modification = Impossible de modifier un document si activité close
                if ('update' == $mode && ((!$isadmin && !$ismaster) || 10 == $data->getStatus())) {
                    return false;
                }
            break;

            case 'answer':
                $data = $em->getRepository('App:Answer')->find($id);
                if (!$data) {
                    return false;
                }

                $user = $this->getUser();
                $isadmin = ($user->Hasrole('ROLE_ADMIN'));
                $ismaster = ($user == $data->getActivity()->getUser());
                $isuser = ($user == $data->getUser());

                // Test visualisation
                if (!$isadmin && !$ismaster && !$isuser) {
                    return false;
                }

                // Test modification = Impossible de modifier un document si réponse rendues ou activité non distribut
                if ('update' == $mode && ((!$isadmin && !$isuser) || $data->getStatus() >= 10 || 1 != $data->getActivity()->getStatus())) {
                    return false;
                }
            break;

            case 'answercorrected':
                $data = $em->getRepository('App:Answer')->find($id);
                if (!$data) {
                    return false;
                }

                $user = $this->getUser();
                $isadmin = ($user->Hasrole('ROLE_ADMIN'));
                $ismaster = ($user == $data->getActivity()->getUser());
                $isuser = ($user == $data->getUser());

                // Test visualisation
                if (!$isadmin && !$ismaster && !$isuser) {
                    return false;
                }

                // Membre = Visualisation uniquement si sa réponse est rendu
                if (!$isadmin && !$ismaster && $isuser) {
                    if ($data->getStatus() < 10) {
                        return false;
                    }
                }

                // Test modification = Impossible de modifier un document si réponse corrigées
                if ('update' == $mode && ((!$isadmin && !$ismaster) || $data->getStatus() >= 15 || 1 != $data->getActivity()->getStatus())) {
                    return false;
                }
            break;
        }

        return true;
    }

    private function ctrlAccessdocument($entity, $id, $mode)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();

        $document = $em->getRepository($this->entity)->find($id);
        if (!$document) {
            return false;
        }

        switch ($entity) {
            case 'activity':
                $data = $document->getActivity();

                return $this->ctrlAccessentity($entity, $data->getId(), $mode);
            break;

            case 'corrected':
                $data = $document->getCorrected();

                return $this->ctrlAccessentity($entity, $data->getId(), $mode);
            break;

            case 'answer':
                $data = $document->getAnswer();

                return $this->ctrlAccessentity($entity, $data->getId(), $mode);
            break;

            case 'answercorrected':
                $data = $document->getAnswercorrected();

                return $this->ctrlAccessentity($entity, $data->getId(), $mode);
            break;
        }

        return true;
    }
}
