<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * Group
 * 
 * @ORM\Entity(repositoryClass="App\Repository\GroupRepository")
 * @ORM\Table(name="groupe", uniqueConstraints={@ORM\UniqueConstraint(name="name", columns={"name"})}, indexes={@ORM\Index(name="idexternal", columns={"idexternal"})} )
 * @UniqueEntity("name", message="Ce nom de groupe existe dèja")
 */
class Group
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ldapfilter;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    private $idexternal;

    /**
    * @ORM\ManyToMany(targetEntity="User", mappedBy="groups")
    */    
    protected $users;

    /**
     * @ORM\OneToMany(targetEntity="Activity", mappedBy="group", cascade={"persist"}, orphanRemoval=true)
     */
    private $activitys;

    public function __construct()
    {
        $this->users = new ArrayCollection();
        $this->activitys = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getLdapfilter(): ?string
    {
        return $this->ldapfilter;
    }

    public function setLdapfilter(?string $ldapfilter): self
    {
        $this->ldapfilter = $ldapfilter;

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
            $user->addGroup($this);
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
            $user->removeGroup($this);
        }

        return $this;
    }

    public function getIdexternal(): ?string
    {
        return $this->idexternal;
    }

    public function setIdexternal(?string $idexternal): self
    {
        $this->idexternal = $idexternal;

        return $this;
    }

    /**
     * @return Collection|Activity[]
     */
    public function getActivitys(): Collection
    {
        return $this->activitys;
    }

    public function addActivity(Activity $activity): self
    {
        if (!$this->activitys->contains($activity)) {
            $this->activitys[] = $activity;
            $activity->setGroup($this);
        }

        return $this;
    }

    public function removeActivity(Activity $activity): self
    {
        if ($this->activitys->contains($activity)) {
            $this->activitys->removeElement($activity);
            // set the owning side to null (unless already changed)
            if ($activity->getGroup() === $this) {
                $activity->setGroup(null);
            }
        }

        return $this;
    }

}