<?php

namespace App\Twig;

use Symfony\Component\Asset\Packages;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class AppExtension extends AbstractExtension
{
    protected $container;
    private $packages;

    public function __construct(Packages $packages)
    {
        $this->packages = $packages;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('urlavatar', [$this, 'urlAvatar']),
        ];
    }

    public function urlAvatar($avatar)
    {
        if (0 === stripos($avatar, 'http')) {
            return $avatar;
        } else {
            return $this->packages->getUrl('uploads/avatar/'.$avatar);
        }
    }

    public function setContainer($container)
    {
        $this->container = $container;
    }
}
