<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class NotifyQuestCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $router;
    private $mail;
    private $weburl;
    private $alias;
    private $noreply;

    public function __construct(ContainerInterface $container,EntityManagerInterface $em, RouterInterface $router)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
        $this->router=$router;
    }

    protected function configure()
    {
        $this
            ->setName('app:notifyQuest')
            ->setDescription("Notifications associées aux enquêtes")
            ->setHelp("Notifications associées aux enquêtes")
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')            
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getLogDir()."/";
        $this->mail         = $this->container->get('app.mail.service');
        $this->weburl       = $this->container->getParameter('appWeburl');
        $this->alias        = $this->container->getParameter('appAlias');
        $this->noreply      = $this->container->getParameter('appMailnoreply');
        
        $this->writelnred('');
        $this->writelnred('== app:notifyQuest');        
        $this->writelnred('==========================================================================================================');

        // Envoyer un mail à l'ensemble des invités de enquête
        $questguests=$this->em->getRepository("App:Questguest")->findBy(["tonotifyguest"=>true]);
        foreach($questguests as $questguest) {
            $url=$this->router->generate('app_quest_byguestkey', ["key"=>$questguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
            $url=str_replace("http:","https:",$url);
            $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
            
            $to = $questguest->getEmail();
            $from = $questguest->getQuest()->getUser()->getEmail();
            $subject="Ninesurvey : Invitation à une enquête";
            if($questguest->getQuest()->getPrivate()) {
                $body ="Bonjour,<br>";
                $body.="Je vous invite à répondre à l'enquête suivante : ".$questguest->getQuest()->getTitle().".<br>";
                $body.="Pour ce faire, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder à l'enquête</a>.<br>";
            }
            else {
                $body ="Bonjour,<br>";
                $body.="Voici le lien qui vous permettra de modifier votre réponse à l'enquête : ".$questguest->getQuest()->getTitle().".<br>";
                $body.="Pour ce faire, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder à l'enquête</a>.<br>";
            }

            $this->mail->sendEmail($subject, $body, $to, $from);            

            $questguest->setTonotifyguest(false);
            $this->em->persist($questguest);
            $this->em->flush();            
        }

        // Envoyer un mail à l'ensemble des propriétaires
        $quests=$this->em->getRepository("App:Quest")->findBy(["notification"=>true]);
        foreach($quests as $quest) {
            $questguests=$this->em->getRepository("App:Questguest")->findBy(["quest"=>$quest,"tonotifyowner"=>true]);
            foreach($questguests as $questguest) {
                $url=$this->router->generate('app_quest_byuserkey', ["key"=>$quest->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $quest->getUser()->getEmail();
                $from = $this->noreply;
                $subject="Ninesurvey : Réponse à votre enquête";
                $body ="Bonjour,<br><br>";
                if($questguest->getEmail()!=$questguest->getDisplayname()) $body.=$questguest->getDisplayname()."<br>";
                $body.=$questguest->getEmail()."<br>";
                
                $body.="<br>Viens de répondre à votre enquête  : ".$questguest->getQuest()->getTitle().".<br>";
                $body.="Pour consulter le résultat, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder à l'enquête</a>.<br>";

                $this->mail->sendEmail($subject, $body, $to, $from);            

                $questguest->setTonotifyowner(false);
                $this->em->persist($questguest);
                $this->em->flush();            
            }
        }

        // Envoyer notification de résultat
        $quests=$this->em->getRepository("App:Quest")->findBy(["tonotifyclose"=>true,"tonotifyopen"=>false]);
        foreach($quests as $quest) {           

            $questguests=$this->em->getRepository("App:Questguest")->findBy(["quest"=>$quest]);
            foreach($questguests as $questguest) {
                $url=$this->router->generate('app_quest_byguestkey_result', ["key"=>$questguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $questguest->getEmail();
                $from = $quest->getUser()->getEmail();
                $subject="Ninesurvey : Résultat de votre enquête";
                $body = $quest->getTonotifymessage();
                $body = str_replace("#LINK#",$url,$body);

                $this->mail->sendEmail($subject, $body, $to, $from);            
            }            

            $quest->setTonotifyclose(false);
            $this->em->persist($quest);
            $this->em->flush();                
        }

        // Envoyer notification de réouverture
        $quests=$this->em->getRepository("App:Quest")->findBy(["tonotifyclose"=>false,"tonotifyopen"=>true]);
        foreach($quests as $quest) {
            $questguests=$this->em->getRepository("App:Questguest")->findBy(["quest"=>$quest]);
            foreach($questguests as $questguest) {
                $url=$this->router->generate('app_quest_byguestkey', ["key"=>$questguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $questguest->getEmail();
                $from = $quest->getUser()->getEmail();
                $subject="Ninesurvey : Réouverture de votre enquête";
                $body = $quest->getTonotifymessage();
                $body = str_replace("#LINK#",$url,$body);

                $this->mail->sendEmail($subject, $body, $to, $from);            
            }            

            $quest->setTonotifyopen(false);
            $this->em->persist($quest);
            $this->em->flush();                
        }

        // Annuler les nofications simultanées
        $quests=$this->em->getRepository("App:Quest")->findBy(["tonotifyclose"=>true,"tonotifyopen"=>true]);
        foreach($quests as $quest) {
            $quest->setTonotifyclose(false);
            $quest->setTonotifyopen(false);
            $this->em->persist($quest);
            $this->em->flush();                
        }

        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }   



}
