<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class NotifySurveyCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $router;
    private $mail;
    private $weburl;
    private $alias;
    private $noreply;

    public function __construct(ContainerInterface $container,EntityManagerInterface $em, RouterInterface $router)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
        $this->router=$router;
    }

    protected function configure()
    {
        $this
            ->setName('app:notifySurvey')
            ->setDescription("Notifications associées aux sondages")
            ->setHelp("Notifications associées aux sondages")
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')            
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getLogDir()."/";
        $this->mail         = $this->container->get('app.mail.service');
        $this->weburl       = $this->container->getParameter('appWeburl');
        $this->alias        = $this->container->getParameter('appAlias');
        $this->noreply      = $this->container->getParameter('appMailnoreply');
        
        $this->writelnred('');
        $this->writelnred('== app:notifySurvey');        
        $this->writelnred('==========================================================================================================');

        // Envoyer un mail à l'ensemble des invités de sondage
        $surveyguests=$this->em->getRepository("App:Surveyguest")->findBy(["tonotifyguest"=>true]);
        foreach($surveyguests as $surveyguest) {
            $url=$this->router->generate('app_survey_byguestkey', ["key"=>$surveyguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
            $url=str_replace("http:","https:",$url);
            $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
            
            $to = $surveyguest->getEmail();
            $from = $surveyguest->getSurvey()->getUser()->getEmail();
            $subject="Ninesurvey : Invitation à un sondage de date";
            if($surveyguest->getSurvey()->getPrivate()) {
                $body ="Bonjour,<br>";
                $body.="Je vous invite à répondre au sondage suivant : ".$surveyguest->getSurvey()->getTitle().".<br>";
                $body.="Pour ce faire, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder au sondage</a>.<br>";
            }
            else {
                $body ="Bonjour,<br>";
                $body.="Voici le lien qui vous permettra de modifier votre réponse au sondage : ".$surveyguest->getSurvey()->getTitle().".<br>";
                $body.="Pour ce faire, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder au sondage</a>.<br>";
            }

            $this->mail->sendEmail($subject, $body, $to, $from);            

            $surveyguest->setTonotifyguest(false);
            $this->em->persist($surveyguest);
            $this->em->flush();            
        }

        // Envoyer un mail à l'ensemble des propriétaires
        $surveys=$this->em->getRepository("App:Survey")->findBy(["notification"=>true]);
        foreach($surveys as $survey) {
            $surveyguests=$this->em->getRepository("App:Surveyguest")->findBy(["survey"=>$survey,"tonotifyowner"=>true]);
            foreach($surveyguests as $surveyguest) {
                $url=$this->router->generate('app_survey_byuserkey', ["key"=>$survey->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $survey->getUser()->getEmail();
                $from = $this->noreply;
                $subject="Ninesurvey : Réponse à votre sondage de date";
                $body ="Bonjour,<br><br>";
                if($surveyguest->getEmail()!=$surveyguest->getDisplayname()) $body.=$surveyguest->getDisplayname()."<br>";
                $body.=$surveyguest->getEmail()."<br>";
                
                $body.="<br>Viens de répondre à votre sondage  : ".$surveyguest->getSurvey()->getTitle().".<br>";
                $body.="Pour consulter le résultat, veuillez cliquer sur le lien ci-après: <a href='".$url."'>accéder au sondage</a>.<br>";

                $this->mail->sendEmail($subject, $body, $to, $from);            

                $surveyguest->setTonotifyowner(false);
                $this->em->persist($surveyguest);
                $this->em->flush();            
            }
        }

        // Envoyer notification de résultat
        $surveys=$this->em->getRepository("App:Survey")->findBy(["tonotifyclose"=>true,"tonotifyopen"=>false]);
        foreach($surveys as $survey) {
            $choiced="";
            $surveyoption=$this->em->getRepository("App:Surveyoption")->findOneBy(["survey"=>$survey,"choiced"=>true]);
            if($surveyoption) $choiced=$surveyoption->getDate()->format("d/m/Y H:i");
            

            $surveyguests=$this->em->getRepository("App:Surveyguest")->findBy(["survey"=>$survey]);
            foreach($surveyguests as $surveyguest) {
                $url=$this->router->generate('app_survey_byguestkey', ["key"=>$surveyguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $surveyguest->getEmail();
                $from = $survey->getUser()->getEmail();
                $subject="Ninesurvey : Résultat de votre sondage de date";
                $body = $survey->getTonotifymessage();
                $body = str_replace("#DATE#",$choiced,$body);
                $body = str_replace("#LINK#",$url,$body);

                $this->mail->sendEmail($subject, $body, $to, $from);            
            }            

            $survey->setTonotifyclose(false);
            $this->em->persist($survey);
            $this->em->flush();                
        }

        // Envoyer notification de réouverture
        $surveys=$this->em->getRepository("App:Survey")->findBy(["tonotifyclose"=>false,"tonotifyopen"=>true]);
        foreach($surveys as $survey) {
            $surveyguests=$this->em->getRepository("App:Surveyguest")->findBy(["survey"=>$survey]);
            foreach($surveyguests as $surveyguest) {
                $url=$this->router->generate('app_survey_byguestkey', ["key"=>$surveyguest->getKey()], UrlGeneratorInterface::ABSOLUTE_URL);
                $url=str_replace("http:","https:",$url);
                $url=str_replace("/localhost/","/".$this->weburl."/".$this->alias."/",$url);
                
                $to = $surveyguest->getEmail();
                $from = $survey->getUser()->getEmail();
                $subject="Ninesurvey : Réouverture de votre sondage de date";
                $body = $survey->getTonotifymessage();
                $body = str_replace("#LINK#",$url,$body);

                $this->mail->sendEmail($subject, $body, $to, $from);            
            }            

            $survey->setTonotifyopen(false);
            $this->em->persist($survey);
            $this->em->flush();                
        }

        // Annuler les nofications simultanées
        $surveys=$this->em->getRepository("App:Survey")->findBy(["tonotifyclose"=>true,"tonotifyopen"=>true]);
        foreach($surveys as $survey) {
            $survey->setTonotifyclose(false);
            $survey->setTonotifyopen(false);
            $this->em->persist($survey);
            $this->em->flush();                
        }

        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }   



}
