<?php

namespace App\Form;

use App\Entity\Survey;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\AbstractType;    
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

class SurveyheaderType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        switch ($options['flow_step']) {
			case 1:
				$builder->add('title',TextType::class, [
                    "label" => "Titre"
                ]);
                $builder->add('description',CKEditorType::class, [
                    "required" => false,
                    "config" => [
                        'uiColor' => '#ffffff',
                        'height' => 400,
                        'filebrowserUploadRoute' => 'app_ckeditor_upload',
                        'language' => 'fr',
                    ],
                ]);
                $builder->add('private', Checkboxtype::class, [
                    'label' => 'Sondage privé',
                    'required' => false,
                ]);
                $builder->add('notification', Checkboxtype::class, [
                    'label' => 'Notifications',
                    'required' => false,
                ]);
                $builder->add('key', HiddenType::class, [
                    'label' => 'key',
                    'required' => true,
                ]);                
            break;
            
			case 2:
				$builder->add('jsonsurveyoptions', CollectionType::class, [
                    'entry_type' => SurveyoptionsType::class,
                    'entry_options' => ['label' => true],
                ]);
            break;

            case 3:
                $builder->add('jsonsurveyguests', CollectionType::class, [
                    'entry_type' => SurveyguestsType::class,
                    'entry_options' => ['label' => true],
                ]);
            break;

            case 4:
                $builder->add('jsonsurveyoptions', HiddenType::class, [
                    'label' => 'jsonsurveyoptions',
                    'required' => false,
                    'empty_data' => '',                  
                ]);

                $builder->add('jsonsurveyguests', HiddenType::class, [
                    'label' => 'jsonsurveyguests',
                    'required' => false,
                    'empty_data' => '',                  
                ]);
            break;
  


		}
        
		
    }

    public function getBlockPrefix() {
		return 'createSurvey';
	}

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Survey',
        ]);
    }
}
