<?php

namespace App\Entity;

use App\Repository\QuestRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=QuestRepository::class)
 */
class Quest
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="label", type="string", length=255)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="private", type="boolean")
     */
    private $private;

    /**
     * @ORM\Column(name="notification", type="boolean")
     */
    private $notification;

    /**
     * @ORM\Column(name="anonymous", type="boolean")
     */
    private $anonymous;

    /**
     * @ORM\Column(name="keyaccess", type="string", length=255)
     */
    private $key;

    /**
     * @ORM\Column(type="integer")
     */
    private $status;
    
    /**
     * @ORM\Column(type="boolean")
     */
    private $tonotifyclose;
    
    /**
     * @ORM\Column(type="boolean")
     */
    private $tonotifyopen;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $tonotifymessage;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="quests")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Questoption", mappedBy="quest", cascade={"persist"}, orphanRemoval=true)
     */
    private $questoptions;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Questguest", mappedBy="quest", cascade={"persist"}, orphanRemoval=true)
     */
    private $questguests;

    /**
     * Calculate
     * jsonquestoptions = formatage des options du quest en une chaine json
     * jsonquestguests  = formatage des guests du quest en une chaine json
     */
    private $jsonquestoptions;
    private $jsonquestguests;

    public function __construct()
    {
        $this->questoptions = new ArrayCollection();
        $this->questguests = new ArrayCollection();
    }

    public function setJsonquestoptions(string $jsonquestoptions): self
    {
        $this->jsonquestoptions = $jsonquestoptions;

        return $this;
    }

    public function getJsonquestoptions(): ?string
    {
        return $this->jsonquestoptions;
    }


    public function setJsonquestguests(string $jsonquestguests): self
    {
        $this->jsonquestguests = $jsonquestguests;

        return $this;
    }

    public function getJsonquestguests(): ?string
    {
        return $this->jsonquestguests;
    }    

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getPrivate(): ?bool
    {
        return $this->private;
    }

    public function setPrivate(bool $private): self
    {
        $this->private = $private;

        return $this;
    }

    public function getNotification(): ?bool
    {
        return $this->notification;
    }

    public function setNotification(bool $notification): self
    {
        $this->notification = $notification;

        return $this;
    }

    public function getAnonymous(): ?bool
    {
        return $this->anonymous;
    }

    public function setAnonymous(bool $anonymous): self
    {
        $this->anonymous = $anonymous;

        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getTonotifyclose(): ?bool
    {
        return $this->tonotifyclose;
    }

    public function setTonotifyclose(bool $tonotifyclose): self
    {
        $this->tonotifyclose = $tonotifyclose;

        return $this;
    }

    public function getTonotifyopen(): ?bool
    {
        return $this->tonotifyopen;
    }

    public function setTonotifyopen(bool $tonotifyopen): self
    {
        $this->tonotifyopen = $tonotifyopen;

        return $this;
    }

    public function getTonotifymessage(): ?string
    {
        return $this->tonotifymessage;
    }

    public function setTonotifymessage(?string $tonotifymessage): self
    {
        $this->tonotifymessage = $tonotifymessage;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Questoption[]
     */
    public function getQuestoptions(): Collection
    {
        return $this->questoptions;
    }

    public function addQuestoption(Questoption $questoption): self
    {
        if (!$this->questoptions->contains($questoption)) {
            $this->questoptions[] = $questoption;
            $questoption->setQuest($this);
        }

        return $this;
    }

    public function removeQuestoption(Questoption $questoption): self
    {
        if ($this->questoptions->removeElement($questoption)) {
            // set the owning side to null (unless already changed)
            if ($questoption->getQuest() === $this) {
                $questoption->setQuest(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Questguest[]
     */
    public function getQuestguests(): Collection
    {
        return $this->questguests;
    }

    public function addQuestguest(Questguest $questguest): self
    {
        if (!$this->questguests->contains($questguest)) {
            $this->questguests[] = $questguest;
            $questguest->setQuest($this);
        }

        return $this;
    }

    public function removeQuestguest(Questguest $questguest): self
    {
        if ($this->questguests->removeElement($questguest)) {
            // set the owning side to null (unless already changed)
            if ($questguest->getQuest() === $this) {
                $questguest->setQuest(null);
            }
        }

        return $this;
    }


        
}
