<?php
	class Request{
		
		private $base = false;

		private $webroot = "/";

		public $url; 				// URL appellé par l'utilisateur
		public $page = 1; 			// pour la pagination 
		public $prefix = false; 	// Prefixage des urls /prefix/url
		public $data = false; 		// Données envoyé dans le formulaire

		protected $_detector = array(
			'get' => array('env' => 'REQUEST_METHOD', 'value' => 'GET'),
			'post' => array('env' => 'REQUEST_METHOD', 'value' => 'POST'),
			'put' => array('env' => 'REQUEST_METHOD', 'value' => 'PUT'),
			'ajax' => array('env' => 'HTTP_X_REQUESTED_WITH', 'value' => 'XMLHttpRequest')
			);

		public function __construct( $url = null ){
			$this->_base();
			if( is_null($url) )
				$url = $this->url;
			if ($url[0] === '/') {
				$url = substr($url, 1);
			}
			$this->url = $url;

			
			// Si on a une page dans l'url on la rentre dans $this->page
			if(isset($_GET['page'])){
				if(is_numeric($_GET['page'])){
					if($_GET['page'] > 0){
						$this->page = round($_GET['page']); 
					}
				}
			}
			
			// Si des données ont été postées ont les entre dans data
			if(!empty($_POST)){
				$this->data = new stdClass(); 
				foreach($_POST as $k=>$v){
					if (is_array($v)) {
						$this->data->$k = array();
						foreach($v as $t=>$m){
							$tab = array($t => $m);
							if (is_array($m)) {
								array_push($this->data->$k, $tab);
							} else {
								array_push($this->data->$k,htmlspecialchars($m));
							}
						}
					} else {
						$this->data->$k=htmlspecialchars($v);
					}
				}
			}
		}

		protected function _url() {
			if (!empty($_SERVER['PATH_INFO'])) {
				return $_SERVER['PATH_INFO'];
			} elseif (isset($_SERVER['REQUEST_URI']) && strpos($_SERVER['REQUEST_URI'], '://') === false) {
				$uri = $_SERVER['REQUEST_URI'];
			} elseif (isset($_SERVER['REQUEST_URI'])) {
				$qPosition = strpos($_SERVER['REQUEST_URI'], '?');
				if ($qPosition !== false && strpos($_SERVER['REQUEST_URI'], '://') > $qPosition) {
					$uri = $_SERVER['REQUEST_URI'];
				} else {
					$uri = substr($_SERVER['REQUEST_URI'], strlen(Configure::read('App.fullBaseUrl')));
				}
			} elseif (isset($_SERVER['PHP_SELF']) && isset($_SERVER['SCRIPT_NAME'])) {
				$uri = str_replace($_SERVER['SCRIPT_NAME'], '', $_SERVER['PHP_SELF']);
			} elseif (isset($_SERVER['HTTP_X_REWRITE_URL'])) {
				$uri = $_SERVER['HTTP_X_REWRITE_URL'];
			} elseif ($var = env('argv')) {
				$uri = $var[0];
			}

			$base = $this->base;

			if (strlen($base) > 0 && strpos($uri, $base) === 0) {
				$uri = substr($uri, strlen($base));
			}
			if (strpos($uri, '?') !== false) {
				list($uri) = explode('?', $uri, 2);
			}
			if (empty($uri) || $uri === '/' || $uri === '//' || $uri === '/index.php') {
				$uri = '/';
			}
			$endsWithIndex = '/webroot/index.php';
			$endsWithLength = strlen($endsWithIndex);
			if (
				strlen($uri) >= $endsWithLength &&
				substr($uri, -$endsWithLength) === $endsWithIndex
			) {
				$uri = '/';
			}
			return $uri;
		}

		protected function _base() {
			$dir = $webroot = null;


			if (!isset($base)) {
				$base = $this->base;
			}
			if ($base !== false) {
				$this->webroot = $base . '/';

				return $this->base = $base;
			}



			$base = dirname($_SERVER['PHP_SELF']);

			$indexPos = strpos($base, '/webroot/index.php');
			if ($indexPos !== false) {
				$base = substr($base, 0, $indexPos) . '/webroot';
			}

			if ($webroot === 'webroot' && $webroot === basename($base)) {
				$base = dirname($base);
			}
			if ($dir === 'app' && $dir === basename($base)) {
				$base = dirname($base);
			}

			if ($base === DS || $base === '.') {
				$base = '';
			}

			$base = implode('/', array_map('rawurlencode', explode('/', $base)));
			$this->webroot = $base . '/';

			return $this->base = $base;
			
			if (!empty($base) || !$docRootContainsWebroot) {
				if (strpos($this->webroot, '/' . $dir . '/') === false) {
					$this->webroot .= $dir . '/';
				}
				if (strpos($this->webroot, '/' . $webroot . '/') === false) {
					$this->webroot .= $webroot . '/';
				}
			}
			die($base . $file);
			return $this->base = $base . $file;
		}

		public function isAjax() {
			return (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) AND strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
		}
	}
?>