<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik_Plugins
 * @package Piwik_ServerStats

/**
 * ExampleUI API is also an example API useful if you are developing a Piwik plugin.
 *
 * The functions listed in this API are returning the data used in the Controller to draw graphs and
 * display tables. See also the ExampleAPI plugin for an introduction to Piwik APIs.
 *
 * @package Piwik_ServerStats
 */
class Piwik_ServerStats_API
{
    static private $instance = null;

    static public function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    function getTypeEtab($idSite, $date, $period)
    {
        $period = Piwik_Period_Range::advancedFactory($period, $date);
     
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/


        $queryTypes = "SELECT DISTINCT(custom_var_v8) FROM piwik_log_visit 
                       WHERE idsite= ? AND visit_first_action_time > ? AND visit_last_action_time < ?";
        $types = Piwik_FetchAll($queryTypes, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59"));

        $hits = new Piwik_DataTable(); 
        foreach($types as $atypes)
        {
            $type = $atypes['custom_var_v8'];
            $queryHits = "SELECT COUNT(DISTINCT(custom_var_v1)) as nb_etabs FROM piwik_log_visit 
                          WHERE idsite= ? AND visit_first_action_time > ? AND visit_last_action_time < ? AND custom_var_v8= ?";
            $thits = Piwik_FetchAll($queryHits, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $type));

            $h1 = new Piwik_DataTable_Row(array(Piwik_DataTable_Row::COLUMNS => array('label'=>$type, 'nb_etabs'=>$thits[0]['nb_etabs']),));
            $hits->addRow($h1);
        }

        return $hits;
    }
}