/*
 *  Kartograph - a svg mapping library
 *  Copyright (C) 2011-2013  Gregor Aisch
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
*/
(function(){function bS(){function h(a,b,c){f(a.point,b)<f(c.point,b)&&(c=a),a.left&&(c=h(a.left,b,c));if(a.right){var d=a.point[a.axis]-b[a.axis];d*d<f(c.point,b)&&(c=h(a.right,b,c))}return c}function g(a){return function(b,c){b=b[a],c=c[a];return b<c?-1:b>c?1:0}}function f(a,c){var d=0;for(var e=0;e<b.length;e++){var f=b[e],g=a[f]-c[f];d+=g*g}return d}function e(a,c){if(!!a.length){var d=b[c%b.length],f=a.length>>1;a.sort(g(d));return{axis:d,point:a[f],left:e(a.slice(0,f),c+1),right:e(a.slice(f+1),c+1)}}}var a={},b=["x","y"],c,d=[];a.axes=function(c){if(!arguments.length)return b;b=c;return a},a.points=function(b){if(!arguments.length)return d;d=b,c=null;return a},a.find=function(b){return h(a.root(),b,c).point},a.root=function(a){return c||(c=e(d,0))};return a}function bR(){var a={},b=[],c=1,d=1;a.size=function(b){if(!arguments.length)return d;d=b;return a},a.iterations=function(b){if(!arguments.length)return c;c=b;return a},a.add=function(c){b.push(c);return a},a.means=function(){var a=[],e={},f=Math.min(d,b.length);for(var g=0,h=2*f;g<h;g++){var i=b[~~(Math.random()*b.length)],j=i.x+"/"+i.y;if(!(j in e)){e[j]=1;if(a.push({x:i.x,y:i.y})>=f)break}}f=a.length;for(var k=0;k<c;k++){var l=bS().points(a);for(var g=0;g<f;g++){var m=a[g];m.sumX=0,m.sumY=0,m.size=0,m.points=[],m.indices=[]}for(var g=0;g<b.length;g++){var n=b[g],m=l.find(n);m.sumX+=n.x,m.sumY+=n.y,m.size++,m.points.push(n),m.indices.push(g)}for(var g=0;g<f;g++){var m=a[g];if(!m.size)continue;m.x=m.sumX/m.size,m.y=m.sumY/m.size}}return a};return a}var a,b,c,d,e,f,g,h,i,j,k,l,n,o,p,q,r,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,_,ba,bb,bc,bd,be,bf,bg,bh,bi,bj,bk,bl,bm,bn,bo,bp,bq,br,bs,bt,bu,bv,bw,bx,by,bz,bA,bB,bC,bD,bE,bF,bG,bH,bI,bJ,bK,bL,bM,bN={}.hasOwnProperty,bO=function(a,b){function d(){this.constructor=a}for(var c in b)bN.call(b,c)&&(a[c]=b[c]);d.prototype=b.prototype,a.prototype=new d,a.__super__=b.prototype;return a},bP=function(a,b){return function(){return a.apply(b,arguments)}},bQ=[].indexOf||function(a){for(var b=0,c=this.length;b<c;b++)if(b in this&&this[b]===a)return b;return-1};bz=typeof exports!="undefined"&&exports!==null?exports:this,br=bz.$K=window.Kartograph=(bH=bz.Kartograph)!=null?bH:bz.Kartograph={},br.version="0.5.2",a=bz.jQuery,br.__verbose=!1,bB=function(a){try{return console.warn.apply(console,arguments)}catch(b){try{return opera.postError.apply(opera,arguments)}catch(b){return alert(Array.prototype.join.call(arguments," "))}}},bs=function(a){if(br.__verbose)try{return console.debug.apply(console,arguments)}catch(b){try{return opera.postError.apply(opera,arguments)}catch(b){return alert(Array.prototype.join.call(arguments," "))}}},(bI=(bF=String.prototype).trim)==null&&(bF.trim=function(){return this.replace(/^\s+|\s+$/g,"")}),Array.prototype.indexOf||(Array.prototype.indexOf=function(a){"use strict";if(this==null)throw new TypeError;var b=Object(this),c=b.length>>>0;if(c===0)return-1;var d=0;arguments.length>0&&(d=Number(arguments[1]),d!=d?d=0:d!=0&&d!=Infinity&&d!=-Infinity&&(d=(d>0||-1)*Math.floor(Math.abs(d))));if(d>=c)return-1;var e=d>=0?d:Math.max(c-Math.abs(d),0);for(;e<c;e++)if(e in b&&b[e]===a)return e;return-1}),bE=function(){var a,b,c,d,e;a={},e="Boolean Number String Function Array Date RegExp Undefined Null".split(" ");for(c=0,d=e.length;c<d;c++)b=e[c],a["[object "+b+"]"]=b.toLowerCase();return function(b){var c;c=Object.prototype.toString.call(b);return a[c]||"object"}}(),d=function(){function a(a,b,c,d){var e;a==null&&(a=0),b==null&&(b=0),c==null&&(c=null),d==null&&(d=null),e=this,c===null?(e.xmin=Number.MAX_VALUE,e.xmax=Number.MAX_VALUE*-1):(e.xmin=e.left=a,e.xmax=e.right=a+c,e.width=c),d===null?(e.ymin=Number.MAX_VALUE,e.ymax=Number.MAX_VALUE*-1):(e.ymin=e.top=b,e.ymax=e.bottom=d+b,e.height=d);return}a.prototype.update=function(a,b){var c;b==null&&(b=a[1],a=a[0]),c=this,c.xmin=Math.min(c.xmin,a),c.ymin=Math.min(c.ymin,b),c.xmax=Math.max(c.xmax,a),c.ymax=Math.max(c.ymax,b),c.left=c.xmin,c.top=c.ymin,c.right=c.xmax,c.bottom=c.ymax,c.width=c.xmax-c.xmin,c.height=c.ymax-c.ymin;return this},a.prototype.intersects=function(a){return a.left<s.right&&a.right>s.left&&a.top<s.bottom&&a.bottom>s.top},a.prototype.inside=function(a,b){var c;c=this;return a>=c.left&&a<=c.right&&b>=c.top&&b<=c.bottom},a.prototype.join=function(a){var b;b=this,b.update(a.left,a.top),b.update(a.right,a.bottom);return this};return a}(),d.fromXML=function(a){var b,c,d,e;d=Number(a.getAttribute("x")),e=Number(a.getAttribute("y")),c=Number(a.getAttribute("w")),b=Number(a.getAttribute("h"));return new br.BBox(d,e,c,b)},br.BBox=d,(bJ=br.geom)==null&&(br.geom={}),(bK=(bG=br.geom).clipping)==null&&(bG.clipping={}),l=function(){function f(){}var a,b,c,d,e;b=0,c=1,d=2,a=4,e=8,f.prototype.compute_out_code=function(a,b,c){var d,e;e=this,d=e.INSIDE,b<a.left?d|=e.LEFT:b>a.right&&(d|=e.RIGHT),c<a.top?d|=e.TOP:c>a.bottom&&(d|=e.BOTTOM);return d},f.prototype.clip=function(a,b,c,d,e){var f,g,h,i,j,k,l;j=this,g=j.compute_out_code(a,b,c),h=j.compute_out_code(a,d,e),f=False;while(True){if(!(g|h)){f=True;break}if(g&h)break;i=code===0?h:g,i&j.TOP?(k=b+(d-b)*(a.top-c)/(e-c),l=a.top):i&j.BOTTOM?(k=b+(d-b)*(a.bottom-c)/(e-c),l=a.bottom):i&j.RIGHT?(l=c+(e-c)*(a.right-b)/(d-b),k=a.right):i&j.LEFT&&(l=c+(e-c)*(a.left-b)/(d-b),k=a.left),i===g?(b=k,c=l,g=j.compute_out_code(a,b,c)):(d=k,e=l,h=j.compute_out_code(a,d,e))}return f?[b,c,d,e]:null};return f}(),br.geom.clipping.CohenSutherland=l,B=function(){function b(b,c,d){var e,f;f=this,f.container=e=a(b),c==null&&(c=e.width()),d==null&&(d=e.height()),d===0&&(d="auto"),f.size={h:d,w:c},f.markers=[],f.pathById={},f.container.addClass("kartograph")}b.prototype.createSVGLayer=function(b){var c,d,e,f,g,h,i,j;f=this,(j=f._layerCnt)==null&&(f._layerCnt=0),e=f._layerCnt++,i=f.viewport,d=f.container,g=Raphael(d[0],i.width,i.height),h=a(g.canvas),h.css({position:"absolute",top:"0px",left:"0px","z-index":e+5}),d.css("position")==="static"&&d.css({position:"relative",height:i.height+"px"}),h.addClass(b),c=a("desc",g.canvas).text(),a("desc",g.canvas).text(c.replace("with ","with kartograph "+br.version+" and "));return g},b.prototype.createHTMLLayer=function(b){var c,d,e,f,g,h;f=this,g=f.viewport,c=f.container,(h=f._layerCnt)==null&&(f._layerCnt=0),e=f._layerCnt++,d=a('<div class="layer '+b+'" />'),d.css({position:"absolute",top:"0px",left:"0px",width:g.width+"px",height:g.height+"px","z-index":e+5}),c.append(d);return d},b.prototype.loadMap=function(b,c,d){var e,f,g,h;f=this,e=a.Deferred(),f.clear(),f.opts=d!=null?d:{},(h=(g=f.opts).zoom)==null&&(g.zoom=1),f.mapLoadCallback=c,f._loadMapDeferred=e,f._lastMapUrl=b,f.cacheMaps&&br.__mapCache[b]!=null?f._mapLoaded(br.__mapCache[b]):a.ajax({url:b,dataType:"text",success:f._mapLoaded,context:f,error:function(a,b,c){return bB(a,b,c)}});return e.promise()},b.prototype.setMap=function(a,b){var c,d,e;c=this,c.opts=b!=null?b:{},(e=(d=c.opts).zoom)==null&&(d.zoom=1),c._lastMapUrl="string",c._mapLoaded(a)},b.prototype._mapLoaded=function(b){var c,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;h=this,h.cacheMaps&&((o=br.__mapCache)==null&&(br.__mapCache={}),br.__mapCache[h._lastMapUrl]=b);try{b=a(b)}catch(t){bB("something went horribly wrong while parsing svg"),h._loadMapDeferred.reject("could not parse svg");return}h.svgSrc=b,c=a("view",b),bs("got svg src",h.svgSrc),h.paper==null&&(m=h.size.w,f=h.size.h,f==="auto"&&(j=c.attr("w")/c.attr("h"),f=m/j),h.viewport=new d(0,0,m,f)),l=h.viewport,bs("got viewport",h.viewport),h.viewAB=e=br.View.fromXML(c[0]),bs("got first view",h.viewAB),i=(p=h.opts.padding)!=null?p:0,g=(q=h.opts.halign)!=null?q:"center",k=(r=h.opts.valign)!=null?r:"center",bs("got alignment",g,k),n=(s=h.opts.zoom)!=null?s:1,h.viewBC=new br.View(h.viewAB.asBBox(),l.width*n,l.height*n,i,g,k),bs("got second view",h.viewBC),h.proj=br.Proj.fromXML(a("proj",c)[0]),bs("got projection",h.proj),h.mapLoadCallback!=null&&h.mapLoadCallback(h),h._loadMapDeferred!=null&&h._loadMapDeferred.resolve(h)},b.prototype.addLayer=function(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;c==null&&(c={}),i=this,(u=i.layerIds)==null&&(i.layerIds=[]),(v=i.layers)==null&&(i.layers={}),i.paper==null&&(i.paper=i.createSVGLayer()),l=b,bE(c)==="object"?(h=c.name,j=c.key,o=c.title):c={},h==null&&(h=l),m=a("#"+l,i.svgSrc);if(m.length!==0){g=new L(h,j,i,c.filter),d=a("*",m[0]);for(q=0,s=d.length;q<s;q++)n=d[q],g.addPath(n,o);g.paths.length>0&&(i.layers[h]=g,i.layerIds.push(h)),e=["click","mouseenter","mouseleave","dblclick","mousedown","mouseup","mouseover","mouseout"];for(r=0,t=e.length;r<t;r++)f=e[r],bE(c[f])==="function"&&g.on(f,c[f]);if(c.styles!=null){w=c.styles;for(k in w)p=w[k],g.style(k,p)}c.tooltips!=null&&g.tooltips(c.tooltips);return i}},b.prototype.getLayer=function(a){var b;b=this;if(b.layers[a]==null){bB("could not find layer "+a);return null}return b.layers[a]},b.prototype.getLayerPath=function(a,b){var c,d;d=this,c=d.getLayer(a);if(c!=null)return bE(b)==="object"?c.getPaths(b)[0]:c.getPath(b);return null},b.prototype.onLayerEvent=function(a,b,c){var d;d=this,d.getLayer(c).on(a,b);return d},b.prototype.addMarker=function(a){var b,c;b=this,b.markers.push(a),c=b.viewBC.project(b.viewAB.project(b.proj.project(a.lonlat.lon,a.lonlat.lat)));return a.render(c[0],c[1],b.container,b.paper)},b.prototype.clearMarkers=function(){var a,b,c,d,e;b=this,e=b.markers;for(c=0,d=e.length;c<d;c++)a=e[c],a.clear();return b.markers=[]},b.prototype.fadeIn=function(a){var b,c,d,e,f,g,h,i,j,k,l;a==null&&(a={}),f=this,e=(i=a.layer)!=null?i:f.layerIds[f.layerIds.length-1],c=(j=a.duration)!=null?j:500,k=f.layers[e].pathsById,l=[];for(d in k)h=k[d],l.push(function(){var a,d,e;e=[];for(a=0,d=h.length;a<d;a++)g=h[a],bE(c)==="function"?b=c(g.data):b=c,g.svgPath.attr("opacity",0),e.push(g.svgPath.animate({opacity:1},b));return e}());return l},b.prototype.loadCoastline=function(){var b;b=this;return a.ajax({url:"coastline.json",success:b.renderCoastline,context:b})},b.prototype.resize=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;g=this,c=g.container,a==null&&(a=c.width()),b==null&&(b=c.height()),g.viewport=k=new br.BBox(0,0,a,b),g.paper!=null&&g.paper.setSize(k.width,k.height),k=g.viewport,h=(o=g.opts.padding)!=null?o:0,d=(p=g.opts.halign)!=null?p:"center",j=(q=g.opts.valign)!=null?q:"center",l=g.opts.zoom,g.viewBC=new br.View(g.viewAB.asBBox(),k.width*l,k.height*l,h,d,j),r=g.layers;for(e in r)f=r[e],f.setView(g.viewBC);if(g.symbolGroups!=null){s=g.symbolGroups;for(m=0,n=s.length;m<n;m++)i=s[m],i.onResize()}},b.prototype.lonlat2xy=function(a){var b,c;c=this,a.length===2&&(a=new br.LonLat(a[0],a[1])),a.length===3&&(a=new br.LonLat(a[0],a[1],a[2])),b=c.proj.project(a.lon,a.lat,a.alt);return c.viewBC.project(c.viewAB.project(b))},b.prototype.showZoomControls=function(){var a;a=this,a.zc=new S(a);return a},b.prototype.addSymbolGroup=function(a){var b,c;b=this,(c=b.symbolGroups)==null&&(b.symbolGroups=[]);return b.symbolGroups.push(a)},b.prototype.removeSymbols=function(a){var b,c,d,e,f,g;b=this;if(a!=null)return b.symbolGroups[a].remove();f=b.symbolGroups,g=[];for(d=0,e=f.length;d<e;d++)c=f[d],g.push(c.remove());return g},b.prototype.clear=function(){var b,c,d,e,f,g;c=this;if(c.layers!=null){for(b in c.layers)c.layers[b].remove();c.layers={},c.layerIds=[]}if(c.symbolGroups!=null){g=c.symbolGroups;for(e=0,f=g.length;e<f;e++)d=g[e],d.remove();c.symbolGroups=[]}if(c.paper!=null){a(c.paper.canvas).remove();return c.paper=void 0}},b.prototype.loadCSS=function(b,c){var d;d=this;if(a.browser.msie)return a.ajax({url:b,dataType:"text",success:function(a){d.styles=br.parsecss(a);return c()},error:function(a,c,d){return bB("error while loading "+b,a,c,d)}});a("body").append('<link rel="stylesheet" href="'+b+'" />');return c()},b.prototype.applyCSS=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;e=this;if(e.styles==null)return a;(n=e._pathTypes)==null&&(e._pathTypes=["path","circle","rectangle","ellipse"]),(o=e._regardStyles)==null&&(e._regardStyles=["fill","stroke","fill-opacity","stroke-width","stroke-opacity"]);for(h in e.styles){f=h,p=f.split(",");for(j=0,l=p.length;j<l;j++){i=p[j],f=i.split(" "),f=f[f.length-1],f=f.split(":");if(f.length>1)continue;f=f[0].split("."),c=f.slice(1);if(c.length>0&&c.indexOf(b)<0)continue;f=f[0];if(e._pathTypes.indexOf(f)>=0&&f!==a.type)continue;g=e.styles[h],q=e._regardStyles;for(k=0,m=q.length;k<m;k++)d=q[k],g[d]!=null&&a.attr(d,g[d])}}return a},b.prototype.style=function(a,b,c,d,e){var f;f=this,a=f.getLayer(a);if(a!=null)return a.style(b,c,d,e)};return b}(),br.Kartograph=B,br.map=function(a,b,c){return new B(a,b,c)},br.__mapCache={},J=function(){function a(a,b,c){c==null&&(c=0),this.lon=Number(a),this.lat=Number(b),this.alt=Number(c)}a.prototype.distance=function(a){var b,c,d,e,f,g,h,i,j;j=this,b=6371,g=Math.PI/180,e=(a.lat-j.lat)*g,f=(a.lon-j.lon)*g,h=j.lat*g,i=a.lat*g,c=Math.sin(e/2)*Math.sin(e/2)+Math.sin(f/2)*Math.sin(f/2)*Math.cos(h)*Math.cos(i),d=2*Math.atan2(Math.sqrt(c),Math.sqrt(1-c));return b*d};return a}(),F=function(a){function b(a,c,d){d==null&&(d=0),b.__super__.constructor.call(this,c,a,d)}bO(b,a);return b}(J),br.LonLat=J,br.LatLon=F,L=function(){function b(a,b,c,d){var e;e=this,e.id=a,e.path_id=b,e.paper=c.paper,e.view=c.viewBC,e.map=c,e.filter=d}b.prototype.addPath=function(a,b){var c,d,e,f,g,h,i;d=this,(g=d.paths)==null&&(d.paths=[]),c=new M(a,d.id,d.map,b);if(bE(d.filter)==="function"&&d.filter(c.data)===!1)c.remove();else{d.paths.push(c);if(d.path_id!=null){(h=d.pathsById)==null&&(d.pathsById={}),(i=(e=d.pathsById)[f=c.data[d.path_id]])==null&&(e[f]=[]);return d.pathsById[c.data[d.path_id]].push(c)}}},b.prototype.hasPath=function(a){var b;b=this;return b.pathsById!=null&&b.pathsById[a]!=null},b.prototype.getPathsData=function(){var a,b,c,d,e,f;a=this,c=[],f=a.paths;for(d=0,e=f.length;d<e;d++)b=f[d],c.push(b.data);return c},b.prototype.getPath=function(a){var b;b=this;return b.hasPath(a)?b.pathsById[a][0]:null},b.prototype.getPaths=function(a){var b,c,d,e,f,g,h,i;e=this,d=[];if(bE(a)==="object"){i=e.paths;for(g=0,h=i.length;g<h;g++){f=i[g],c=!0;for(b in a)c=c&&f.data[b]===a[b];c&&d.push(f)}}return d},b.prototype.setView=function(a){var b,c,d,e,f;b=this,f=b.paths;for(d=0,e=f.length;d<e;d++)c=f[d],c.setView(a);return b},b.prototype.remove=function(){var a,b,c,d,e,f;a=this,e=a.paths,f=[];for(c=0,d=e.length;c<d;c++)b=e[c],f.push(b.remove());return f},b.prototype.style=function(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;j=this;if(bE(a)==="object"){for(i in a)l=a[i],j.style(i,l);return j}c==null&&(c=0),d==null&&(d=0),o=j.paths;for(m=0,n=o.length;m<n;m++)k=o[m],l=bx(b,k.data),h=bx(c,k.data),g=bx(d,k.data),h>0?(f={},f[a]=l,e=Raphael.animation(f,h*1e3),k.svgPath.animate(e.delay(g*1e3))):k.svgPath.attr(a,l);return j},b.prototype.on=function(b,c){var d,e,f,g,h,i,j;f=this,d=function(){function a(a,b,c){this.type=a,this.cb=b,this.layer=c,this.handle=bP(this.handle,this)}a.prototype.handle=function(a){var b;f=this,b=f.layer.map.pathById[a.target.getAttribute("id")];return f.cb(b.data,b.svgPath,a)};return a}(),e=new d(b,c,f),j=f.paths;for(h=0,i=j.length;h<i;h++)g=j[h],a(g.svgPath.node).bind(b,e.handle);return f},b.prototype.tooltips=function(b,c){var d,e,f,g,h,i,j;d=this,f=function(b,d){var e;e={position:{target:"mouse",viewport:a(window),adjust:{x:7,y:7}},show:{delay:c!=null?c:20},events:{show:function(b,c){return a(".qtip").filter(function(){return this!==c.elements.tooltip.get(0)}).hide()}},content:{}},d!=null?typeof d=="string"?e.content.text=d:a.isArray(d)&&(e.content.title=d[0],e.content.text=d[1]):e.content.text="n/a";return a(b.svgPath.node).qtip(e)},j=d.paths;for(h=0,i=j.length;h<i;h++)e=j[h],g=bx(b,e.data),f(e,g);return d},b.prototype.sort=function(a){var b,c,d,e,f,g;c=this,c.paths.sort(function(b,c){var d,e,f;d=a(b.data),e=a(c.data);return d===e?0:(f=d>e)!=null?f:{1:-1}}),b=!1,g=c.paths;for(e=0,f=g.length;e<f;e++)d=g[e],b&&d.svgPath.insertAfter(b.svgPath),b=d;return c};return b}(),bx=function(a,b){return bE(a)==="function"?a(b):a},bt=0,M=function(){function a(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q;h=this,i=c.paper,n=c.viewBC,h.path=j=br.geom.Path.fromSVG(a),h.vpath=n.projectPath(j),h.svgPath=h.vpath.toSVG(i),c.styles==null?h.svgPath.node.setAttribute("class",b):c.applyCSS(h.svgPath,b),l="path_"+bt++,h.svgPath.node.setAttribute("id",l),c.pathById[l]=h,f={};for(g=p=0,q=a.attributes.length-1;0<=q?p<=q:p>=q;g=0<=q?++p:--p)e=a.attributes[g],e.name.substr(0,5)==="data-"&&(m=e.value,o=Number(m),m.trim()!==""&&o===m&&!isNaN(o)&&(m=o),f[e.name.substr(5)]=m);h.data=f,bE(d)==="string"?k=d:bE(d)==="function"&&(k=d(f)),k!=null&&h.svgPath.attr("title",k)}a.prototype.setView=function(a){var b,c,d;b=this,c=a.projectPath(b.path),b.vpath=c;if(b.path.type==="path"){d=c.svgString();return b.svgPath.attr({path:d})}if(b.path.type==="circle")return b.svgPath.attr({cx:c.x,cy:c.y,r:c.r})},a.prototype.remove=function(){var a;a=this;return a.svgPath.remove()};return a}(),br.parsecss=function(a,b){var c,d,e,f,g,h,i,j;f={},a=bu(a),j=a.split("`b%");for(h=0,i=j.length;h<i;h++){c=j[h],c=c.split("%b`");if(c.length<2)continue;c[0]=by(c[0]),e=bw(c[1]);if(f[c[0]]!=null)for(d in e)g=e[d],f[c[0]][d]=g;else f[c[0]]=e}if(bE(b)==="function")b(f);else return f},bv={},bw=function(a){var b,c,d,e,f,g;d=bv[a].replace(/^{|}$/g,""),d=bu(d),c={},g=d.split(";");for(e=0,f=g.length;e<f;e++){b=g[e],b=b.split(":");if(b.length<2)continue;c[by(b[0])]=by(b.slice(1).join(":"))}return c},Z=/{[^{}]*}/,_=/\[[^\[\]]*\]|{[^{}]*}|\([^()]*\)|function(\s+\w+)?(\s*%b`\d+`b%){2}/,$=/(?:\/\*(?:[^\*]|\*[^\/])*\*\/)|(\\.|"(?:[^\\\"]|\\.|\\\n)*"|'(?:[^\\\']|\\.|\\\n)*')/g,ba=/%\w`(\d+)`\w%/,bA=0,bu=function(a,b){var c,d,e;a=a.replace($,function(a,b){var c;if(!b)return"";c="%s`"+ ++bA+"`s%",bv[bA]=b.replace(/^\\/,"");return c}),c=b?_:Z;while(d=c.exec(a))e="%b`"+ ++bA+"`b%",bv[bA]=d[0],a=a.replace(c,e);return a},by=function(a){var b;if(a==null)return a;while(b=ba.exec(a))a=a.replace(ba,bv[b[1]]);return a.trim()},(bL=br.geom)==null&&(br.geom={}),T=function(){function a(a,b,c){var d;c==null&&(c=!0),d=this,d.type=a,d.contours=b,d.closed=c}a.prototype.clipToBBox=function(a){throw"path clipping is not implemented yet"},a.prototype.toSVG=function(a){var b;b=this.svgString();return a.path(b)},a.prototype.svgString=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m;d=this,e="",c=d.closed?"Z M":"M",l=d.contours;for(h=0,j=l.length;h<j;h++){a=l[h],b=!0,e+=e===""?"M":c;for(i=0,k=a.length;i<k;i++)m=a[i],f=m[0],g=m[1],b||(e+="L"),e+=f+","+g,b=!1}d.closed&&(e+="Z");return e},a.prototype.area=function(){var a,b,c,d,e,f,g,h,i;d=this;if(d.areas!=null)return d._area;d.areas=[],d._area=0,h=d.contours;for(e=0,g=h.length;e<g;e++){b=h[e],a=0;for(c=f=0,i=b.length-2;0<=i?f<=i:f>=i;c=0<=i?++f:--f)a+=b[c][0]*b[c+1][1]-b[c+1][0]*b[c][1];a*=.5,a=a,d.areas.push(a),d._area+=a}return d._area},a.prototype.centroid=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K;p=this;if(p._centroid!=null)return p._centroid;c=p.area(),f=g=0;for(k=A=0,G=p.contours.length-1;0<=G?A<=G:A>=G;k=0<=G?++A:--A){e=p.contours[k],d=[],n=e.length;for(l=B=0,H=n-1;0<=H?B<=H:B>=H;l=0<=H?++B:--B){q=e[l],r=e[(l+1)%n],h=0,d.push(q),q[0]===r[0]&&(h=Math.abs(q[1]-r[1])),q[1]===r[1]&&(h=Math.abs(q[0]-r[0]));if(h>10){a=Math.floor(h*2);for(s=C=1,I=a-1;1<=I?C<=I:C>=I;s=1<=I?++C:--C)t=[q[0]+s/a*(r[0]-q[0]),q[1]+s/a*(r[1]-q[1])],d.push(t)}}b=p.areas[k],w=y=x=z=0,n=d.length,E=[],u=0;for(l=D=0,J=n-1;0<=J?D<=J:D>=J;l=0<=J?++D:--D)q=d[l],r=d[(l+1)%n],i=r[0]-q[0],j=r[1]-q[1],o=Math.sqrt(i*i+j*j),E.push(o),u+=o;for(l=F=0,K=n-1;0<=K?F<=K:F>=K;l=0<=K?++F:--F)q=d[l],v=E[l]/u,w+=v*q[0],y+=v*q[1];m=b/c,f+=w*m,g+=y*m}p._centroid=[f,g];return p._centroid},a.prototype.isInside=function(a,b){var c,d,e,f,g,h;f=this,c=f._bbox;if(a<c[0]||a>c[2]||b<c[1]||b>c[3])return!1;for(e=g=0,h=f.contours.length-1;0<=h?g<=h:g>=h;e=0<=h?++g:--g){d=f.contours[e];if(bC(d,[a,b]))return!0}return!1};return a}(),br.geom.Path=T,k=function(a){function b(a,c,d){this.x=a,this.y=c,this.r=d,b.__super__.constructor.call(this,"circle",null,!0)}bO(b,a),b.prototype.toSVG=function(a){var b;b=this;return a.circle(b.x,b.y,b.r)},b.prototype.centroid=function(){var a;a=this;return[a.x,a.y]},b.prototype.area=function(){var a;a=this;return Math.PI*a.r*m.r};return b}(T),br.geom.Circle=k,T.fromSVG=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;e=[],m=a.nodeName,k=null;if(m==="path"){i=a.getAttribute("d").trim(),h=Raphael.parsePathString(i),b=h[h.length-1]==="Z",l=b?"Z M":"M",d=[];for(n=0,o=h.length;n<o;n++){c=h[n];if(c.length===0)continue;c[0]==="M"?(d.length>2&&(e.push(d),d=[]),d.push([c[1],c[2]])):c[0]==="L"?d.push([c[1],c[2]]):c[0]==="Z"&&d.length>2&&(e.push(d),d=[])}d.length>2&&(e.push(d),d=[]),k=new br.geom.Path(m,e,b)}else m==="circle"&&(f=a.getAttribute("cx"),g=a.getAttribute("cy"),j=a.getAttribute("r"),k=new br.geom.Circle(f,g,j));return k},G=function(){function a(a){this.points=a}a.prototype.clipToBBox=function(b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;l=this,c=(new br.geom.clipping.CohenSutherland).clip,k=[],f=[],e=!1;for(d=q=0,r=l.points.length-2;0<=r?q<=r:q>=r;d=0<=r?++q:--q){s=l.points[d],g=s[0],h=s[1],t=l.points[d+1],i=t[0],j=t[1];try{u=c(b,g,h,i,j),m=u[0],o=u[1],n=u[2],p=u[3],e=!0,k.push([m,o]),(i!==n||j!==o||d===len(l.points)-2)&&k.push([n,p])}catch(v){e&&k.length>1&&(f.push(new a(k)),k=[]),e=!1}}k.length>1&&f.push(new a(k));return f},a.prototype.toSVG=function(){var a,b,c,d,e,f,g,h;b=this,a=[],g=b.points;for(e=0,f=g.length;e<f;e++)h=g[e],c=h[0],d=h[1],a.push(c+","+d);return"M"+a.join("L")};return a}(),br.geom.Line=G,bC=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;h=Math.PI,d=Math.atan2,k=h*2,g=a.length,c=0;for(f=p=0,q=g-1;0<=q?p<=q:p>=q;f=0<=q?++p:--p){l=a[f][0]-b[0],n=a[f][1]-b[1],m=a[(f+1)%g][0]-b[0],o=a[(f+1)%g][1]-b[1],i=d(n,l),j=d(o,m),e=j-i;while(e>h)e-=k;while(e<-h)e+=k;c+=e}return Math.abs(c)>=h},bD=br.proj={},Function.prototype.bind=function(a){var b;b=this;return function(){return b.apply(a,arguments)}},V=function(){function a(a){var b,c,d;b=this,b.lon0=(c=a.lon0)!=null?c:0,b.lat0=(d=a.lat0)!=null?d:0,b.PI=Math.PI,b.HALFPI=b.PI*.5,b.QUARTERPI=b.PI*.25,b.RAD=b.PI/180,b.DEG=180/b.PI,b.lam0=b.rad(this.lon0),b.phi0=b.rad(this.lat0),b.minLat=-90,b.maxLat=90}a.parameters=[],a.title="Projection",a.prototype.rad=function(a){return a*this.RAD},a.prototype.deg=function(a){return a*this.DEG},a.prototype.plot=function(a,b){var c,d,e,f,g,h,i,j,k,l,m;b==null&&(b=!0),f=[],c=!0;for(j=0,k=a.length;j<k;j++)l=a[j],e=l[0],d=l[1],g=this._visible(e,d),g&&(c=!1),m=this.project(e,d),h=m[0],i=m[1],!g&&b?f.push(this._truncate(h,i)):f.push([h,i]);return c?null:[f]},a.prototype.sea=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n;f=this,e=f.project.bind(this),d=[],a=f.lon0,f.lon0=0;for(c=g=-180;g<=180;c=++g)d.push(e(c,f.maxLat));for(b=h=k=f.maxLat,l=f.minLat;k<=l?h<=l:h>=l;b=k<=l?++h:--h)d.push(e(180,b));for(c=i=180;i>=-180;c=--i)d.push(e(c,f.minLat));for(b=j=m=f.minLat,n=f.maxLat;m<=n?j<=n:j>=n;b=m<=n?++j:--j)d.push(e(-180,b));f.lon0=a;return d},a.prototype.world_bbox=function(){var a,b,c,d,e,f;b=this.project.bind(this),d=this.sea(),a=new br.BBox;for(e=0,f=d.length;e<f;e++)c=d[e],a.update(c[0],c[1]);return a},a.prototype.toString=function(){var a;a=this;return"[Proj: "+a.name+"]"};return a}(),V.fromXML=function(a){var b,c,d,e,f,g,h;d=a.getAttribute("id"),e={};for(c=g=0,h=a.attributes.length-1;0<=h?g<=h:g>=h;c=0<=h?++g:--g)b=a.attributes[c],b.name!=="id"&&(e[b.name]=b.value);f=new br.proj[d](e),f.name=d;return f},br.Proj=V,o=function(a){function b(a){var c,d,e;a==null&&(a={}),c=this,c.flip=Number((d=a.flip)!=null?d:0),c.flip===1&&(a.lon0=(e=-a.lon0)!=null?e:0),b.__super__.constructor.call(this,a)}bO(b,a),b.parameters=["lon0","flip"],b.title="Cylindrical Projection",b.prototype._visible=function(a,b){return!0},b.prototype.clon=function(a){a-=this.lon0,a<-180?a+=360:a>180&&(a-=360);return a},b.prototype.ll=function(a,b){return this.flip===1?[-a,-b]:[a,b]};return b}(V),r=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Equirectangular Projection",b.prototype.project=function(a,b){var c;c=this.ll(a,b),a=c[0],b=c[1],a=this.clon(a);return[a*Math.cos(this.phi0)*1e3,b*-1*1e3]};return b}(o),bD.lonlat=r,i=function(a){function b(a){var c;b.__super__.constructor.call(this,a),this.lat1=(c=a.lat1)!=null?c:0,this.phi1=this.rad(this.lat1)}bO(b,a),b.parameters=["lon0","lat1","flip"],b.title="Cylindrical Equal Area",b.prototype.project=function(a,b){var c,d,e,f,g;g=this.ll(a,b),a=g[0],b=g[1],c=this.rad(this.clon(a)),d=this.rad(b*-1),e=c*Math.cos(this.phi1),f=Math.sin(d)/Math.cos(this.phi1);return[e*1e3,f*1e3]};return b}(o),bD.cea=i,u=function(a){function b(a){a.lat1=45,b.__super__.constructor.call(this,a)}bO(b,a),b.title="Gall-Peters Projection",b.parameters=["lon0","flip"];return b}(i),bD.gallpeters=u,y=function(a){function b(a){a.lat1=37.7,b.__super__.constructor.call(this,a)}bO(b,a),b.title="Hobo-Dyer Projection",b.parameters=["lon0","flip"];return b}(i),bD.hobodyer=y,f=function(a){function b(a){a.lat1=30,b.__super__.constructor.call(this,a)}bO(b,a),b.title="Behrmann Projection",b.parameters=["lon0","flip"];return b}(i),bD.behrmann=f,e=function(a){function b(a){a.lat1=50,b.__super__.constructor.call(this,a)}bO(b,a),b.title="Balthasart Projection",b.parameters=["lon0","flip"];return b}(i),bD.balthasart=e,N=function(a){function b(a){b.__super__.constructor.call(this,a),this.minLat=-85,this.maxLat=85}bO(b,a),b.title="Mercator Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i;f=this,i=f.ll(a,b),a=i[0],b=i[1],d=Math,c=f.rad(f.clon(a)),e=f.rad(b*-1),g=c*1e3,h=d.log((1+d.sin(e))/d.cos(e))*1e3;return[g,h]};return b}(o),bD.mercator=N,X=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Pseudo-Cylindrical Projection";return b}(o),P=function(a){function b(a){var c;b.__super__.constructor.call(this,a),c=this,c.A0=.8707,c.A1=-0.131979,c.A2=-0.013791,c.A3=.003971,c.A4=-0.001529,c.B0=1.007226,c.B1=.015085,c.B2=-0.044475,c.B3=.028874,c.B4=-0.005916,c.C0=c.B0,c.C1=3*c.B1,c.C2=7*c.B2,c.C3=9*c.B3,c.C4=11*c.B4,c.EPS=1e-11,c.MAX_Y=.8707*.52*Math.PI;return}bO(b,a),b.title="Natural Earth Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j;g=this,j=g.ll(a,b),a=j[0],b=j[1],c=g.rad(g.clon(a)),d=g.rad(b*-1),e=d*d,f=e*e,h=c*(g.A0+e*(g.A1+e*(g.A2+f*e*(g.A3+e*g.A4))))*180+500,i=d*(g.B0+e*(g.B1+f*(g.B2+g.B3*e+g.B4*f)))*180+270;return[h,i]};return b}(X),bD.naturalearth=P,bb=function(a){function b(a){var c;b.__super__.constructor.call(this,a),c=this,c.X=[1,-5.67239e-12,-0.0000715511,311028e-11,.9986,-0.000482241,-0.000024897,-0.00000133094,.9954,-0.000831031,-0.000044861,-9.86588e-7,.99,-0.00135363,-0.0000596598,367749e-11,.9822,-0.00167442,-0.0000044975,-0.00000572394,.973,-0.00214869,-0.0000903565,1.88767e-8,.96,-0.00305084,-0.0000900732,164869e-11,.9427,-0.00382792,-0.0000653428,-0.00000261493,.9216,-0.00467747,-0.000104566,48122e-10,.8962,-0.00536222,-0.0000323834,-0.00000543445,.8679,-0.00609364,-0.0001139,332521e-11,.835,-0.00698325,-0.0000640219,9.34582e-7,.7986,-0.00755337,-0.0000500038,9.35532e-7,.7597,-0.00798325,-0.0000359716,-0.00000227604,.7186,-0.00851366,-0.000070112,-0.00000863072,.6732,-0.00986209,-0.000199572,191978e-10,.6213,-0.010418,883948e-10,624031e-11,.5722,-0.00906601,181999e-9,624033e-11,.5322,0,0,0],c.Y=[0,.0124,3.72529e-10,1.15484e-9,.062,.0124001,1.76951e-8,-5.92321e-9,.124,.0123998,-7.09668e-8,2.25753e-8,.186,.0124008,2.66917e-7,-8.44523e-8,.248,.0123971,-9.99682e-7,3.15569e-7,.31,.0124108,373349e-11,-0.0000011779,.372,.0123598,-0.000013935,439588e-11,.434,.0125501,520034e-10,-0.0000100051,.4968,.0123198,-0.0000980735,922397e-11,.5571,.0120308,402857e-10,-0.0000052901,.6176,.0120369,-0.0000390662,7.36117e-7,.6769,.0117015,-0.0000280246,-8.54283e-7,.7346,.0113572,-0.0000408389,-5.18524e-7,.7903,.0109099,-0.0000486169,-0.0000010718,.8435,.0103433,-0.0000646934,5.36384e-9,.8936,.00969679,-0.0000646129,-0.00000854894,.9394,.00840949,-0.000192847,-0.00000421023,.9761,.00616525,-0.000256001,-0.00000421021,1,0,0,0],c.NODES=18,c.FXC=.8487,c.FYC=1.3523,c.C1=11.459155902616464,c.RC1=.08726646259971647,c.ONEEPS=1.000001,c.EPS=1e-8;return}bO(b,a),b.title="Robinson Projection",b.prototype._poly=function(a,b,c){return a[b]+c*(a[b+1]+c*(a[b+2]+c*a[b+3]))},b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j;g=this,j=g.ll(a,b),a=j[0],b=j[1],a=g.clon(a),d=g.rad(a),e=g.rad(b*-1),f=Math.abs(e),c=Math.floor(f*g.C1),c>=g.NODES&&(c=g.NODES-1),f=g.deg(f-g.RC1*c),c*=4,h=1e3*g._poly(g.X,c,f)*g.FXC*d,i=1e3*g._poly(g.Y,c,f)*g.FYC,e<0&&(i=-i);return[h,i]};return b}(X),bD.robinson=bb,p=function(a){function b(a){var c;b.__super__.constructor.call(this,a),c=this,c.C_x=.4222382003157712,c.C_y=1.3265004281770023,c.RC_y=.7538633073600218,c.C_p=3.5707963267948966,c.RC_p=.2800495767557787,c.EPS=1e-7,c.NITER=6}bO(b,a),b.title="Eckert IV Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l,m;h=this,m=h.ll(a,b),a=m[0],b=m[1],f=h.rad(h.clon(a)),g=h.rad(b*-1),i=h.C_p*Math.sin(g),c=g*g,g*=.895168+c*(.0218849+c*.00826809),e=h.NITER;while(e>0){d=Math.cos(g),j=Math.sin(g),c=(g+j*(d+2)-i)/(1+d*(d+2)-j*j),g-=c;if(Math.abs(c)<h.EPS)break;e-=1}e===0?(k=h.C_x*f,l=g<0?-h.C_y:h.C_y):(k=h.C_x*f*(1+Math.cos(g)),l=h.C_y*Math.sin(g));return[k,l]};return b}(X),bD.eckert4=p,be=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Sinusoidal Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h;d=this,h=d.ll(a,b),a=h[0],b=h[1],c=d.rad(d.clon(a)),e=d.rad(b*-1),f=1032*c*Math.cos(e),g=1032*e;return[f,g]};return b}(X),bD.sinusoidal=be,O=function(a){function b(a,c,d,e,f){var g,h,i,j;c==null&&(c=1.5707963267948966),d==null&&(d=null),e==null&&(e=null),f==null&&(f=null),b.__super__.constructor.call(this,a),g=this,g.MAX_ITER=10,g.TOLERANCE=1e-7,c!=null?(h=c+c,j=Math.sin(c),i=Math.sqrt(Math.PI*2*j/(h+Math.sin(h))),g.cx=2*i/Math.PI,g.cy=i/j,g.cp=h+Math.sin(h)):d!=null&&e!=null&&typeof cz!="undefined"&&cz!==null?(g.cx=d,g.cy=e,g.cp=f):bB("kartograph.proj.Mollweide: either p or cx,cy,cp must be defined")}bO(b,a),b.title="Mollweide Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l,m;h=this,m=h.ll(a,b),a=m[0],b=m[1],g=Math,c=g.abs,f=h.rad(h.clon(a)),i=h.rad(b),e=h.cp*g.sin(i),d=h.MAX_ITER;while(d!==0){j=(i+g.sin(i)-e)/(1+g.cos(i)),i-=j;if(c(j)<h.TOLERANCE)break;d-=1}d===0?i=i>=0?h.HALFPI:-h.HALFPI:i*=.5,k=1e3*h.cx*f*g.cos(i),l=1e3*h.cy*g.sin(i);return[k,l*-1]};return b}(X),bD.mollweide=O,bm=function(a){function b(a){b.__super__.constructor.call(this,a,1.0471975511965976)}bO(b,a),b.title="Wagner IV Projection";return b}(O),bD.wagner4=bm,bn=function(a){function b(a){b.__super__.constructor.call(this,a,null,.90977,1.65014,3.00896)}bO(b,a),b.title="Wagner V Projection";return b}(O),bD.wagner5=bn,K=function(a){function d(){return d.__super__.constructor.apply(this,arguments)}var b,c;bO(d,a),c=-89,b=89,d.parameters=["lon0","lat0","flip"],d.title="Loximuthal Projection (equidistant)",d.prototype.project=function(a,b){var c,d,e,f,g,h,i;e=this,i=e.ll(a,b),a=i[0],b=i[1],d=Math,c=e.rad(e.clon(a)),f=e.rad(b),f===e.phi0?g=c*d.cos(e.phi0):g=c*(f-e.phi0)/(d.log(d.tan(e.QUARTERPI+f*.5))-d.log(d.tan(e.QUARTERPI+e.phi0*.5))),g*=1e3,h=1e3*(f-e.phi0);return[g,h*-1]};return d}(X),bD.loximuthal=K,j=function(a){function g(){return g.__super__.constructor.apply(this,arguments)}var b,c,d,e,f;bO(g,a),g.title="Canters Modified Sinusoidal I",g.parameters=["lon0"],b=1.1966,c=-0.129,d=3*c,e=-0.0076,f=5*e,g.prototype.project=function(a,g){var h,i,j,k,l,m;h=this,m=h.ll(a,g),a=m[0],g=m[1],a=h.rad(h.clon(a)),g=h.rad(g),k=g*g,l=k*k,i=1e3*a*Math.cos(g)/(b+d*k+f*l),j=1e3*g*(b+c*k+e*l);return[i,j*-1]};return g}(X),bD.canters1=j,x=function(a){function o(a){o.__super__.constructor.call(this,a)}var b,c,d,e,f,g,h,i,j,k,l,m,n;bO(o,a),o.title="Hatano Projection",h=20,d=1e-7,i=1.000001,b=2.67595,c=2.43763,j=.3736990601468637,k=.4102345310814193,f=1.75859,g=1.93052,m=.5686373742600607,n=.5179951515653813,e=.85,l=1.1764705882352942,o.prototype.project=function(a,i){var j,k,l,m,n,
o,p,q,r,s;m=this,s=m.ll(a,i),a=s[0],i=s[1],l=m.rad(m.clon(a)),n=m.rad(i),j=Math.sin(n)*(n<0?c:b);for(k=r=h;r>=1;k=r+=-1){o=(n+Math.sin(n)-j)/(1+Math.cos(n)),n-=o;if(Math.abs(o)<d)break}p=1e3*e*l*Math.cos(n*=.5),q=1e3*Math.sin(n)*(n<0?g:f);return[p,q*-1]};return o}(X),bD.hatano=x,w=function(a){function b(a){var c;b.__super__.constructor.call(this,a),c=this,c.lat1=41.737,c.p1=new O,c.p0=new be}bO(b,a),b.title="Goode Homolosine Projection",b.parameters=["lon0"],b.prototype.project=function(a,b){var c,d;c=this,d=c.ll(a,b),a=d[0],b=d[1],a=c.clon(a);return Math.abs(b)>c.lat1?c.p1.project(a,b):c.p0.project(a,b)};return b}(X),bD.goodehomolosine=w,Q=function(a){function c(a){c.__super__.constructor.call(this,a),this.r=this.HALFPI*100}var b;bO(c,a),c.title="Nicolosi Globular Projection",c.parameters=["lon0"],b=1e-10,c.prototype._visible=function(a,b){var c;c=this,a=c.clon(a);return a>-90&&a<90},c.prototype.project=function(a,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;h=this,p=h.ll(a,c),a=p[0],c=p[1],f=h.rad(h.clon(a)),j=h.rad(c),Math.abs(f)<b?(n=0,o=j):Math.abs(j)<b?(n=f,o=0):Math.abs(Math.abs(f)-h.HALFPI)<b?(n=f*Math.cos(j),o=h.HALFPI*Math.sin(j)):Math.abs(Math.abs(j)-h.HALFPI)<b?(n=0,o=j):(m=h.HALFPI/f-f/h.HALFPI,d=j/h.HALFPI,l=Math.sin(j),e=(1-d*d)/(l-d),k=m/e,k*=k,g=(m*l/e-.5*m)/(1+k),i=(l/k+.5*e)/(1+1/k),n=Math.cos(j),n=Math.sqrt(g*g+n*n/(1+k)),n=h.HALFPI*(g+(f<0?-n:n)),o=Math.sqrt(i*i-(l*l/k+e*l-1)/(1+1/k)),o=h.HALFPI*(i+(j<0?o:-o)));return[n*100,o*-100]},c.prototype.sea=function(){var a,b,c,d,e;b=[],d=this.r,a=Math;for(c=e=0;e<=360;c=++e)b.push([a.cos(this.rad(c))*d,a.sin(this.rad(c))*d]);return b},c.prototype.world_bbox=function(){var a;a=this.r;return new br.BBox(-a,-a,a*2,a*2)};return c}(X),bD.nicolosi=Q,c=function(a){function b(a,c){var d;c==null&&(c=1e3),b.__super__.constructor.call(this,a),d=this,d.r=c,d.elevation0=d.to_elevation(d.lat0),d.azimuth0=d.to_azimuth(d.lon0)}bO(b,a),b.parameters=["lon0","lat0"],b.title="Azimuthal Projection",b.prototype.to_elevation=function(a){var b;b=this;return(a+90)/180*b.PI-b.HALFPI},b.prototype.to_azimuth=function(a){var b;b=this;return(a+180)/360*b.PI*2-b.PI},b.prototype._visible=function(a,b){var c,d,e,f,g;g=this,f=Math,e=g.to_elevation(b),c=g.to_azimuth(a),d=f.sin(e)*f.sin(g.elevation0)+f.cos(g.elevation0)*f.cos(e)*f.cos(c-g.azimuth0);return d>=0},b.prototype._truncate=function(a,b){var c,d,e,f,g;c=Math,d=this.r,e=c.atan2(b-d,a-d),f=d+d*c.cos(e),g=d+d*c.sin(e);return[f,g]},b.prototype.sea=function(){var a,b,c,d,e;b=[],d=this.r,a=Math;for(c=e=0;e<=360;c=++e)b.push([d+a.cos(this.rad(c))*d,d+a.sin(this.rad(c))*d]);return b},b.prototype.world_bbox=function(){var a;a=this.r;return new br.BBox(0,0,a*2,a*2)};return b}(V),R=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Orthographic Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j;f=this,e=Math,d=f.to_elevation(b),c=f.to_azimuth(a),h=f.r*e.cos(d)*e.sin(c-f.azimuth0),j=-f.r*(e.cos(f.elevation0)*e.sin(d)-e.sin(f.elevation0)*e.cos(d)*e.cos(c-f.azimuth0)),g=f.r+h,i=f.r+j;return[g,i]};return b}(c),bD.ortho=R,C=function(a){function b(a){b.__super__.constructor.call(this,a),this.scale=Math.sqrt(2)*.5}bO(b,a),b.title="Lambert Azimuthal Equal-Area Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l;g=this.rad(b),e=this.rad(a),f=Math,h=f.sin,c=f.cos,d=f.pow(2/(1+h(this.phi0)*h(g)+c(this.phi0)*c(g)*c(e-this.lam0)),.5),d*=this.scale,j=this.r*d*c(g)*h(e-this.lam0),l=-this.r*d*(c(this.phi0)*h(g)-h(this.phi0)*c(g)*c(e-this.lam0)),i=this.r+j,k=this.r+l;return[i,k]};return b}(c),bD.laea=C,bh=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Stereographic Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l,m;h=this.rad(b),f=this.rad(a),g=Math,i=g.sin,c=g.cos,e=.5,d=2*e/(1+i(this.phi0)*i(h)+c(this.phi0)*c(h)*c(f-this.lam0)),k=this.r*d*c(h)*i(f-this.lam0),m=-this.r*d*(c(this.phi0)*i(h)-i(this.phi0)*c(h)*c(f-this.lam0)),j=this.r+k,l=this.r+m;return[j,l]};return b}(c),bD.stereo=bh,bc=function(a){function b(a){var c,d,e,f,g,h,i,j,k,l;b.__super__.constructor.call(this,{lon0:0,lat0:0}),this.dist=(j=a.dist)!=null?j:3,this.up=this.rad((k=a.up)!=null?k:0),this.tilt=this.rad((l=a.tilt)!=null?l:0),this.scale=1,f=Number.MAX_VALUE,e=Number.MAX_VALUE*-1;for(c=h=0;h<=179;c=++h)for(d=i=0;i<=360;d=++i)g=this.project(d-180,c-90),f=Math.min(g[0],f),e=Math.max(g[0],e);this.scale=this.r*2/(e-f),b.__super__.constructor.call(this,a);return}bO(b,a),b.parameters=["lon0","lat0","tilt","dist","up"],b.title="Satellite Projection",b.prototype.project=function(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x;c==null&&(c=0),m=this.rad(b),k=this.rad(a),l=Math,p=l.sin,f=l.cos,n=this.r,o=n*(c+6371)/3671,g=p(this.phi0)*p(m)+f(this.phi0)*f(m)*f(k-this.lam0),j=(this.dist-1)/(this.dist-g),j=(this.dist-1)/(this.dist-g),j*=this.scale,t=o*j*f(m)*p(k-this.lam0),w=-o*j*(f(this.phi0)*p(m)-p(this.phi0)*f(m)*f(k-this.lam0)),i=f(this.up),r=p(this.up),h=f(this.tilt),q=p(this.tilt),e=o*(this.dist-1),d=(w*i+t*r)*p(this.tilt/e)+h,u=(t*i-w*r)*f(this.tilt/d),x=(w*i+t*r)/d,s=n+u,v=n+x;return[s,v]},b.prototype._visible=function(a,b){var c,d,e,f;e=this.to_elevation(b),c=this.to_azimuth(a),f=Math,d=f.sin(e)*f.sin(this.elevation0)+f.cos(this.elevation0)*f.cos(e)*f.cos(c-this.azimuth0);return d>=1/this.dist},b.prototype.sea=function(){var a,b,c,d,e;b=[],d=this.r,a=Math;for(c=e=0;e<=360;c=++e)b.push([d+a.cos(this.rad(c))*d,d+a.sin(this.rad(c))*d]);return b};return b}(c),bD.satellite=bc,q=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.title="Equidistant Azimuthal Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;i=this,j=i.rad(b),g=i.rad(a),h=Math,k=h.sin,d=h.cos,e=k(this.phi0)*k(j)+d(this.phi0)*d(j)*d(g-this.lam0),c=h.acos(e),f=.325*c/k(c),m=this.r*f*d(j)*k(g-this.lam0),o=-this.r*f*(d(this.phi0)*k(j)-k(this.phi0)*d(j)*d(g-this.lam0)),l=this.r+m,n=this.r+o;return[l,n]},b.prototype._visible=function(a,b){return!0};return b}(c),bD.equi=q,b=function(a){function c(a){var b;b=this,a.lat0=0,c.__super__.constructor.call(this,a),b.lam0=0}var b;bO(c,a),c.title="Aitoff Projection",c.parameters=["lon0"],b=.6366197723675814,c.prototype.project=function(a,c){var d,e,f,g,h,i,j,k;g=this,k=g.ll(a,c),a=k[0],c=k[1],a=g.clon(a),f=g.rad(a),h=g.rad(c),d=.5*f,e=Math.acos(Math.cos(h)*Math.cos(d)),e!==0?(j=1/Math.sin(e),i=2*e*Math.cos(h)*Math.sin(d)*j,j*=e*Math.sin(h)):i=j=0,g.winkel&&(i=(i+f*b)*.5,j=(j+h)*.5);return[i*1e3,j*-1e3]},c.prototype._visible=function(a,b){return!0};return c}(X),bD.aitoff=b,bo=function(a){function b(a){b.__super__.constructor.call(this,a),this.winkel=!0}bO(b,a),b.title="Winkel Tripel Projection";return b}(b),bD.winkel3=bo,n=function(a){function b(a){var c,d,e;c=this,b.__super__.constructor.call(this,a),c.lat1=(d=a.lat1)!=null?d:30,c.phi1=c.rad(c.lat1),c.lat2=(e=a.lat2)!=null?e:50,c.phi2=c.rad(c.lat2)}bO(b,a),b.title="Conic Projection",b.parameters=["lon0","lat0","lat1","lat2"],b.prototype._visible=function(a,b){var c;c=this;return b>c.minLat&&b<c.maxLat},b.prototype._truncate=function(a,b){return[a,b]},b.prototype.clon=function(a){a-=this.lon0,a<-180?a+=360:a>180&&(a-=360);return a};return b}(V),D=function(a){function b(a){var c,d,e,f,g,h,i,j,k,l,m,n,o;k=this,b.__super__.constructor.call(this,a),g=Math,o=[g.sin,g.cos,g.abs,g.log,g.tan,g.pow],l=o[0],e=o[1],c=o[2],bs=o[3],n=o[4],i=o[5],k.n=h=m=l(k.phi1),f=e(k.phi1),j=c(k.phi1-k.phi2)>=1e-10,j&&(h=bs(f/e(k.phi2))/bs(n(k.QUARTERPI+.5*k.phi2)/n(k.QUARTERPI+.5*k.phi1))),k.c=d=f*i(n(k.QUARTERPI+.5*k.phi1),h)/h,c(c(k.phi0)-k.HALFPI)<1e-10?k.rho0=0:k.rho0=d*i(n(k.QUARTERPI+.5*k.phi0),-h),k.minLat=-60,k.maxLat=85}bO(b,a),b.title="Lambert Conformal Conic Projection",b.prototype.project=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;l=this,i=l.rad(b),e=l.rad(l.clon(a)),g=Math,q=[g.sin,g.cos,g.abs,g.log,g.tan,g.pow],m=q[0],d=q[1],c=q[2],bs=q[3],n=q[4],j=q[5],h=l.n,c(c(i)-l.HALFPI)<1e-10?k=0:k=l.c*j(n(l.QUARTERPI+.5*i),-h),f=e*h,o=1e3*k*m(f),p=1e3*(l.rho0-k*d(f));return[o,p*-1]};return b}(n),bD.lcc=D,W=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a);return b}(n),bl=function(){function a(a,b,c,d,e,f){var g;g=this,g.bbox=a,g.width=b,g.padding=d!=null?d:0,g.halign=e!=null?e:"center",g.valign=f!=null?f:"center",g.height=c,g.scale=Math.min((b-d*2)/a.width,(c-d*2)/a.height)}a.prototype.project=function(a,b){var c,d,e,f,g,h,i;b==null&&(b=a[1],a=a[0]),e=this,f=e.scale,c=e.bbox,d=e.height,g=e.width,h=e.halign==="center"?(g-c.width*f)*.5:e.halign==="left"?e.padding*f:g-(c.width-e.padding)*f,i=e.valign==="center"?(d-c.height*f)*.5:e.valign==="top"?e.padding*f:0,a=(a-c.left)*f+h,b=(b-c.top)*f+i;return[a,b]},a.prototype.projectPath=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;e=this;if(a.type==="path"){d=[],b=[99999,99999,-99999,-99999],o=a.contours;for(k=0,m=o.length;k<m;k++){g=o[k],c=[];for(l=0,n=g.length;l<n;l++)p=g[l],i=p[0],j=p[1],q=e.project(i,j),i=q[0],j=q[1],c.push([i,j]),b[0]=Math.min(b[0],i),b[1]=Math.min(b[1],j),b[2]=Math.max(b[2],i),b[3]=Math.max(b[3],j);d.push(c)}f=new br.geom.Path(a.type,d,a.closed),f._bbox=b;return f}if(a.type==="circle"){r=e.project(a.x,a.y),i=r[0],j=r[1],h=a.r*e.scale;return new br.geom.Circle(i,j,h)}},a.prototype.asBBox=function(){var a;a=this;return new br.BBox(0,0,a.width,a.height)};return a}(),bl.fromXML=function(a){var b,c,e,f,g;g=Number(a.getAttribute("w")),e=Number(a.getAttribute("h")),f=Number(a.getAttribute("padding")),c=a.getElementsByTagName("bbox")[0],b=d.fromXML(c);return new br.View(b,g,e,f)},br.View=bl,br.Kartograph.prototype.dotgrid=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;r=this,q=(T=a.layer)!=null?T:r.layerIds[r.layerIds.length-1];if(!r.layers.hasOwnProperty(q))bB('dotgrid error: layer "'+q+'" not found');else{p=r.layers[q],c=a.data,d=a.value,e=a.key,t={};if(e!=null&&bE(c)==="array")for(B=0,F=c.length;B<F;B++)w=c[B],o=w[e],t[String(o)]=w;else for(o in c)w=c[o],t[String(o)]=w;i=(U=a.style)!=null?U:{fill:"black",stroke:"none"},y=a.size,n=(V=a.gridsize)!=null?V:15,h=(W=p.dotgrid)!=null?W:p.dotgrid={gridsize:n,grid:[]};if(h.gridsize!==n){X=h.grid;for(C=0,G=X.length;C<G;C++)m=X[C],m.shape!=null&&(m.shape.remove(),m.shape=null)}if(n>0){if(h.grid.length===0)for(z=D=0,L=r.viewport.width;0<=L?D<=L:D>=L;z=D+=n)for(A=E=0,M=r.viewport.height;0<=M?E<=M:E>=M;A=E+=n){m={x:z+(Math.random()-.5)*n*.2,y:A+(Math.random()-.5)*n*.2,pathid:!1},l=!1,N=p.pathsById;for(o in N){u=N[o];for(J=0,H=u.length;J<H;J++){s=u[J];if(s.vpath.isInside(m.x,m.y)){l=!0,v=(O=t[o])!=null?O:null,x=y(v),m.pathid=o,m.shape=p.paper.circle(m.x,m.y,1);break}}if(l)break}h.grid.push(m)}P=h.grid;for(K=0,I=P.length;K<I;K++)m=P[K],m.pathid&&(v=(Q=t[m.pathid])!=null?Q:null,x=y(v),k=(R=a.duration)!=null?R:0,f=(S=a.delay)!=null?S:0,bE(f)==="function"?g=f(v):g=f,k>0&&Raphael.svg?(b=Raphael.animation({r:x*.5},k),m.shape.animate(b.delay(g))):m.shape.attr({r:x*.5}),bE(i)==="function"?j=i(v):j=i,m.shape.attr(j))}}},bq=(bM=br.filter)!=null?bM:br.filter={},bq.__knownFilter={},bq.__patternFills=0,L.prototype.SVG=function(a,b){var c,d;typeof a=="string"&&(a=window.document.createElementNS("http://www.w3.org/2000/svg",a));if(b)for(c in b)d=b[c],a.setAttribute(c,d);return a},br.Kartograph.prototype.addFilter=function(a,b,c){var d,e,f;c==null&&(c={}),f=this,d=window.document;if(br.filter[b]!=null)e=(new br.filter[b](c)).getFilter(a);else throw"unknown filter type "+b;return f.paper.defs.appendChild(e)},L.prototype.applyFilter=function(b){var c;c=this;return a("."+c.id,c.paper.canvas).attr({filter:"url(#"+b+")"})},L.prototype.applyTexture=function(a,b,c){var d,e,f,g,h,i;b==null&&(b=!1),c==null&&(c="#000"),e=this,bq.__patternFills+=1,h=e.paths,i=[];for(f=0,g=h.length;f<g;f++)d=h[f],!b||b(d.data)?i.push(d.svgPath.attr({fill:"url("+a+")"})):i.push(d.svgPath.attr("fill",c));return i},t=function(){function a(a){this.params=a!=null?a:{}}a.prototype.getFilter=function(a){var b,c;c=this,b=c.SVG("filter",{id:a}),c.buildFilter(b);return b},a.prototype._getFilter=function(){throw"not implemented"},a.prototype.SVG=function(a,b){var c,d;typeof a=="string"&&(a=window.document.createElementNS("http://www.w3.org/2000/svg",a));if(b)for(c in b)d=b[c],a.setAttribute(c,d);return a};return a}(),g=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.buildFilter=function(a){var b,c,d;d=this,b=d.SVG,c=b("feGaussianBlur",{stdDeviation:d.params.size||4,result:"blur"});return a.appendChild(c)};return b}(t),bq.blur=g,v=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.buildFilter=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;g=this,c=(l=g.params.blur)!=null?l:4,i=(m=g.params.strength)!=null?m:1,d=(n=g.params.color)!=null?n:"#D1BEB0",typeof d=="string"&&(d=chroma.hex(d)),h=d.rgb,e=(o=g.params.inner)!=null?o:!1,f=(j=g.params.knockout)!=null?j:!1,b=(k=g.params.alpha)!=null?k:1,e?g.innerGlow(a,c,i,h,b,f):g.outerGlow(a,c,i,h,b,f)},b.prototype.outerGlow=function(a,b,c,d,e,f){var g,h,i,j,k,l,m;k=this,g=k.SVG,j=g("feColorMatrix",{"in":"SourceGraphic",type:"matrix",values:"0 0 0 0 0   0 0 0 0 0   0 0 0 0 0   0 0 0 1 0",result:"mask"}),a.appendChild(j),c>0&&(m=g("feMorphology",{"in":"mask",radius:c,operator:"dilate",result:"mask"}),a.appendChild(m)),j=g("feColorMatrix",{"in":"mask",type:"matrix",values:"0 0 0 0 "+d[0]/255+" 0 0 0 0 "+d[1]/255+" 0 0 0 0 "+d[2]/255+"  0 0 0 1 0",result:"r0"}),a.appendChild(j),h=g("feGaussianBlur",{"in":"r0",stdDeviation:b,result:"r1"}),a.appendChild(h),i=g("feComposite",{operator:"out","in":"r1",in2:"mask",result:"comp"}),a.appendChild(i),l=g("feMerge"),f||l.appendChild(g("feMergeNode",{"in":"SourceGraphic"})),l.appendChild(g("feMergeNode",{"in":"r1"}));return a.appendChild(l)},b.prototype.innerGlow=function(a,b,c,d,e,f){var g,h,i,j,k,l,m;k=this,g=k.SVG,bs("innerglow"),j=g("feColorMatrix",{"in":"SourceGraphic",type:"matrix",values:"0 0 0 0 0   0 0 0 0 0   0 0 0 0 0   0 0 0 500 0",result:"mask"}),a.appendChild(j),m=g("feMorphology",{"in":"mask",radius:c,operator:"erode",result:"r1"}),a.appendChild(m),h=g("feGaussianBlur",{"in":"r1",stdDeviation:b,result:"r2"}),a.appendChild(h),j=g("feColorMatrix",{type:"matrix","in":"r2",values:"1 0 0 0 "+d[0]/255+" 0 1 0 0 "+d[1]/255+" 0 0 1 0 "+d[2]/255+" 0 0 0 -1 1",result:"r3"}),a.appendChild(j),i=g("feComposite",{operator:"in","in":"r3",in2:"mask",result:"comp"}),a.appendChild(i),l=g("feMerge"),f||l.appendChild(g("feMergeNode",{"in":"SourceGraphic"})),l.appendChild(g("feMergeNode",{"in":"comp"}));return a.appendChild(l)};return b}(t),bq.glow=v,br.Kartograph.prototype.addGeoPath=function(a,b,c){var d,e,f;b==null&&(b=[]),c==null&&(c=""),d=this,f=d.getGeoPathStr(a,b),e=d.paper.path(f),c!==""&&e.node.setAttribute("class",c);return e},br.Kartograph.prototype.getGeoPathStr=function(a,b){var c,d,e,f,g,h,i;b==null&&(b=[]),e=this,type(b)==="string"&&(b=b.split("")),b.length===0&&b.push("M"),f="";for(d in a){g=a[d],c=(i=b[d])!=null?i:"L",h=e.lonlat2xy(g);if(isNaN(h[0])||isNaN(h[1]))continue;f+=c+h[0]+","+h[1]}return f},br.Kartograph.prototype.addGeoPolygon=function(a,b){var c,d,e;e=this,c=["M"];for(d in a)c.push("L");c.push("Z");return e.addGeoPath(a,c,b)},S=function(){function b(b){this.zoomOut=bP(this.zoomOut,this),this.zoomIn=bP(this.zoomIn,this);var c,d,e,f,g,h,i,j;f=this,f.map=b,c=b.container,d=function(b,c){var d,e,f,g;c==null&&(c=[]),e=a('<div class="'+b+'" />');for(f=0,g=c.length;f<g;f++)d=c[f],e.append(d);return e},e=function(b){return a(b.target).addClass("md")},g=function(b){return a(b.target).removeClass("md")},j=d("plus"),j.mousedown(e),j.mouseup(g),j.click(f.zoomIn),i=d("minus"),i.mousedown(e),i.mouseup(g),i.click(f.zoomOut),h=d("zoom-control",[j,i]),c.append(h)}b.prototype.zoomIn=function(a){var b;b=this,b.map.opts.zoom+=1;return b.map.resize()},b.prototype.zoomOut=function(a){var b;b=this,b.map.opts.zoom-=1,b.map.opts.zoom<1&&(b.map.opts.zoom=1);return b.map.resize()};return b}(),bd=function(){function a(a,b,c){var d,e,f,g,h=this;a==null&&(a=[0,1]),b==null&&(b=null),c==null&&(c=null),this.rangedScale=bP(this.rangedScale,this),this.scale=bP(this.scale,this),e=this,g=[];for(d in a){if(bE(c)==="function"&&c(a[d])===!1)continue;b!=null?bE(b)==="function"?f=b(a[d]):f=a[d][b]:f=a[d],isNaN(f)||g.push(f)}g=g.sort(function(a,b){return a-b}),e.values=g,e._range=[0,1],e.rangedScale.range=function(a){e._range=a;return e.rangedScale}}a.prototype.scale=function(a){return a},a.prototype.rangedScale=function(a){var b,c;b=this,a=b.scale(a),c=b._range;return a*(c[1]-c[0])+c[0]};return a}(),H=function(a){function b(){this.scale=bP(this.scale,this);return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.scale=function(a){var b,c;b=this,c=b.values;return(a-c[0])/(c[c.length-1]-c[0])};return b}(bd),I=function(a){function b(){this.scale=bP(this.scale,this);return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.scale=function(a){var b,c;b=this,c=b.values,bs=Math.log;return(bs(a)-bs(c[0]))/(bs(c[c.length-1])-bs(c[0]))};return b}(bd),bf=function(a){function b(){this.scale=bP(this.scale,this);return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.scale=function(a){var b,c;b=this,c=b.values;return Math.sqrt((a-c[0])/(c[c.length-1]-c[0]))};return b}(bd),Y=function(a){function b(){this.scale=bP(this.scale,this);return b.__super__.constructor.apply(this,arguments)}bO(b,a),b.prototype.scale=function(a){var b,c,d,e,f,g;d=this,g=d.values,c=g.length-1;for(b in g){f=g[Number(b)],e=g[Number(b)+1];if(a===f)return b/c;if(b<c&&a>f&&a<e)return b/c+(a-f)/(e-f)}};return b}(bd),br.scale={},br.scale.identity=function(a){return(new bd(domain,prop,bq)).rangedScale},br.scale.linear=function(a,b,c){return(new H(a,b,c)).rangedScale},br.scale.log=function(a,b,c){return(new I(a,b,c)).rangedScale},br.scale.sqrt=function(a,b,c){return(new bf(a,b,c)).rangedScale},br.scale.quantile=function(a,b,c){return(new Y(a,b,c)).rangedScale},bj=function(){function b(b){a=this,a.location=b.location,a.data=b.data,a.map=b.map,a.layers=b.layers,a.key=b.key,a.x=b.x,a.y=b.y}var a;a=null,b.prototype.init=function(){return a},b.prototype.overlaps=function(a){return!1},b.prototype.update=function(b){return a},b.prototype.nodes=function(){return[]},b.prototype.clear=function(){return a};return b}(),br.Symbol=bj,bk=function(){function c(a){this._initTooltips=bP(this._initTooltips,this),this._noverlap=bP(this._noverlap,this),this._kMeans=bP(this._kMeans,this);var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;b=this,m=["data","location","type","map"],k=["filter","tooltip","click","delay","sortBy","clustering","aggregate","clusteringOpts","mouseenter","mouseleave"];for(n=0,r=m.length;n<r;n++){l=m[n];if(a[l]!=null)b[l]=a[l];else throw"SymbolGroup: missing argument '"+l+"'"}for(o=0,s=k.length;o<s;o++)l=k[o],a[l]!=null&&(b[l]=a[l]);d=b.type;if(d==null)bB("could not resolve symbol type",b.type);else{v=d.props;for(p=0,t=v.length;p<t;p++)l=v[p],a[l]!=null&&(b[l]=a[l]);b.layers={mapcanvas:b.map.paper},w=d.layers;for(q=0,u=w.length;q<u;q++)h=w[q],j=c._layerid++,g="sl_"+j,h.type==="svg"?i=b.map.createSVGLayer(g):h.type==="html"&&(i=b.map.createHTMLLayer(g)),b.layers[h.id]=i;b.symbols=[];for(f in b.data)e=b.data[f],bE(b.filter)==="function"?b.filter(e,f)&&b.add(e,f):b.add(e,f);b.layout(),b.render(),b.map.addSymbolGroup(b)}}var b;b=null,c.prototype.add=function(a,c){var d,e,f,g,h,i,j,k;b=this,d=b.type,e=b._evaluate(b.location,a,c),bE(e)==="array"&&(e=new br.LonLat(e[0],e[1])),g={layers:b.layers,location:e,data:a,key:c!=null?c:b.symbols.length,map:b.map},k=d.props;for(i=0,j=k.length;i<j;i++)f=k[i],b[f]!=null&&(g[f]=b._evaluate(b[f],a,c));h=new d(g),b.symbols.push(h);return h},c.prototype.layout=function(){var a,c,d,e,f,g,h,i,j,k;j=b.symbols;for(h=0,i=j.length;h<i;h++){f=j[h],c=f.location;if(bE(c)==="string"){k=c.split("."),a=k[0],e=k[1],d=b.map.getLayerPath(a,e);if(d!=null)g=b.map.viewBC.project(d.path.centroid());else{bB("could not find layer path "+a+"."+e);continue}}else g=b.map.lonlat2xy(c);f.x=g[0],f.y=g[1]}b.clustering==="k-means"?b._kMeans():b.clustering==="noverlap"&&b._noverlap();return b},c.prototype.render=function(){var c,d,e,f,g,h,i,j,k,l,m;b=this,b.sortBy&&(f="asc",bE(b.sortBy)==="string"&&(b.sortBy=b.sortBy.split(" ",2),e=b.sortBy[0],f=(k=b.sortBy[1])!=null?k:"asc"),b.symbols=b.symbols.sort(function(a,c){var d,g,h;bE(b.sortBy)==="function"?(g=b.sortBy(a.data,a),h=b.sortBy(c.data,c)):(g=a[e],h=c[e]);if(g===h)return 0;d=f==="asc"?1:-1;return g>h?1*d:-1*d})),l=b.symbols;for(g=0,i=l.length;g<i;g++){d=l[g],d.render(),m=d.nodes();for(h=0,j=m.length;h<j;h++)c=m[h],c.symbol=d}bE(b.tooltip)==="function"&&b._initTooltips(),a.each(["click","mouseenter","mouseleave"],function(e,f){var g,h,i,j;if(bE(b[f])==="function"){i=b.symbols,j=[];for(g=0,h=i.length;g<h;g++)d=i[g],j.push(function(){var e,g,h,i,j=this;h=d.nodes(),i=[];for(e=0,g=h.length;e<g;e++)c=h[e],i.push(a(c)[f](function(c){var d;d=c.target;while(!d.symbol)d=a(d).parent().get(0);c.stopPropagation();return b[f](d.symbol.data,d.symbol,c)}));return i}.call(this));return j}});return b},c.prototype.tooltips=function(a){b=this,b.tooltips=a,b._initTooltips();return b},c.prototype.remove=function(a){var c,d,e,f,g,h,i,j,k;b=this,d=[],i=b.symbols;for(g=0,h=i.length;g<h;g++){f=i[g];if(a!=null&&!a(f.data)){d.push(f);continue}try{f.clear()}catch(l){bB("error: symbolgroup.remove")}}if(a==null){j=b.layers,k=[];for(c in j)e=j[c],c!=="mapcanvas"?k.push(e.remove()):k.push(void 0);return k}return b.symbols=d},c.prototype._evaluate=function(a,b,c){var d;return bE(a)==="function"?d=a(b,c):d=a},c.prototype._kMeans=function(){var a,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x;b=this,(u=b.osymbols)==null&&(b.osymbols=b.symbols),a=b.type,b.clusteringOpts!=null&&(k=b.clusteringOpts.size),k==null&&(k=64),c=bR().iterations(16).size(k),v=b.osymbols;for(m=0,q=v.length;m<q;m++)j=v[m],c.add({x:j.x,y:j.y});g=c.means(),h=[];for(n=0,r=g.length;n<r;n++){f=g[n];if(f.size===0)continue;d=[],w=f.indices;for(o=0,s=w.length;o<s;o++)e=w[o],d.push(b.osymbols[e].data);d=b.aggregate(d),l={layers:b.layers,location:!1,data:d,map:b.map},x=a.props;for(p=0,t=x.length;p<t;p++)i=x[p],b[i]!=null&&(l[i]=b._evaluate(b[i],d));j=new a(l),j.x=f.x,j.y=f.y,h.push(j)}return b.symbols=h},c.prototype._noverlap=function(){var a,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V;b=this,(S=b.osymbols)==null&&(b.osymbols=b.symbols),j=3,a=b.type;if(bQ.call(a.props,"radius")<0)bB('noverlap layout only available for symbols with property "radius"');else{A=b.osymbols.slice(),b.clusteringOpts!=null&&(D=b.clusteringOpts.tolerance,n=b.clusteringOpts.maxRatio),D==null&&(D=.05),n==null&&(n=.8);for(h=H=0,T=j-1;0<=T?H<=T:H>=T;h=0<=T?++H:--H){A.sort(function(a,b){return b.radius-a.radius}),k=A.length,o=[];for(p=I=0,U=k-3;0<=U?I<=U:I>=U;p=0<=U?++I:--I){x=A[p];if(!x)continue;u=x.radius*(1-D),l=x.x-u,s=x.x+u,B=x.y-u,c=x.y+u,i=[];for(q=J=V=p+1,Q=k-2;V<=Q?J<=Q:J>=Q;q=V<=Q?++J:--J){y=A[q];if(!y)continue;v=y.radius,m=y.x-v,t=y.x+v,C=y.y-v,d=y.y+v,v/x.radius<n&&!(s<m||t<l)&&!(c<C||d<B)&&(f=y.x-x.x,g=y.y-x.y,f*f+g*g<(u+v)*(u+v)&&i.push(q))}if(i.length>0){e=[x.data],r=x.radius*x.radius;for(K=0,L=i.length;K<L;K++)h=i[K],e.push(A[h].data),r+=A[h].radius*A[h].radius;e=b.aggregate(e),z={layers:b.layers,location:!1,data:e,map:b.map},R=a.props;for(O=0,M=R.length;O<M;O++)p=R[O],b[p]!=null&&(z[p]=b._evaluate(b[p],e));w=new a(z),E=x.radius*x.radius/r,F=x.x*E,G=x.y*E;for(P=0,N=i.length;P<N;P++)h=i[P],y=A[h],E=y.radius*y.radius/r,F+=y.x*E,G+=y.y*E,A[h]=void 0;w.x=F,w.y=G,A[p]=void 0,o.push(w)}else o.push(x)}A=o}return b.symbols=A}},c.prototype._initTooltips=function(){var c,d,e,f,g,h,i,j,k,l,m;b=this,f=b.tooltip,l=b.symbols;for(h=0,j=l.length;h<j;h++){e=l[h],c={position:{target:"mouse",viewport:a(window),adjust:{x:7,y:7}},show:{delay:20},content:{},events:{show:function(b,c){return a(".qtip").filter(function(){return this!==c.elements.tooltip.get(0)}).hide()}}},g=f(e.data,e.key),bE(g)==="string"?c.content.text=g:bE(g)==="array"&&(c.content.title=g[0],c.content.text=g[1]),m=e.nodes();for(i=0,k=m.length;i<k;i++)d=m[i],a(d).qtip(c)}},c.prototype.onResize=function(){var a,c,d,e;b=this,b.layout(),e=b.symbols;for(c=0,d=e.length;c<d;c++)a=e[c],a.update()},c.prototype.update=function(a,c,d){var e,f,g,h,i,j,k,l;b=this,a==null&&(a={}),k=b.symbols;for(g=0,i=k.length;g<i;g++){f=k[g],l=b.type.props;for(h=0,j=l.length;h<j;h++)e=l[h],a[e]!=null?f[e]=b._evaluate(a[e],f.data):b[e]!=null&&(f[e]=b._evaluate(b[e],f.data));f.update(c,d)}return b};return c}(),bk._layerid=0,br.SymbolGroup=bk,br.Kartograph.prototype.addSymbols=function(a){a.map=this;return new bk(a)},br.dorlingLayout=function(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;c==null&&(c=40),n=[],a.each(b.symbols,function(a,b){return n.push({i:a,x:b.path.attrs.cx,y:b.path.attrs.cy,r:b.path.attrs.r})}),n.sort(function(a,b){return b.r-a.r}),f=function(){var a,c,d;for(c=0,d=n.length;c<d;c++)a=n[c],b.symbols[a.i].path.attr({cx:a.x,cy:a.y})};for(o=r=1;1<=c?r<=c:r>=c;o=1<=c?++r:--r)for(l in n)for(m in n)if(m>l){d=n[l],e=n[m];if(d.x+d.r<e.x-e.r||d.x-d.r>e.x+e.r)continue;if(d.y+d.r<e.y-e.r||d.y-d.r>e.y+e.r)continue;i=d.x-e.x,j=d.y-e.y,h=i*i+j*j,p=d.r+e.r,q=p*p,h<q&&(g=Math.sqrt(h),k=10/g,d.x+=i*k*(1-d.r/p),d.y+=j*k*(1-d.r/p),e.x-=i*k*(1-e.r/p),e.y-=j*k*(1-e.r/p))}return f()},h=function(b){function c(a){this.nodes=bP(this.nodes,this),this.clear=bP(this.clear,this),this.update=bP(this.update,this),this.render=bP(this.render,this),this.overlaps=bP(this.overlaps,this);var b,d,e;b=this,c.__super__.constructor.call(this,a),b.radius=(d=a.radius)!=null?d:4,b.style=a.style,b.attrs=a.attrs,b.title=a.title,b["class"]=(e=a["class"])!=null?e:"bubble"}bO(c,b),c.prototype.overlaps=function(a){var b,c,d,e,f,g,h,i,j,k,l;d=this,k=[d.x,d.y,d.radius],g=k[0],i=k[1],e=k[2],l=[a.x,a.y,a.radius],h=l[0],j=l[1],f=l[2];if(g-e>h+f||g+e<h-f||i-e>j+f||i+e<j-f)return!1;b=g-h,c=i-j;return b*b+c*c>(e+f)*(e+f)?!1:!0},c.prototype.render=function(a){var b;b=this,b.path==null&&(b.path=b.layers.mapcanvas.circle(b.x,b.y,b.radius)),b.update(),b.map.applyCSS(b.path);return b},c.prototype.update=function(b,c){var d,e,f;b==null&&(b=!1),c==null&&(c="expo-out"),e=this,f=e.path,d={cx:e.x,cy:e.y,r:e.radius},e.attrs!=null&&(d=a.extend(d,e.attrs)),b?f.animate(d,b,c):f.attr(d),f.node!=null&&(e.style!=null&&f.node.setAttribute("style",e.style),e["class"]!=null&&f.node.setAttribute("class",e["class"])),e.title!=null&&f.attr("title",e.title);return e},c.prototype.clear=function(){var a;a=this,a.path.remove();return a},c.prototype.nodes=function(){var a;a=this;return[a.path.node]};return c}(bj),h.props=["radius","style","class","title","attrs"],h.layers=[],br.Bubble=h,A=function(b){function c(a){var b,d,e,f,g,h;b=this,c.__super__.constructor.call(this,a),b.icon=(e=a.icon)!=null?e:"",b.offset=(f=a.offset)!=null?f:[0,0],b.iconsize=(g=a.iconsize)!=null?g:[10,10],b["class"]=(h=a["class"])!=null?h:"",b.title=(d=a.title)!=null?d:""}bO(c,b),c.prototype.render=function(b){var c,d;d=this,c=d.map.container,d.img=a("<img />"),d.img.attr({src:d.icon,title:d.title,alt:d.title,width:d.iconsize[0],height:d.iconsize[1]}),d.img.addClass(d["class"]),d.img.css({position:"absolute","z-index":1e3,cursor:"pointer"}),d.img[0].symbol=d,c.append(d.img);return d.update()},c.prototype.update=function(){var a;a=this;return a.img.css({left:a.x+a.offset[0]+"px",top:a.y+a.offset[1]+"px"})},c.prototype.clear=function(){var a;a=this,a.img.remove();return a},c.prototype.nodes=function(){var a;a=this;return[a.img]};return c}(br.Symbol),A.props=["icon","offset","class","title","iconsize"],A.layers=[],br.Icon=A,bi=function(a){function b(a){var c,d,e,f,g;c=this,b.__super__.constructor.call(this,a),c.text=(d=a.text)!=null?d:"",c.style=(e=a.style)!=null?e:"",c["class"]=(f=a["class"])!=null?f:"",c.offset=(g=a.offset)!=null?g:[0,0]}bO(b,a),b.prototype.render=function(a){var b,c;c=this,c.lbl=b=c.layers.mapcanvas.text(c.x,c.y,c.text),c.update();return c},b.prototype.update=function(){var a;a=this,a.lbl.attr({x:a.x+a.offset[0],y:a.y+a.offset[1]}),a.lbl.node.setAttribute("style",a.style);return a.lbl.node.setAttribute("class",a["class"])},b.prototype.clear=function(){var a;a=this,a.lbl.remove();return a},b.prototype.nodes=function(){var a;a=this;return[a.lbl.node]};return b}(br.Symbol),bi.props=["text","style","class","offset"],bi.layers=[],br.Label=bi,z=function(b){function c(a){var b,d,e,f;b=this,c.__super__.constructor.call(this,a),b.text=(d=a.text)!=null?d:"",b.style=(e=a.style)!=null?e:"",b["class"]=(f=a["class"])!=null?f:""}bO(c,b),c.prototype.render=function(b){var c,d,e;e=this,c=a("<div>"+e.text+"</div>"),c.css({width:"50px",position:"absolute",left:"-25px","text-align":"center"}),e.lbl=d=a('<div class="label" />'),d.append(c),e.layers.lbl.append(d),c.css({height:c.height()+"px",top:c.height()*-0.4+"px"}),e.update();return e},c.prototype.update=function(){var a;a=this;return a.lbl.css({position:"absolute",left:a.x+"px",top:a.y+"px"})},c.prototype.clear=function(){var a;a=this,a.lbl.remove();return a},c.prototype.nodes=function(){var a;a=this;return[a.lbl[0]]};return c}(br.Symbol),z.props=["text","style","class"],z.layers=[{id:"lbl",type:"html"}],br.HtmlLabel=z,E=function(b){function c(a){this.nodes=bP(this.nodes,this),this.clear=bP(this.clear,this),this.update=bP(this.update,this),this.render=bP(this.render,this);var b,d,e;b=this,c.__super__.constructor.call(this,a),b.labelattrs=(d=a.labelattrs)!=null?d:{},b.buffer=a.buffer,b.center=(e=a.center)!=null?e:!0}bO(c,b),c.prototype.render=function(a){var b;b=this,b.title!=null&&String(b.title).trim()!==""&&(b.buffer&&(b.bufferlabel=b.layers.mapcanvas.text(b.x,b.y,b.title)),b.label=b.layers.mapcanvas.text(b.x,b.y,b.title)),c.__super__.render.call(this,a);return b},c.prototype.update=function(b,d){var e,f,g,h,i;b==null&&(b=!1),d==null&&(d="expo-out"),f=this,c.__super__.update.call(this,b,d),f.label!=null&&(g=f.map.viewport,e=a.extend({},f.labelattrs),h=f.x,i=f.y,f.center?i-=0:h>g.width*.5?(e["text-anchor"]="end",h-=f.radius+5):h<g.width*.5&&(e["text-anchor"]="start",h+=f.radius+5),e.x=h,e.y=i,f.buffer&&(f.bufferlabel.attr(e),f.bufferlabel.attr({stroke:"#fff",fill:"#fff","stroke-linejoin":"round","stroke-linecap":"round","stroke-width":6})),f.label.attr(e),f.label.toFront());return f},c.prototype.clear=function(){var a;a=this;return c.__super__.clear.apply(this,arguments)},c.prototype.nodes=function(){var a,b;a=this,b=c.__super__.nodes.apply(this,arguments),a.label&&b.push(a.label.node),a.bufferlabel&&b.push(a.bufferlabel.node);return b};return c}(h),E.props=["radius","style","class","title","labelattrs","buffer","center","attrs"],E.layers=[],br.LabeledBubble=E,U=function(a){function c(a){var d,e,f,g,h,i,j,k,l,m;b=this,c.__super__.constructor.call(this,a),b.radius=(j=a.radius)!=null?j:4,b.styles=(k=a.styles)!=null?k:"",b.colors=(l=a.colors)!=null?l:["#3cc","#c3c","#33c","#cc3"],b.titles=(m=a.titles)!=null?m:["","","","",""],b.values=(e=a.values)!=null?e:[],b.border=(f=a.border)!=null?f:!1,b.borderWidth=(g=a.borderWidth)!=null?g:2,b["class"]=(h=a["class"])!=null?h:"piechart",(i=(d=Raphael.fn).pieChart)==null&&(d.pieChart=bp)}var b;bO(c,a),b=null,c.prototype.overlaps=function(a){var c,d,e,f,g,h,i,j,k,l;k=[b.x,b.y,b.radius],g=k[0],i=k[1],e=k[2],l=[a.x,a.y,a.radius],h=l[0],j=l[1],f=l[2];if(g-e>h+f||g+e<h-f||i-e>j+f||i+e<j-f)return!1;c=g-h,d=i-j;return c*c+d*d>(e+f)*(e+f)?!1:!0},c.prototype.render=function(a){var c;b=this,b.border!=null&&(c=b.layers.mapcanvas.circle(b.x,b.y,b.radius+b.borderWidth).attr({stroke:"none",fill:b.border})),b.chart=b.layers.mapcanvas.pieChart(b.x,b.y,b.radius,b.values,b.titles,b.colors,"none"),b.chart.push(c);return b},c.prototype.update=function(a){var c;return},c.prototype.clear=function(){var a,c,d,e;b=this,e=b.chart;for(c=0,d=e.length;c<d;c++)a=e[c],a.remove();return b},c.prototype.nodes=function(){var a,c,d,e,f;e=b.chart,f=[];for(c=0,d=e.length;c<d;c++)a=e[c],f.push(a.node);return f};return c}(bj),U.props=["radius","values","styles","class","titles","colors","border","borderWidth"],U.layers=[],br.PieChart=U,bp=function(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r;if(isNaN(a)||isNaN(b)||isNaN(c))return[];k=this,m=Math.PI/180,i=k.set(),n=function(a,b,c,d,e,f){var g,h,i,j;g=a+c*Math.cos(-d*m),h=a+c*Math.cos(-e*m),i=b+c*Math.sin(-d*m),j=b+c*Math.sin(-e*m);return k.path(["M",a,b,"L",g,i,"A",c,c,0,+(e-d>180),0,h,j,"z"]).attr(f)},h=-270,o=0,l=function(e){var j,k,l,m,p,q,r;r=d[e],j=360*r/o,q=h+j*.5,k=f[e],m=500,l=30,p=n(a,b,c,h,h+j,{fill:k,stroke:g,"stroke-width":1}),p.mouseover(function(){p.stop().animate({transform:"s1.1 1.1 "+a+" "+b},m,"elastic")}),p.mouseout(function(){p.stop().animate({transform:""},m,"elastic")}),h+=j,i.push(p
)};for(q=0,r=d.length;q<r;q++)p=d[q],o+=p;for(j in d)l(j);return i},drawStackedBars=function(a,b,c,d,e,f,g,h){function k(a,b,c,d,e){return i.rect(a,b,c,d).attr(e)}var i=this,j=this.set(),l=0,m=0,n=function(f){var i=e[f],n=d*i/m,o=a-c*.5,p=b+d*.5-l,q=c,r=g[f],s=500,t=30,u=k(o,p-n,q,n,{fill:r,stroke:h,"stroke-width":1});l+=n,u.mouseover(function(){u.stop().animate({transform:"s1.1 1.1 "+a+" "+b},s,"elastic")}).mouseout(function(){u.stop().animate({transform:""},s,"elastic")}),j.push(u)};for(var o=0,p=e.length;o<p;o++)m+=e[o];for(o=0;o<p;o++)n(o);return j},bg=function(a){function b(a){var c,d,e,f,g,h,i,j,k,l;c=this,b.__super__.constructor.call(this,a),c.styles=(i=a.styles)!=null?i:"",c.colors=(j=a.colors)!=null?j:[],c.titles=(k=a.titles)!=null?k:["","","","",""],c.values=(l=a.values)!=null?l:[],c.width=(e=a.width)!=null?e:17,c.height=(f=a.height)!=null?f:30,c["class"]=(g=a["class"])!=null?g:"barchart",(h=(d=Raphael.fn).drawStackedBarChart)==null&&(d.drawStackedBarChart=drawStackedBars)}bO(b,a),b.prototype.overlaps=function(a){var b,c,d,e,f,g,h,i,j,k,l;d=this,k=[d.x,d.y,d.radius],g=k[0],i=k[1],e=k[2],l=[a.x,a.y,a.radius],h=l[0],j=l[1],f=l[2];if(g-e>h+f||g+e<h-f||i-e>j+f||i+e<j-f)return!1;b=g-h,c=i-j;return b*b+c*c>(e+f)*(e+f)?!1:!0},b.prototype.render=function(a){var b,c,d,e,f,g;d=this,e=d.width,c=d.height,f=d.x,g=d.y,b=d.layers.mapcanvas.rect(f-e*.5-2,g-c*.5-2,e+4,c+4).attr({stroke:"none",fill:"#fff"}),d.chart=d.layers.mapcanvas.drawStackedBarChart(d.x,d.y,d.width,d.height,d.values,d.titles,d.colors,"none"),d.chart.push(b);return d},b.prototype.update=function(){var a,b;a=this;return},b.prototype.clear=function(){var a,b,c,d,e;a=this,e=a.chart;for(c=0,d=e.length;c<d;c++)b=e[c],b.remove();a.chart=[];return a},b.prototype.nodes=function(){var a,b,c,d,e,f;b=this,e=b.chart,f=[];for(c=0,d=e.length;c<d;c++)a=e[c],f.push(a.node);return f};return b}(br.Symbol),bg.props=["values","styles","class","titles","colors","width","height"],bg.layers=[],br.StackedBarChart=bg}).call(this);
