<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik_Plugins
 * @package Piwik_ProfiledVisits
 */

/**
 * ExampleUI API is also an example API useful if you are developing a Piwik plugin.
 *
 * The functions listed in this API are returning the data used in the Controller to draw graphs and
 * display tables. See also the ExampleAPI plugin for an introduction to Piwik APIs.
 *
 * @package Piwik_ProfiledVisits
 */
class Piwik_ProfiledVisits_API
{
    static private $instance = null;

    static public function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function getProfiledVisits($idSite, $date, $period)
    {
        $period = Piwik_Period_Range::advancedFactory($period, $date);
     
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/

        $profils = array(
                    'National_1'=>'Élève',
                    'National_2'=>'Responsable',
                    'National_3'=>'Enseignant',
                    'National_4'=>'Personnel de direction',
                    'National_5'=>'Personnel vie scolaire',
                    'National_6'=>'Personnel administratif',
                    'National_7'=>'Autre');
        $visits = new Piwik_DataTable(); 
        foreach($profils as $pr=>$lib)
        {
            $queryP = "SELECT COUNT(*) as nb_visits FROM piwik_log_visit WHERE 
                        idsite = ? AND visit_first_action_time >= ? AND visit_last_action_time <= ? AND custom_var_v3 = ?";
            $hitsP = Piwik_FetchAll($queryP, array($idSite,$dateStart." 00:00:00", $dateEnd." 23:59:59", $pr));
            $hp = $hitsP[0]['nb_visits'];
            $v = new Piwik_DataTable_Row(array(Piwik_DataTable_Row::COLUMNS => array('label'=> $lib, 'nb_visits'=>$hp),));
            $visits->addRow($v);
        }
        return $visits;
    }

    public function getApplisGlobal($idSite, $date, $period)
    {
        $period = Piwik_Period_Range::advancedFactory($period, $date);
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/
        $visits = new Piwik_DataTable();  
        

        $listApps = array(
            'wordpress',
            'etherpad',
            'opensondage',
            'sap',
            'spip',
            'envolemobile',
            'calendrier',
            'cdc',
            'grr',
            'gepi',
            'ajaxplorer',
            'cdt',
            'owncloud',
            'desktop',
            'piwigo',
            'envole',
            'xdesktop',
            'fluxbb',
            'gestionprofil',
            'dokuwiki',
            'roundcube',
            'taskfreak'
            );
        foreach($listApps as $actionArray){
            $actionName = $actionArray;
            
            $cQuery = "SELECT COUNT(DISTINCT(piwik_log_link_visit_action.idvisit)) as nb_visits 
                        FROM piwik_log_link_visit_action 
                        LEFT JOIN piwik_log_visit ON piwik_log_visit.idvisit=piwik_log_link_visit_action.idvisit 
                        WHERE piwik_log_visit.idsite = ? AND piwik_log_visit.visit_first_action_time > ? AND piwik_log_visit.visit_last_action_time < ?
                        AND piwik_log_link_visit_action.custom_var_v1 = ?";
            $cActions = Piwik_FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $actionName));
            
            $nb = ($cActions[0]['nb_visits']) ? $cActions[0]['nb_visits'] : 0;

            $v = new Piwik_DataTable_Row(array(Piwik_DataTable_Row::COLUMNS => array('label'=> $actionName, 'nb_visits'=>$nb),)); 
            $visits->addRow($v);
        }
        return $visits;
    }

        public function getApplisEleves($idSite, $date, $period)
    {
        $period = Piwik_Period_Range::advancedFactory($period, $date);
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/

        $listApps = array(
            'wordpress',
            'etherpad',
            'opensondage',
            'sap',
            'spip',
            'envolemobile',
            'calendrier',
            'cdc',
            'grr',
            'gepi',
            'ajaxplorer',
            'cdt',
            'owncloud',
            'desktop',
            'piwigo',
            'envole',
            'xdesktop',
            'fluxbb',
            'gestionprofil',
            'dokuwiki',
            'roundcube',
            'taskfreak'
            );
        $visits = new Piwik_DataTable();  
        foreach($listApps as $actionArray){
            $actionName = $actionArray;
            $cQuery = "SELECT COUNT(DISTINCT(piwik_log_link_visit_action.idvisit)) as nb_visits 
                        FROM piwik_log_link_visit_action 
                        LEFT JOIN piwik_log_visit ON piwik_log_visit.idvisit=piwik_log_link_visit_action.idvisit 
                        WHERE piwik_log_visit.idsite = ? AND piwik_log_visit.visit_first_action_time > ? AND piwik_log_visit.visit_last_action_time < ?
                        AND piwik_log_link_visit_action.custom_var_v1 = ?  AND piwik_log_visit.custom_var_v3='National_1'";
            $cActions = Piwik_FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $actionName));
            
            $nb = $cActions[0]['nb_visits'];

            $v = new Piwik_DataTable_Row(array(Piwik_DataTable_Row::COLUMNS => array('label'=> $actionName, 'nb_visits'=>$nb),)); 
            $visits->addRow($v);
        }
        return $visits;
    }

    public function getApplisProfesseurs($idSite, $date, $period)
    {
        $period = Piwik_Period_Range::advancedFactory($period, $date);
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/


        $listApps = array(
            'wordpress',
            'etherpad',
            'opensondage',
            'sap',
            'spip',
            'envolemobile',
            'calendrier',
            'cdc',
            'grr',
            'gepi',
            'ajaxplorer',
            'cdt',
            'owncloud',
            'desktop',
            'piwigo',
            'envole',
            'xdesktop',
            'fluxbb',
            'gestionprofil',
            'dokuwiki',
            'roundcube',
            'taskfreak'
            );
        $visits = new Piwik_DataTable();  
        foreach($listApps as $actionArray){
            $actionName = $actionArray;
            //echo $actionName."<br/>";
            $cQuery = "SELECT COUNT(DISTINCT(piwik_log_link_visit_action.idvisit)) as nb_visits 
                        FROM piwik_log_link_visit_action 
                        LEFT JOIN piwik_log_visit ON piwik_log_visit.idvisit=piwik_log_link_visit_action.idvisit 
                        WHERE piwik_log_visit.idsite = ? AND piwik_log_visit.visit_first_action_time > ? AND piwik_log_visit.visit_last_action_time < ?
                        AND piwik_log_link_visit_action.custom_var_v1 = ?  AND piwik_log_visit.custom_var_v3='National_3'";
            $cActions = Piwik_FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $actionName));
            
            $nb = $cActions[0]['nb_visits'];

            $v = new Piwik_DataTable_Row(array(Piwik_DataTable_Row::COLUMNS => array('label'=> $actionName, 'nb_visits'=>$nb),)); 
            $visits->addRow($v);
        }
        return $visits;
    }

}