<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik_Plugins
 * @package Piwik_ServerStats
 */

/**
 *
 * @package Piwik_ServerStats
 */
class Piwik_ServerStats_Controller extends Piwik_Controller
{
    /**
     * This method's output will be available through :
     * index.php?module=ProfiledVisits&action=index
     */
    public function index()
    {
        echo "hello world";
    }


    function getTypeEtab()
    {
        $idSite = Piwik_Common::getRequestVar('idSite');
        $date = Piwik_Common::getRequestVar('date');
        $period = Piwik_Common::getRequestVar('period');
        
        $view = Piwik_ViewDataTable::factory('graphPie');
        
        $view->init($this->pluginName, __FUNCTION__, 'ServerStats.getTypeEtab');
                
        $view->setColumnsToDisplay(array('label','nb_etabs'));
        $view->setColumnTranslation('label', 'Type établissement');
        $view->setColumnTranslation('nb_etabs', 'Établissement(s)');
        $view->disableRowEvolution();
        $view->disableSearchBox();
        $view->disableTagCloud();
        return $this->renderView($view);
        
    }

}