<?php
namespace Piwik\Plugins\ProfiledVisits\Reports;

use Piwik\Piwik;
use Piwik\Plugin\Report;
use Piwik\Plugin\ViewDataTable;
use Piwik\Plugins\Actions\Columns\ExitPageUrl;
use Piwik\Report\ReportWidgetFactory;
use Piwik\Widget\WidgetsList;
use Piwik\View;

class GetUsersprofiles extends Base
{
    protected function init()
    {
        parent::init();

        $this->name             = Piwik::translate('ProfiledVisits_Usersprofiles');
        $this->documentation    = Piwik::translate('');
        $this->order            = 2;
        $this->metrics          = array('nb_visits');
        $this->widgetTitle      = 'Visites par profil';
    }

    public function configureWidgets(WidgetsList $widgetsList, ReportWidgetFactory $factory)
    {
        $widget = $factory->createWidget();
        $widgetsList->addWidgetConfig($widget);
    }  

    public function configureView(ViewDataTable $view)
    {
        $view->config->addTranslations(array('label' => "Profil"));

        $view->config->show_search                  = false;
        $view->requestConfig->filter_sort_column    = 'nb_visits';
        $view->config->show_pie_chart               = true;
        $view->config->show_table_all_columns       = false;
        $view->config->disable_row_evolution        = true;
        $view->config->filter_limit                 = 20;
        $view->config->columns_to_display           = array_merge(array('label'), $this->metrics);
    }


    public function getRelatedReports()
    {
         return array();
    }
}
