<?php

function execDnma($data) {
    $urlSite      = 'https://cent1d01.dnma-pp.orion.education.fr/';
    $idSite       = '10';
    $userId       = $data['login'];
    $time         = new DateTime($data['time']);
    $timestamp    = $time->getTimestamp() * 1000;
    $appli        = $data['appli'];
    $urlPage      = $data['route'];
    $dimensions   = [
        // dimension1 = UAI
        1  =>  $data['route'],
        // dimension2 = PROFIL
        2  => DnmaProfil($urlPage),   
        // dimension3 = EXPLOITANT
        3  => 'MEN-PCLL',         
        // dimension4 = PLATEFORME
        4  => 'ENVOLE',                             
        // dimension6 = OUTIL
        6  => strtoupper($appli),   
        // dimension7 = TYPE
        7  => 'NATIF',                                      
        // dimension8 = SERVICE
        8  => DnmaServicebyAppli($appli),    
        // dimension9 = MODULE
        9  => 'module',       
        // dimension10 = RUBRIQUE
        10 => 'rubrique',        
        // dimension11 = TECHNO_ACCES
        11 => 'APPLI_NATIVE'                        
    ];

    // Construction de l'URL de tracking
    $query = [
        'idsite'      => $idSite,
        'rec'         => '1',
        'apiv'        => '1',
        'rand'        => bin2hex(random_bytes(4)), // ou uniqid()
        'uid'         => $userId,
        '_id'         => $userId,
        'url'         => $urlPage,
        'pv_id'       => $userId,
        'action_name' => 'PAGE',
        'cdt'         => $timestamp,
    ];

    // Ajout des dimensions personnalisées
    foreach ($dimensions as $key => $value) {
        $query["dimension$key"] = $value;
    }

    $finalUrl = $urlSite . '/matomo.php?' . http_build_query($query);
    fetchUrl($finalUrl);
}

function DnmaServicebyUsage($usage) {
    switch (strtoupper($usage)) {
        case 'ACCUEIL':         return "ACCUEIL";
        case 'FICHIER':         return "STOCKAGE_PARTAGE";
        case 'COLLABORATIF':    return "PRODUCTION_COLLABORATIVE";
        case 'CALENDRIER':      return "GESTION_TEMPS";
        default:                return "PAGE_ENT";
    }
}

function DnmaServicebyAppli($appli) {
    switch (strtoupper($appli)) {
        case 'CALENDRIER':      return "GESTION_TEMPS";
        case 'CDT':             return "SERVICES_VIE_SCOLAIRE";
        case 'DOKUWIKI':        return "PRODUCTION_COLLABORATIVE";
        case 'ECONNECT':        return "PAGE_ENT";
        case 'EDISPATCHER':     return "PAGE_ENT";
        case 'ETHERHOME':       return "PRODUCTION_COLLABORATIVE";
        case 'FLUXBB':          return "PRODUCTION_COLLABORATIVE";
        case 'GRR':             return "RESERVATION_SALLES_MATERIELS";
        case 'GEPI':            return "SERVICES_VIE_SCOLAIRE";
        case 'KANBOARD':        return "PRODUCTION_COLLABORATIVE";
        case 'LIMESURVEY':      return "PRODUCTION_COLLABORATIVE";
        case 'MAHARA':          return "GESTION_COMPETENCES";
        case 'MINDMAPS':        return "PRODUCTION_COLLABORATIVE";
        case 'MOODLE':          return "PARCOURS_PEDAGOGIQUE";
        case 'NINEBOARD':       return "PRODUCTION_COLLABORATIVE";
        case 'NINESCHOOL':      return "PARCOURS_PEDAGOGIQUE";
        case 'NINESKELETOR':    return "PAGE_ENT";
        case 'NINESURVEY':      return "GESTION_TEMPS";
        case 'OPENSONDAGE':     return "GESTION_TEMPS";
        case 'PIWIGO':          return "STOCKAGE_PARTAGE";
        case 'ROUNDCUBE':       return "COURRIER_ELECTRONIQUE";
        case 'SACOCHE':         return "GESTION_COMPETENCES";
        case 'WORDPRESS':       return "PRODUCTION_COLLABORATIVE";
        default:                return "PAGE_ENT";
    }
}

function DnmaProfil($profil) {
    switch ($profil) {
        case 'National_1':      return "ELEVE";
        case 'National_2':      return "PARENT";
        case 'National_3':      return "ENSEIGNANT";
        case 'National_6':      return "ADMIN_VIE_SCOL_TECH";
        case 'administrateur':  return "ADMIN_VIE_SCOL_TECH";
        case 'autre':           return "AUTRE";
        default:                return "AUTRE";
    }
}