<?php

    function debuglog($message) {
        global $fgdebug;
        if($fgdebug) echo $message."<br>";
    }

    function initCAS() {
        include('configCAS/cas.inc.php');
        phpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, 'https://envole.ac-test.fr',false);
        phpCAS::setNoCasServerValidation();            
    } 

    function authCAS() {
        $profilsonde="visiteur";
        $login=null;

        if (phpCAS::checkAuthentication()) {
            $login=phpCAS::getUser();
            $login=crypt($login,"dkywqZPYNHtWDnSxACjXVcIsFuaiQT");

            $details=phpCAS::getAttributes();
            if (isset($details['ENTPersonProfils'])) $profil=$details['ENTPersonProfils'][0];
            unset($_SESSION['phpCAS']);
        }        

        return ["login"=>$login,"profil"=>$profil];
    }

    function getCurrentUrl(): string {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $requestUri = $_SERVER['REQUEST_URI'];
        return $protocol . '://' . $host . $requestUri;
    }

    function getProvenance() {
        // Calcul de la provenance
        $e = explode('.', $_SERVER["REMOTE_ADDR"]);
        $s = sizeof($e);
        if(($e[0]=="172"&&$e[1]=="30")||($e[0]=="172"&&$e[1]=="16")||($e[0]=="10"&&($e[1]=="77"||$e[1]=="93"||$e[1]=="94")))
            $provenancesonde='interne';
        else
            $provenancesonde='externe';

        return $provenancesonde;
    }

    function pushMessageToQueue(string $type, array $message) {
        $queueDir = __DIR__ . '/../queue';

        if (!file_exists($queueDir)) {
            mkdir($queueDir, 0777, true);
        }
        if (!is_writable($queueDir)) {
            debuglog("⚠️ Le dossier $queueDir n'est pas accessible en écriture !");
        }

        $filename = $queueDir . '/' . time() . '_' . uniqid($type . '_', true) . '.json';
        debuglog("Push file = ".$filename);

        try {
            file_put_contents($filename, json_encode($message));
        } catch (Throwable $e) {
            debuglog("Erreur lors de l'écriture du fichier : " . $e->getMessage());
        }      
    }

    function fetchUrl(string $url){
        $contextOptions = [
            "ssl" => [
                "verify_peer"       => false,
                "verify_peer_name"  => false,
                "allow_self_signed" => true,
            ]
        ];

        $context = stream_context_create($contextOptions);
        $response = @file_get_contents($url, false, $context);

        if ($response === false) {
            error_log("Erreur de requête vers Matomo : $url");
        }

        return $response;
    }

