<?php
    require_once __DIR__ . '/../vendor/autoload.php';
    session_name("sondepiwik");
    session_start();
    
    include('../include/config.php');
    include('../include/function.php');

    $appli = (isset($_GET["appli"])?$_GET["appli"]:null);
    $profil = (isset($_GET["profil"])?$_GET["profil"]:null);
    $login = (isset($_GET["login"])?$_GET["login"]:null);
    $provenance = (isset($_GET["provenance"])?$_GET["provenance"]:getProvenance());
    $route = (isset($_GET["route"])?$_GET["route"]:null);
    $usage = (isset($_GET["usage"])?$_GET["usage"]:null);
    $notsondednma=(isset($_GET["notsondednma"])?$_GET["notsondednma"]:false);

    $sondenotincludecas=(isset($sondenotincludecas)?$sondenotincludecas:false);

    if(!$activerSondednma&&!$activerSondeaca&&!$activerSondelocal)
        return;
    
    debuglog("== SONDE =====================");

    if(!$sondenotincludecas&&(!isset($profil)||!isset($login))) {
        // Initialiser le client SSO si besoin
        debuglog("== INIT CAS");
        initCAS();

        // Récupération du profil sso si non définis par l'appelant
        debuglog("== INIT LOGIN & PROFIL");
        $infoCAS=authCAS();
        $profil=(isset($profil)?$profil:$infoCAS["profil"]);
        $login=(isset($login)?$login:$infoCAS["login"]);
    }

    debuglog("== VARIABLES");
    debuglog("> Appli = ".$appli);
    debuglog("> Login = ".$login);
    debuglog("> Profil = ".$profil);
    debuglog("> Etab = ".$etab);
    debuglog("> Usage = ".$usage);
    debuglog("> Route = ".$route);
    debuglog("> Rne = ".$rne);
    debuglog("> Name = ".$name);
    debuglog("> Adress = ".$adress);
    debuglog("> Cp = ".$cp);
    debuglog("> Country = ".$country);
    debuglog("> Nature Etab = ".$natureetab);
    debuglog("> Nature Serveur = ".$natureserveur);
    debuglog("> Job = ".$job);
    debuglog("> Provenance = ".$provenance);

    // Sonde DNMA
    if($activerSondednma&&!$notsondednma) {
        debuglog("== SONDE DNMA");

        pushMessageToQueue('dnma',[
            'type' => 'dnma',
            'time' => (new DateTime())->format(DateTime::ATOM),
            'route' => $route,
            'etab' => $etab,
            'appli' => $appli,
            'login' => $login,
            'profil' => $profil,
            'usage' => $usage,
        ]
        );
    }

    // Sonde Académique
    if($activerSondeaca) {
        debuglog("== SONDE ACADEMIQUE");
        pushMessageToQueue('acad',[
            'type' => 'acad',
            'time' => (new DateTime())->format(DateTime::ATOM),
            'route' => $route,
            'rne' => $rne,
            'appli' => $appli,
            'login' => $login,
            'name' => $name,
            'adress' => $adresse,
            'cp' => $cp,
            'country' => $country,
            'natureetab' => $natureetab,
            'natureserveur' => $natureserveur,
            'job' => $job,
            'profil' => $profil,
            'provenance' => $provenance
        ]);
    }

    // Sonde Académique
    if($activerSondelocal) {
        debuglog("== SONDE LOCAL");
        pushMessageToQueue('acad',[
            'type' => 'local',
            'time' => (new DateTime())->format(DateTime::ATOM),
            'route' => $route,
            'rne' => $rne,
            'appli' => $appli,
            'login' => $login,
            'name' => $name,
            'adress' => $adresse,
            'cp' => $cp,
            'country' => $country,
            'natureetab' => $natureetab,
            'natureserveur' => $natureserveur,
            'job' => $job,
            'profil' => $profil,
            'provenance' => $provenance
        ]);
    }
   